unit Packet;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls;

type
  TPacketDialog = class(TForm)
    btBefore: TButton;
    btNext: TButton;
    btCancel: TButton;
    Bevel1: TBevel;
    Label1: TLabel;
    PackList: TListBox;
    SelBtn: TButton;
    DesBtn: TButton;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Initialisation(Sender: TObject);
    procedure btCancelClick(Sender: TObject);
    procedure btNextClick(Sender: TObject);
    procedure btBeforeClick(Sender: TObject);
    procedure DesBtnClick(Sender: TObject);
    procedure SelBtnClick(Sender: TObject);
  private
    { Private-dclarations }
    procedure GetInformation;
  public
    { Public-dclarations }
  end;

var PacketDialog: TPacketDialog;

implementation

uses Decla,Generale;

{$R *.DFM}

(* closing dialog *)
procedure TPacketDialog.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 MainBack.Initialisation (Sender);
end;

(* init of dialog *)
procedure TPacketDialog.Initialisation(Sender: TObject);
var Bcl : integer;
begin
 PackList.Clear;
 if Number_Pack > 0 then
 begin
  for Bcl := 1 to Number_Pack do
  begin
   PackList.Items.Add (VPack [Bcl].Libelle);
   if VPack [Bcl].Selecte = true then
    PackList.Selected [Bcl - 1] := true;
  end;
 end;
end;

(* get all information *)
procedure TPacketDialog.GetInformation;
var Bcl : integer;
begin
 for Bcl := 0 to (PackList.Items.Count - 1) do
  VPack [Bcl + 1].Selecte := PackList.Selected [Bcl];
end;

(* Cancel button *)
procedure TPacketDialog.btCancelClick(Sender: TObject);
begin
 MainBack.Close;
end;

(* Next button *)
procedure TPacketDialog.btNextClick(Sender: TObject);
begin
 GetInformation;
 CurrentWin := 3;
 Direction := 0;
 Close;
end;

(* before button *)
procedure TPacketDialog.btBeforeClick(Sender: TObject);
begin
 GetInformation;
 CurrentWin := 2;
 Direction := 1;
 Close;
end;

(* no group button *)
procedure TPacketDialog.DesBtnClick(Sender: TObject);
var Bcl : integer;
begin
 if PackList.Items.Count > 0 then
  for Bcl := 0 to (PackList.Items.Count - 1) do
   PackList.Selected [Bcl - 1] := False;
 PackList.ItemIndex := -1;
end;

(* all groups files button *)
procedure TPacketDialog.SelBtnClick(Sender: TObject);
var Bcl : integer;
begin
 if PackList.Items.Count > 0 then
  for Bcl := 0 to (PackList.Items.Count - 1) do
   PackList.Selected [Bcl - 1] := True;
end;

end.
