/***********************************************************************
*  Sample code of how to import other phone book formats into ZOC.     *
*  A ZOC phonebk must exist with at least one record!                  *
*                                                                      *
*                                                                      *
*  If you use this for an phone book converter, please make it public! *
*                                                                      *
***********************************************************************/

typedef unsigned int BOOL;


#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "phonebk.h"

void fetch(char*buf, char *dest, int offset, int length);
int main(int, char**);



/***********************************************************************
*   Read data from an ascii input file and append them to the ZOC      *
*   phone book file (.\PHONEBK)                                        *
	// 
	// RECORD DESCRIPTION (Telemate):
	// 
	//   name pos. 1-46
	//   script 47-55
	//   log 56-64
	//   phone 65-85
	//   baud 86-91
	//   parity 92
	//   data 93
	//   stops 94
	//   emu 113 (1=Vt102, A=ansi, T=TTY)
	//
*                                                                      *
***********************************************************************/
int main(int argc, char **argv)
{
	FILE *f=NULL, *f2=NULL;
	PHONEBOOK zocbk;
	char outser[11];
	int  rc= 0, outemu;
	char	name[46-1+1+1],
			log[64-56+1+1],
			phone[85-65+1+1],
			baud[91-86+1+1],
			data[1+1],
			parity[1+1],
			stops[1+1],
			emu[1+1],
			record[200];


	// check command line argument
	if (argc!=2) {
		puts("parameter error: conv <infile>");
		return(9);
	}

	f= fopen(argv[1], "r");
	f2= fopen("PHONEBK", "ab");

	if (f && f2) {
		// read one ascii record
		fgets(record, sizeof(record), f);
		while (!feof(f)) {

			// split it into single fields
			fetch(record, name, 1, sizeof(name)-1);
			fetch(record, log, 56, sizeof(log)-1);
			fetch(record, phone, 65, sizeof(phone)-1);
			fetch(record, baud, 86, sizeof(baud)-1);
			fetch(record, parity, 92, sizeof(parity)-1);
			fetch(record, data, 93, sizeof(data)-1);
			fetch(record, stops, 94, sizeof(stops)-1);
			fetch(record, emu, 113, sizeof(emu)-1);


			////////////////////////////
			// make up ZOC entry
			////////////////////////////

			// set everything to neutral
			memset(&zocbk, 0, sizeof(zocbk));

			// set simple fields
			strcpy(zocbk.name, name);
			strcpy(zocbk.value, phone);
			strcpy(zocbk.logname, log);
			zocbk.valtype= 1;	// XDIAL

			// make up ZOC serial parameter string
			sprintf(zocbk.seropt, "%d-%s%s%s", atoi(baud), data, parity, stops);

			// convert emulation
			switch (emu[0]) {
				case 'A': zocbk.emu= 1; break;
				case '1': zocbk.emu= 2; break;
				case 'T': zocbk.emu= 3; break;
				default : zocbk.emu= 0; break;
			}


			// read next record
			fgets(record, sizeof(record), f);
		}
	}
	else {
		printf("error: %s or PHONEBK not found or access denied!\n", argv[1]);
		rc= 8;
	}

	if (f)
		fclose(f);

	if (f2)
		fclose(f2);

	return (rc);
}




/***********************************************************************
*   Fetch a few bytes (lenght) from a buffer+offset and put them       *
*   into another buffer. Remove trailing blanks and append '\0'        *
*                                                                      *
***********************************************************************/
void fetch(char*buf, char *dest, int offset, int length)
{
	int i;

	// set to zero
	memset(dest, 0, length+1);

	// copy value
	strncpy(dest, buf+offset-1, length); 

	// eat trailing blanks
	for (i=strlen(dest)-1; dest[i]==' '; i--) {
		dest[i]= '\0';
	}
}


