/***********************************************************************
*                                                                      *
*   This is an non compilable file that demonstrates, what is          *
*   necessary for a plug                                               *
*                                                                      *
*   ------------------------------------------------------------------ *
*                                                                      *
*   No copyright by Markus Schmidt, 1993                               *
*                                                                      *
***********************************************************************/


#define INCL_WINWINDOWMGR
#define INCL_DOSPROCESS
#define INCL_DOSFILEMGR

#define INCL_NOCOMMON
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>

// PIP include 
// (set PIP_INCL_PLUG to include prototypes)
#define PIP_INCL_PLUG
#include "pip.h"

// Key for OS2.INI (keep it uniqe, there might be another Ascii)
#define INI_KEY	 "Ascii by M.Schmidt"			

// declare a parameter struct for the transfer
typedef struct _TRANSFER_PARM {
	int parm1;		// define ...
	BOOL parm2;		// ... anything ...
	char parm3[10];	// ... you need
} TRANSFER_PARM;


// private functionprototypes come here
// (externs are declared in PIP.H)



/***********************************************************************
*   Introduce ourselves to the socket                                  *
*                                                                      *
*   Abstract: First entrypoint into the plug to see what it is.        *
*                                                                      *
*   Todo: Fill the PlugName, PlugDescription, PlugType and PlugBits    *
*         from the pps-structure. No internal initialisation to be     *
*         done.                                                        *
***********************************************************************/
int pipIntro(PIP_SOCKET const * const pps, PIP_PLUG * const ppp)
{
	// My name is TRANSFER, XXX TRANSFER
	strcpy(ppp->PlugName, "TRANSFER");
	strcpy(ppp->PlugDescription, "Trasfer files via xxx protocol");
	// ... and I'm a file transfer protocol
	ppp->PlugType= PIP_TYPE_PROTOCOL;

	// Tell the socket what we can do. 
	// If we can filerequest, the socket will not do it himself.
	ppp->PlugBits=	PIP_PBIT_XXXXXX |
					PIP_PBIT_XXXXXX |
					PIP_PBIT_XXXXXX;

	return (PIP_OK);
}


/***********************************************************************
*                                                                      *
*   Initialize things                                                  *
*                                                                      *
*   Abstract: Opportunity to init protocol internal stuff. No external *
*             functionality.                                           *
*                                                                      *
*   Todo: Alloc a parameter struct (static would not be reentrant)     *
*         init it with default values, then try to read preset parms   *
*         from OS2.INI                                                 *
*                                                                      *
***********************************************************************/
int pipInit(PIP_SOCKET const * const pps, PIP_PLUG * const ppp)
{
	int rc=PIP_ERROR;
	ULONG howmany;
	TRANSFER_PARM *ptp;		// pointer transfer parameter

	// alloc struct to private pointer
	ptp= ppp->PlugPrivate= malloc(sizeof(TRANSFER_PARM));

	// if success
	if (ppp->PlugPrivate!=NULL) {

		// preset values, in case no INI-Section there
		ptp->parm1= 0;
		ptp->parm2= TRUE;
		strcpy(ptp->parm2, "");

		// try to load init params from OS2.INI
		// if not found, initialisation from above remains valid
		howmany= sizeof(TRANSFER_PARM);
		PrfQueryProfileData(HINI_USERPROFILE, PIP_INIAPPL, INI_KEY,
							ppp->PlugPrivate, &howmany);

		rc= PIP_OK;
	}

	return (rc);
}


/***********************************************************************
*                                                                      *
*   Display a setup-window and store data to TRANSFER_PARM             *
*                                                                      *
*   Abstract: Give the user the opportunity to set some parameters     *
*                                                                      *
*   Todo: See if it is a PM or VIO Application, build a setup          *
*         procedure of some kind.                                      *
*                                                                      *
*                                                                      *
***********************************************************************/
int pipSetup(PIP_SOCKET const * const pps, PIP_PLUG * const ppp)
{
	HWND hwndDlg;
	int rc; 

	// this should not happen, but: never trust a socket
	if (ppp->PlugPrivate==NULL)
		return (PIP_ERROR);	// err if init failed 

	// !! the next two if's might not apply for you !!
	if (pps->hab==0 || pps->dlgHwndFrame==0)
		return (PIP_ERROR);	// err not PM appl.

	if (pps->hab!=0 && pps->dlgHwndFrame!=0)
		return (PIP_ERROR);	// err not VIO appl.

	 // open and process dialog 

	....


	// if dialog not cancelled, save new values to OS2.INI
	if (rc==DID_OK) {
		PrfWriteProfileData(HINI_USERPROFILE, PIP_INIAPPL, INI_KEY, 
					ppp->PlugPrivate, sizeof(TRANSFER_PARM));
	}

	return (PIP_OK);
}


/***********************************************************************
*   Transfer a file                                                    *
*                                                                      *
*   Abstract: Transfer bits and bytes to the remote station            *
*                                                                      *
*   Todo: Check if path,multipath is filled und eventually display     *
*         a filerequester. If you can't do a filerequester, and        *
*         no name is given, return error.                              *
*         For users convenience show a dialog box with progress or     *
*         at least, show progress via ioConPutData in the terminal     *
*         window.                                                      *
*                                                                      *
*   Parameters: Path - pointer to string containing a single file      *
*                      and pathname.                                   *
*                                                                      *
*               Multifile - Array of pointers to pathnames.            *
*                           Last pointer is NULL.                      *
*                           Process multifile like this:               *
*                           for (i=0; multifile[i]!=NULL; i++) {       *
*                                // send multifile[i]                  *
*                           }                                          *
*                                                                      *
***********************************************************************/
int pipSend(PIP_SOCKET const * const pps, PIP_PLUG * const ppp,
			unsigned char *path, unsigned char **multipath)
{
	char filename[CCHMAXPATH]= "";
	int rc= PIP_ERROR;
	TRANSFER_PARM *ptp= ppp->PlugPrivate;

	// this should not happen, but: never trust a socket
	if (ppp->PlugPrivate==NULL )
		return (rc);

	// check for proper combination of path and application type 
	if (multipath!=NULL || 			// maybe we can't multifile 
		path==NULL && pps->hab==0)	// maybe we can't filereq. outside pm
		return (rc);

	// if no filename given, ask for one
	if (path==NULL) {
		// use default upload dir for the filerequester
		strcpy(filename, pps->szUploadDir);

		// show filerequester (private function)
		path= AskFilename("File to send", filename);
	}

	if (path!=NULL) {	// could be NULL, if the user canceled

		// here we go to send our stuff
		// load the transferwindow from resource
		// read and send bytes

		// IMPORTANT!! IMPORTANT!! IMPORTANT!! IMPORTANT!!
		// IMPORTANT!! IMPORTANT!! IMPORTANT!! IMPORTANT!!
		// Since we control the application, we must ensure
		// that incoming messages are processed now and then!!
		// Put this loop to the core of your processing
		while (WinPeekMsg(pps->hab, &qmsg, 0, 0, 0, PM_REMOVE) ) {
			WinDispatchMsg(pps->hab, &qmsg);
		}
		// IMPORTANT!! IMPORTANT!! IMPORTANT!! IMPORTANT!!
		// IMPORTANT!! IMPORTANT!! IMPORTANT!! IMPORTANT!!

	}

	return (rc);
}


/***********************************************************************
*                                                                      *
*   Receive a file                                                     *
*                                                                      *
*   Abstract: Receive bits and bytes from the remote station           *
*                                                                      *
*   Todo: Check if path,multipath is filled und eventually display     *
*         a filerequester. If you can't do a filerequester, and        *
*         no name is given, return error.                              *
*         For users convenience show a dialog box with progress or     *
*         at least, show progress via ioConPutData in the terminal     *
*         window.                                                      *
*                                                                      *
*   Parameters: Path - pointer to string containing a single file      *
*                      and pathname.                                   *
*                                                                      *
*               Multifile - Array of pointers to pathnames.            *
*                           Last pointer is NULL.                      *
*                           Process multifile like this:               *
*                           for (i=0; multifile[i]!=NULL; i++) {       *
*                                // send multifile[i]                  *
*                           }                                          *
*                                                                      *
***********************************************************************/
int pipReceive(PIP_SOCKET const * const pps, PIP_PLUG * const ppp,
				unsigned char *path, unsigned char **multipath)
{

	// see pipSend-Function

	return (PIP_ERROR);
}


/***********************************************************************
*                                                                      *
*   Free the parameter block                                           *
*                                                                      *
*   Abstract: Opportunity to clean protocol internal mess. No external *
*             functionality required.                                  *
*                                                                      *
*   Todo: Free the parameter block                                     *
*                                                                      *
***********************************************************************/
int pipCleanup(PIP_SOCKET const * const pps, PIP_PLUG * const ppp)
{
	int rc= PIP_ERROR; 

	if (ppp->PlugPrivate!=NULL) {
		free(ppp->PlugPrivate);
		ppp->PlugPrivate= NULL;
		rc= PIP_OK;
	}

	return (rc);
}
