/*
	MR/2 - MQWK.CMD

	Copyright (c) 1994, Nick Knight
	All Rights Reserved.

	Author: 	Nick Knight
	Created:	12/28/93
	Usage:		mqwk target.qwk packet1.qwk packet2.qwk [packet3.qwk ...]
	Purpose:	mqwk.cmd will merge two or more QWK packets into a single
				packet.

	US Mail:	Nick Knight, 1823 David Ave.,  Parma, Ohio 44134
	Fidonet:	1:157/2 or 1:/157/200
	Internet:	nick.knight@pcohio.com
	Compuserve: 76066,1240
	BBS:		Private messages on Nerd's Nook, 356-1772 or 356-1872
*/

/*****	COMMANDS FOR USING PKZIP AND PKUNZIP (DEFAULT) *********/
pkunzip = 'pkunzip -n'
pkzip = 'start /min /b /c pkzip -x*.ndx -xmr2*.*'
pkziptrailer = '>mqwk.log'

/*****	 ALTERNATIVE COMMANDS FOR USING INFOZIP *********/
/*
pkunzip = 'unzip -n'
pkzip = 'zip -j'
pkziptrailer = '-x *.ndx mr2*.* >mqwk.log'
*/

dirname = 'TMP$$'

/***********************************************************************/
/*						M E R G E	 Q W K							   */
/***********************************************************************/
echo off

rest = ''
next = ''

parse arg target source1 source2 rest

if ((source2 = "") | (source1 = "") | (target = "")) then do
	say ' '
	say 'usage: mqwk makenew.qwk source1.qwk source2.qwk [source3.qwk ...]'
	say ' '
	return -1
end

Say ' '
Say 'MQwk v1.01 - QWK Packet merge utility'
Say 'Copyright (c) 1994, Nick Knight - All Rights Reserved.'
Say ' '

if stream(target,'c','query exists') <> "" then do
	say '** WARNING:  Target file exists.'
end

control = 'Control.dat'
ctrl_tmp1 = 'c1$$$tmp.dat'
ctrl_tmp2 = 'c2$$$tmp.dat'

msg = 'Messages.dat'
wip = 'Messages.wip'
s1 = stream(source1,'c','query exists')
s2 = stream(source2,'c','query exists')

if s1 == "" then do
	say '** WARNING:  Source file' source1 'does not exists.'
	return 1
end

if s2 == "" then do
	say '** WARNING:  Source file' source2 'does not exists.'
	return 2
end

'mkdir' dirname '2>nul'
'for %%i in ('||dirname||'\*.*) do del %%i 2>nul'

'cd' dirname

say 'Unpacking' s1 '...'
pkunzip s1
'del *.ndx 2>nul'
'ren' msg wip
'ren' Control ctrl_tmp1

do while s2 <> ""

	say 'Unpacking' s2 '...'
	pkunzip s2
	'del *.ndx 2>nul'
	'ren' Control ctrl_tmp2

	say 'Merging message bases ...'

	status = stream(wip,'c','open')

	/* a block of nulls is often (always?) appended at the end. */
	/* read back a block at a time until a valid block is found. */
	/* leave "next" write position just past last valid block. */

	testback = 129
	status = stream(wip,'c','seek <'testback)
	block = charin(wip,,128)
	do while (c2d(substr(block,2,1)) = 0 | c2d(substr(block,2,1)) = 255)
		testback = testback + 128
		status = stream(wip,'c','seek <'testback)
		block = charin(wip,,128)
	end

	status = stream(msg,'c','open read')
	status = stream(msg,'c','seek 128')

	do while (chars(msg) > 0)
		block = charin(msg,,128)
		ctr = charout(wip,block)
		if ctr <> 0 then do
			call beep 262,200
			say ' '
			say '** Warning: Write error, probably disk full.'
			say 'Packet merge cannot be completed'
			say ' '
			exit -1
		end
	end

	status = stream(wip,'c','close')
	status = stream(msg,'c','close')

	'del' msg
	erc = MControl(control, ctrl_tmp1, ctrl_tmp2)
	'del' ctrl_tmp1
	'del' ctrl_tmp2
	'ren' control ctrl_tmp1

	status = next_file(rest)

end

'ren' ctrl_tmp1 Control
'ren' wip msg

'cd ..'
if target <> "~" then do
	pkzip target dirname||'\*.*' pkziptrailer
/*	'for %%i in ('||dirname||'\*.*) do del %%i >nul' */
/*	'rmdir' dirname */
end

return 0

/******************************/
/* Procedure next_file		  */
/******************************/
next_file:
parse arg s1 rest2
rest = rest2
'cd ..'
s2 = ""
if s1 <> "" then do
	s2 = stream(s1,'c','query exists')
	say ' '
end
'cd' dirname
return 0

MControl:  PROCEDURE EXPOSE ctrl_tmp1 ctrl_tmp2 control
/***********************************************************************/
/*						  M E R G E    C O N F I G					   */
/***********************************************************************/
echo off

target = ARG(1)
src1 = ARG(2)
src2 = ARG(3)

cs1 = ''
cs2 = ''
ctmp = 'o1$$tmp.dat'
cwip = 'ctl$$tmp.dat'
iline = ''
line1 = ''
line2 = ''
nbr_conferences_1 = 0
nbr_conferences_2 = 0
c1 = 0
c2 = 0

say 'Merging Control.dat files ...'

if stream(target,'c','query exists') <> "" then do
	say '** WARNING:  Target file exists.'
end

cs1 = stream(ctmp,'c','query exists')
if cs1 <> "" then do
	'del' cs1 '>nul'
end

cs1 = stream(cwip,'c','query exists')
if cs1 <> "" then do
	'del' cs1 '>nul'
end

cs1 = stream(src1,'c','query exists')
cs2 = stream(src2,'c','query exists')

if cs1 == "" then do
	say '** WARNING:  Source file' src1 'does not exists.'
	return 1
end

if cs2 == "" then do
	say '** WARNING:  Source file' src2 'does not exists.'
	return 2
end

status = stream(cwip,'c','open write')

status = stream(cs1,'c','open read')
status = stream(cs2,'c','open read')
status = stream(ctmp,'c','open write')

say 'Creating control header ...'

ctr = 10
do while ctr > 0
	iline = linein(cs1)
	erc = lineout(cwip,iline)
	ctr = ctr - 1
end

iline = linein(cs1)
nbr_conferences_1 = iline;

ctr = 11
do while ctr > 0
	iline = linein(cs2)
	ctr = ctr - 1
end

nbr_conferences_2 = iline
prev_conference = -1
totctr = 0
line1 = linein(cs1)
c1 = line1
line2 = linein(cs2)
c2 = line2

say 'Merging conferences ...'

do while 1
	if c1 > c2 then do
		erc = lineout(ctmp,line2)
		totctr = totctr + 1;
		line2 = linein(cs2)
		erc = lineout(ctmp,line2)
		line2 = linein(cs2)
		c2 = line2
		nbr_conferences_2 = nbr_conferences_2 - 1
	end
	else if c1 < c2 then do
		erc = lineout(ctmp,line1)
		totctr = totctr + 1;
		line1 = linein(cs1)
		erc = lineout(ctmp,line1)
		line1 = linein(cs1)
		c1 = line1
		nbr_conferences_1 = nbr_conferences_1 - 1
	end
	else do
		erc = lineout(ctmp,line2)
		totctr = totctr + 1;
		line2 = linein(cs2)
		erc = lineout(ctmp,line2)
		line2 = linein(cs2)
		c2 = line2
		nbr_conferences_2 = nbr_conferences_2 - 1

		line1 = linein(cs1)
		line1 = linein(cs1)
		c1 = line1
		nbr_conferences_1 = nbr_conferences_1 - 1
	end
	if nbr_conferences_1 < 1 then do
		if nbr_conferences_2 < 1 then do
			leave
		end
		c1 = 30000
	end
	if nbr_conferences_2 < 1 then do
		c2 = 30000
	end
end

say 'Appending control trailer ...'

erc = lineout(ctmp,line1)

do while lines(cs1) > 0
	line1 = linein(cs1)
	erc = lineout(ctmp,line1)
end

status = stream(cs1,'c','close')
status = stream(cs2,'c','close')

say 'Combining header, conferences and trailer ...'

iline = totctr
erc = lineout(cwip,iline)

status = stream(ctmp,'c','close')
status = stream(ctmp,'c','open read')

do while lines(ctmp) > 0
	iline = linein(ctmp)
	erc = lineout(cwip,iline)
end

status = stream(cwip,'c','close')
status = stream(ctmp,'c','close')

'copy' cwip target '> nul'
'del' ctmp '>nul'
'del' cwip '>nul'

Say 'Control file "'||target||'" has been created.'

return 0


