/* ENGLISH.CMD: Instalacin de PLUMA en espaol. */

'@Echo Off'

/* Ttulo del objeto a instalar . */

Title = 'Pluma 1.12'


/* Cargar REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Inicializacin */
 
Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say 'Instalando PLUMA...'
Say ''


/* Verificar la existencia de los ficheros. */

Language = 'ESPANOL'

Result = SysFileTree( 'PLUMA.EXE', 'Files', 'F' )
If Files.0 = 0 Then
   Do
   Say 'ERROR: No se encuentra PLUMA.EXE!'
   Signal DONE
   End

Result = SysFileTree( Language".DLL", 'Files', 'F' )
If Files.0 = 0 Then
   Do
   Say 'ERROR: No se encuentra 'Language'.DLL!'
   Signal DONE
   End

Result = SysFileTree( Language".HLP", 'Files', 'F' )
If Files.0 = 0 Then
   Do
   Say 'ERROR: No se encuentra 'Language'.HLP!'
   Signal DONE
   End

/* Preguntar el directorio destino. */
 
Say 'Introduzca, por favor, el nombre completo del directorio en donde'
Say '  desea instalar PLUMA (por defecto es C:\OS2\APPS): '
Pull Directory
If Directory = "" Then Directory = 'C:\OS2\APPS'


/* Crear el directorio si es necesario. */

Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
   Do
   Result = SysMkDir( Directory )
   if Result == 0 Then
      Do
      End
   Else
      Do
      Say 'ERROR: Imposible de crear el directorio destino!'
      Signal DONE
      End
   End
Say ''


/* Completar la instalacin. */

Say 'Copinando PLUMA a ' Directory '...'
Copy PLUMA.EXE Directory                   '1>NUL'
Copy PLUMA.ICO Directory                   '1>NUL'
Copy Language".DLL" Directory"\PLUMA.DLL"  '1>NUL'
Copy Language".HLP" Directory"\PLUMA.HLP"  '1>NUL'
Copy Language".DOC" Directory"\PLUMA.DOC"  '1>NUL'

Result = SysFileTree( Language".INF", 'Files', 'F' )
If Files.0 > 0 Then
   Do
   Copy Language".INF" Directory"\PLUMA.INF"  '1>NUL'
   End

Say 'Creating program folder...'
Type = 'WPFolder'
Folder = '<WP_DESKTOP>'
Parms = "OPEN=ICON;OBJECTID=<PLUMAF>;ICONFILE="Directory"\PLUMA.ICO;"
Result = SysCreateObject( Type, 'Pluma', Folder, Parms, 'ReplaceIfExists' )
If Result != 1 Then
   Say 'ERROR: Folder not created.'

Say 'Creando el objeto del programa...'
Type = 'WPProgram'
Folder = '<PLUMAF>'
Parms = "MINWIN=DESKTOP;PROGTYPE=PM;EXENAME="Directory"\PLUMA.EXE;STARTUPDIR="Directory";OBJECTID=<PLUMA>;NOPRINT=YES;ASSOCTYPE=Pluma;"
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
If Result != 1 Then
   Say 'ERROR: No se ha podido crear el objeto!'

Say 'Creating documentation objects...'
Type = 'WPShadow'
Parms = "SHADOWID="Directory"\PLUMA.DOC;OBJECTID=<PLUMAD>;"
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
If Result != 1 Then
   Say 'ERROR: Shadow not created.'

Result = SysFileTree( Directory"\PLUMA.INF", 'Files', 'F' )
If Files.0 > 0 Then Do
  Parms = "SHADOWID="Directory"\PLUMA.INF;OBJECTID=<PLUMAI>;"
  Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
  If Result != 1 Then Do
    Say 'ERROR: Shadow not created.'
    End
  End
 
Signal DONE

FAILURE:
Say 'Error en REXX.'
Signal DONE

HALT:
Say 'REXX interrumpido.'
Signal DONE

SYNTAX:
Say 'Error de sntaxis REXX.'
Signal DONE

DONE:
Exit
