NAME
     arc - pc archive utility

SYNOPSIS
     arc a|m|u|f|d|x|e|r|p|l|v|t|c [ biswnoq ] [ gpassword ]
     archive [ filename ...]

DESCRIPTION
     Arc is a general archive and file compression utility, used
     to maintain a compressed archive of files.  An archive is a
     single file that combines many files, reducing storage space
     and allowing multiple files to be handled as one.  Arc uses
     one of several compression methods for each file within the
     archive, based on whichever method yields the smallest
     result.

INSTRUCTIONS
     Execute arc with no arguments for fairly verbose, usable
     instructions.

COMMAND SWITCHES
     a  add files to archive.  Copies the indicated files to the
        archive.

     m  move files to archive.  Same as 'a' switch except that
        the files are deleted from the directory as they are
        moved to the archive.

     u  update files in archive.  This switch will replace
        archived files when the named file is newer than the
        archived copy.  New files will be added automatically.

     f  freshen files in archive.  Same as 'u' except that new
        files will not be added.

     d  delete files in archive.  The named files are removed
        from the archive.

     x,e
        extract files from archive.  The named files are
        extracted from the archive and created in the current
        directory in an uncompressed state.

     r  run one file with arguments from archive.  Any program
        may be executed directly from the archive.  The parame-
        ters given after the program name are passed to the pro-
        gram without modification.

     p  copy files from archive to standard output.  Useful with
        I/O redirection. A form-feed is appended after each file,
        to ease use with printers.

     l  list files in archive.  Limited information listing of
        files contained in an archive.  Displays the filename,
        original length, and date last modified.  If the 'n'
        option (see below) is used, only the filename is
        displayed.

     v  verbose listing of files in archive.  Complete informa-
        tion listing of files contained in an archive.  Displays
        the filename, original length, storage method, storage
        factor (% savings), compressed size, date, time, and CRC.

     t  test archive integrity.  Computes CRC values for each
        member of the archive and compares against the previously
        saved value.

     c  convert entry to new packing method.  Convert files
        stored with older methods to newer methods that are more
        efficient. Also useful for files previously archived with
        the 's' option.

OPTIONS
     b  retain backup copy of archive.  Keep the original archive
        file and rename to .BAK.  This switch may be used with
        the following commands:  a, m, u, f, d, c.

     i  suppress image mode.  This switch causes files to be
        treated as text files, and will translate their end-of-
        line sequence. (Unix's '\n' vs. '\r\n' used on many other
        systems.)  The default is to perform no translation when
        compressing or extracting files.  This option makes deal-
        ing with text files much nicer, though the 'tr' command
        can also be used. ('\r' in makefiles and C source code is
        such a nuisance...)

     s  suppress compression.  This forces new files to be saved
        using Method 2 (no compression).  This switch may be used
        with the following commands:  a, m, u, f, c.

     w  suppress warning messages.  This switch will keep warning
        messages from being displayed which is the default.  Most
        warnings concern the deletion or existence of files with
        the same name.

     n  suppress notes and comments.  This switch will keep use-
        ful notes from being displayed which is the default.
        Most notes indicate what stage of compression is being
        run (analyze, compaction, storage).

     o  overwrite existing files when extracting.  This switch
        will make existing files silently get overwritten,
        instead of asking for confirmation, which is the default.

     q  force Squash compression method.  This switch causes the
        Squash compression method to be used, instead of Crunch,
        which is the default.

     g  encrypt/decrypt archive entry.  This is used to encode
        files so that others may not read them.  BE CAREFUL!
        This must be the last parameter in the switches because
        everything following is part of the password.

PROGRAMMING NOTES
     Arc Version 2 differs from version 1 in that archive entries
     are automatically compressed when they are added to the
     archive, making a separate compression step unecessary.  The
     nature of the compression is indicated by the header version
     number placed in each archive entry, as follows:
              1 = Old style, no compression
              2 = New style, no compression
              3 = Compression of repeated characters only
              4 = Compression of repeated characters plus Huffman SQueezing
              5 = Lempel-Zev packing of repeated strings (old style)
              6 = Lempel-Zev packing of repeated strings (new style)
              7 = Lempel-Zev Williams packing with improved hash function
              8 = Dynamic Lempel-Zev packing with adaptive reset
              9 = Squashing

     Type 5, Lempel-Zev packing, was added as of version 4.0

     Type 6 is Lempel-Zev packing where runs of repeated charac-
     ters have been collapsed, and was added as of version 4.1

     Type 7 is a variation of Lempel-Zev using a different hash
     function which yields speed improvements of 20-25%, and was
     added as of version 4.6

     Type 8 is a different implementation of Lempel-Zev, using a
     variable code size and an adaptive block reset, and was
     added as of version 5.0

     Type 9 is another variation of Lempel-Zev, using a larger
     hash table. This method was developed by Phil Katz, and is
     not supported by the "official" ARC programs.

     Arc will look for environment variables named ARCTEMP or
     TMPDIR, which, if present, indicates the pathname where tem-
     porary files should be created. This is typically the loca-
     tion of a RAMdisk on a microcomputer, "/tmp/" or left unset.

     See the included documentation file for more details.

HISTORY
     Arc has been in use in the CP/M and MSDOS world for many
     years.  Thom Henderson developed the original version, but
     it is important to note that arc is based on the file
     compression theories developed by Huffman, Welch, Knott,
     Knuth, and many other scientists. This implementation is
     based on version 5.21 of the MSDOS program.

BUGS
     Arc behaves just like the PC version of the program; all
     functions of the "usage" display are working.  Full compati-
     bility with PC ARC files is maintained, the price for which
     is that arc doesn't like long filenames, and can only
     archive files with names of up to 12 characters.  It will
     *sometimes* do The Right Thing with them, but I suggest you
     put long-winded filenames in a "shar" before arcing them.

     There shouldn't be any problems, (hah!) but if you find any,
     please send them to me at:

          hyc@umix.cc.umich.edu      {rutgers, uunet}!umix!hyc


AUTHORS
     Original MSDOS program by Thom Henderson
     COPYRIGHT(C) 1985-87 by System Enhancement Associates; ALL
     RIGHTS RESERVED

     Original Lempel-Zev code derived from compress 4.0.  Modi-
     fied to support Squashing by Dan Lanciani (ddl@harvard.edu)
     Ported from MSDOS by Howard Chu (umix!hyc), with help from
     John Gilmore (hoptoad!gnu), James Turner (daisy!turner) and
     others.

