/**/
call RxFuncAdd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
call SysLoadFuncs

Call SysCls
lang = "English"

Say
Say "         AF - The Archive Folder - Installation program"
Say "         =============================================="
Say
Say "  This script will copy the program files to the installation directory,"
Say "  create a program object and create associations and templates for the"
Say "  Archive Folder."
Say
Call charout, "  Do you want to continue? (y/N): "

answer = SysGetKey(echo)


if answer <> "y" & answer <> "Y" then return
Say

say "  Enter the FULL path to the directory where you want "
say "  AF installed or press ENTER to install from current directory."
Call charout, "  Directory (no trailing backslash!): "
pull InstallDir

if length(InstallDir) = 0 then do
  DontCopy = 1
  InstallDir = Directory()
end
else do
  DontCopy = 0
  if SysFileTree(InstallDir, dir, D) <> 0 then do
    Say "Out of memory!"
    return
  end
  if dir.0 = 0 then do
    Call charout, "  "InstallDir "doesn''t exist! Do you want to create it? (y/N): "
    answer = SysGetKey(echo);say
    if answer <> "y" & answer <> "Y" then return
    if SysMkDir(InstallDir) <> 0 then do
      Say "  Error creating" InstallDir"!"
      return -1
    end
  end
end

if exists(lang'.dll') then
  'copy' lang'.dll' InstallDir'\af.dll'
else do
  say "  Unable to locate" lang'.dll'
  return -1
end

if \DontCopy Then do
  if exists(lang'.cmd') then
    'copy' lang'.cmd' InstallDir'\'lang'.cmd'
  else do
    say "  Unable to locate" lang'.cmd'
    return -1
  end

  if exists('af.exe') then
    'copy af.exe' InstallDir
  else do
    say "  Unable to locate af.exe"
    return -1
  end

  if exists('af.hlp') then
    'copy af.hlp' InstallDir
  else do
    say "  Unable to locate af.hlp"
    return -1
  end

  if exists('editarc.exe') then
    'copy af.hlp' InstallDir
  else do
    say "  Unable to locate editarc.exe"
    return -1
  end

  if exists('beta.txt') then
    'copy beta.txt' InstallDir
  else do
    say "  Unable to locate beta.txt"
  end

  if exists('install.txt') then
    'copy install.txt' InstallDir
  else do
    say "  Unable to locate install.txt"
  end

  if exists('whatsnew') then
    'copy whatsnew' InstallDir
  else do
    say "  Unable to locate WhatsNew"
  end

  if exists(archiver.bb2) then
    'copy archiver.bb2' InstallDir
  else do
    say "  Unable to locate ARCHIVER.BB2"
    return -1
  end
end

EAT_ASCII = REVERSE('FFFD'X)


TypeText = 'Archive'
Type     = EAT_ASCII || d2c(length(TypeText)) || '00'x || TypeText
Name     = "Archive Templates"
LongName = EAT_ASCII || d2c(length(Name)) || '00'x || Name

if SysFileTree("TEMPLATE", dir, D) <> 0 then do
  Say "  Not enough memory!"
  return
end

if \ SysCreateObject( "WPFolder", "Archive Folder", "<WP_DESKTOP>","OBJECTID=<AF_FOLDER>;","u")
then do
  Say "  Error creating folder!"
  return
end
else
  say "  Created template folder."

rc = SysCreateObject( "WPProgram", "Archive Folder", "<AF_FOLDER>","PROGTYPE=PM;EXENAME="InstallDir"\AF.EXE;STARTUPDIR="Installdir";ASSOCTYPE=Archive;ASSOCFILTER=*.lzh,*.zip,*.arc,*.arj,*.rar;OBJECTID=<AF>;","r")
if \rc then do
  Say "  Error creating program object!"
  return
end
else
  say "  Created program object for Archive Folder."

rc = SysCreateObject( "WPProgram", "Archiver Registry", "<AF_FOLDER>","PROGTYPE=PM;EXENAME="InstallDir"\EDITARC.EXE;STARTUPDIR="Installdir";ASSOCTYPE=Archive;ASSOCFILTER=*.lzh,*.zip,*.arc,*.arj,*.rar;OBJECTID=<AF_REG>;","r")
if \rc then do
  Say "  Error creating program object for Archiver Registry!"
  return
end
else
  say "  Created program object for Archiver Registry."

if dir.0 = 0 then do
  if \ SysCreateObject( "WPFolder", "TEMPLATE", InstallDir,"OBJECTID=<AF_TEMPS>;","u")
  then do
    Say "  Error creating template folder!"
    say "   Do you have another AF template folder somewhere else?"
    return
  end
  else
    say "  Created template folder."
end
else do
  if \ SysSetObjectData(InstallDir"\TEMPLATE", "OBJECTID=<AF_TEMPS>;") then
    Say "  Error Setting ObjectID on template folder!"
  else
    say "  Setting object ID on template folder."
end

if SysPutEA( "TEMPLATE", ".LONGNAME", LongName ) <> 0 then
  Say "  Error setting .LONGNAME Extended Attribute!"
else
  say "  Setting .LONGNAME Extended Attribute on template folder."

if \ SysCreateObject( "WPShadow", "Archive templates", "<AF_FOLDER>", "SHADOWID=<AF_TEMPS>;OBJECTID=<AF_TEMPS_SHADOW>;","u" ) then
  Say "  Error creating shadow of template folder on the desktop!"

Call SysOpenObject "<AF_TEMPS>", 1, 1

file = "Archive.Arj"; ID = "<AF_ARJ_TEMPLATE>"
call SetData file ID
file = "Archive.Arc"; ID = "<AF_ARC_TEMPLATE>"
call SetData file ID
file = "Archive.Rar"; ID = "<AF_RAR_TEMPLATE>"
call SetData file ID
file = "Archive.Zip"; ID = "<AF_ZIP_TEMPLATE>"
call SetData file ID
file = "Archive.Lzh"; ID = "<AF_LZH_TEMPLATE>"
call SetData file ID

Say "  Archive Folder successfully installed!"
Say
Say "  Now copy the ARCHIVER.BB2 file to a directory in your PATH or DPATH."
Say
'@pause'

return


SetData:
parse arg file ID
updated = 0
if \ exists( "TEMPLATE\"file ) then do
  say "  Creating template" file "with object ID" ID
  if \ SysCreateObject( "WPDataFile", file, "<AF_TEMPS>","TEMPLATE=YES;TYPE=Archive;OBJECTID="ID";","r")
    then Say "  Error creating "file" template! It may already exist."
  else updated = 1
end
else do
  say "  Updating template" file "with object ID" ID
  if \ SysSetObjectData(InstallDir"\TEMPLATE\"file, "OBJECTID="ID";TEMPLATE=YES;TYPE=Archive;") then
    Say "  Error Setting template data!"
  else updated = 1
end
if updated then do
  if SysPutEA( "TEMPLATE\"file, ".TYPE", Type ) <> 0 then
    say "Error putting .TYPE EA"
end
return

exists:
arg filename
if stream( filename, 'c', 'query exists') <> ''
  then return 1
else return 0

