/* INSTALL.CMD **** Install program for Night Vision **************************/

call RxFuncAdd "SysLoadFuncs","RexxUtil","SysLoadFuncs"
call SysLoadFuncs

PGMNAME = "Night Vision"
EXEFILE = "NVSN.EXE"
HLPFILE = "NVSN.HLP"
DBFILE  = "NVSN.DB"
CTYFILE = "NVSN.CTY"
INIFILE = "NVSN.INI"

say "This install program creates a """ || PGMNAME || """ program object"
say "(icon) on your desktop.  Do you wish to proceed?  (y/n)"
pull answer .
answer = substr(answer, 1,1)
if answer <> 'Y' then exit 1

/* Get the current directory */
curdir = directory()

/* Check for EXEFILE */
Call SysFileTree curdir || '\' || EXEFILE, file, 'F'
if file.0 = 0 then
do
  say "Can not locate" EXEFILE "(Program file)"
  exit 1
end

/* Check for HLPFILE */
Call SysFileTree curdir || '\' || HLPFILE, file, 'F'
if file.0 = 0 then
do
  say "Can not locate" HLPFILE "(Help file)"
  exit 1
end

/* Check for DBFILE */
Call SysFileTree curdir || '\' || DBFILE, file, 'F'
if file.0 = 0 then
do
  say "Can not locate" DBFILE "(Sky database)"
  exit 1
end

/* Check for CTYFILE */
Call SysFileTree curdir || '\' || CTYFILE, file, 'F'
if file.0 = 0 then
do
  say "Can not locate" CTYFILE "(City database file)"
  say "Do you still wish to proceed?  (y/n)"
  pull answer .
  answer = substr(answer, 1,1)
  if answer <> 'Y' then exit 1
end

/* Check for INIFILE */
Call SysFileTree curdir || '\' || INIFILE, file, 'F'
if file.0 <> 0 then
do
  say "Reset" PGMNAME "to original defaults?  (y/n)"
  pull answer .
  answer = substr(answer, 1,1)
  if answer = 'Y' then
    "@ERASE" INIFILE
end

/* Create object */
if SysCreateObject("WPProgram", PGMNAME, "<WP_DESKTOP>",,
                   "EXENAME="curdir||'\'||EXEFILE||";"||,
                   "STARTUPDIR="curdir, "update") then
do
  say PGMNAME "has been added to your desktop."
  say "Double click on this icon to start the program."
end
else
  say "Can not add" PGMNAME "to your desktop."

exit 0
