/*
@echo off
cls
echo.
echo Ŀ'
echo                    POP-Play v0.90 installation                       '
echo Ĵ'
echo                                                                      '
echo  ERROR: You do not have REXX support installed.                      '
echo                                                                      '
echo  Before you can run this install script, you must install REXX       '
echo  support from the 'Selective Install' program object.                '
echo                                                                      '
echo '
echo.
pause
exit
*/

/*
 * Install.CMD
 * Installs POP-Play
 */


TRACE n
signal on HALT
call LoadLibs

/*
 * get the cmd line
 */
parse arg destdir sourcedir

/*
 * find out where this cmd file resides
 */
parse source . . thispgm

if sourcedir = ' ' then do
  sourcedir = substr(thispgm, 1, (length(thispgm) - (length('install.cmd') + 1)));
  say sourcedir
end


/*
 * do the intro screen
 */
  call SysCls
  say 'Ŀ'
  say '                   POP-Play v0.90 installation                       '
  say 'Ĵ'
  say '                                                                     '
  say '   This is the install program for the POP-Play.                     '
  say '   It will install the POP-Play files on your hard disk              '
  say '                                                                     '
  say '   Please follow through the screens and answer the prompts as       '
  say '   they appear.                                                      '
  say '                                                                     '
  say '                                                                     '
  say '                                                                     '
  say '                                                                     '
  say '                                                                     '
  say '   Press any key to continue, or Ctrl+C to exit.                     '
  say ''
'@pause > NUL'

/*
 * Get the destination directory
 */
if destdir = ' ' then do
  call SysCls
  say 'Ŀ'
  say '                   POP-Play v0.90 installation                       '
  say 'Ĵ'
  say '                                                                     '
  say '       Please enter the name of the directory you wish to            '
  say '       install POP-Play to, at the prompt below.                     '
  say '                                                                     '
  say ''
  say '  Directory to install to (Default = C:\POPPLAY): '
  say ''
  parse pull destdir
  /* if they accepted the default */
  if destdir = ' ' then destdir = 'C:\POPPLAY'
end

if sourcedir = ' ' then do
  thisdir = directory()
  call SysCls
  say 'Ŀ'
  say '                   POP-Play v0.90 installation                       '
  say 'Ĵ'
  say '                                                                     '
  say '       Please enter the name of the directory where the              '
  say '       installation files are, at the prompt below:                  '
  say '                                                                     '
  say ''
  say '  Directory to install from (Default = 'thisdir'): '
  say ''
  parse pull sourcedir
  /* if they accepted the default */
  if sourcedir = ' ' then do
    sourcedir = thisdir
  end
end

/*
 * is the dest. dir a valid path?
 */
if stream(sourcedir'\install.cmd', 'c', 'query exists') = '' then do
  call DspError
  say ' Could not verify that the installation files are actually in'
  say ' the directory ' sourcedir '.'
  say ''
  say ' Please re-run this program from the directory where it and the'
  say ' other installation files are stored,'
  say ' or run it and specify <source dir> <dest dir> as arguments.'
  say ''
  say ' Press ENTER to exit:'
  pull MyFinger
  call SysCls
  exit 0
end


/*
 * make sure the source and destination path is good
 */
sourcedir=PathAddSlash(sourcedir)
destdir=PathAddSlash(destdir)

/*
 * Confirm the user's selections
 */
call SysCls
  say 'Ŀ'
  say '                   POP-Play v0.90 installation                       '
  say 'Ĵ'
  say '                                                                     '
  say '     POP-Play will be installed using the following settings:        '
  say '                                                                     '
  say ''
  say '  Source directory: ' PathDelSlash(sourcedir)
  say '  Dest. directory : ' PathDelSlash(destdir)
  say ''

if(AskYN('Okay to continue') = 0) then do
  say
  say 'Installation cancelled.'
  exit
end

call SysCls
say ''
say 'Installing POP-Play...'

/*
 * Check the output directory
 */
rc = SysMkDir(PathDelSlash(destdir))
if rc \= 0 then do
  select
    when rc = 3   then msg = 'Path not found.'
    when rc = 5   then msg = 'Access denied.'
    when rc = 26  then msg = 'Not a DOS disk.'
    when rc = 87  then msg = 'Invalid parameter specified.'
    when rc = 108 then msg = 'Drive Locked.'
    when rc = 206 then msg = 'Filename exceeds range.'
    otherwise msg = 'Unknown error (???)'
  end
  /* if rc==5, it's probably because the directory exists already.  */
  if rc <> 5 then do
    say 'Error creating destination directory. ' msg
    if askNY('Proceed anyway?') = 0 then do
      exit
    end
  end
end

basedir = destdir

say 'Source dir: 'PathDelSlash(sourcedir)
say 'Dest dir  : 'PathDelSlash(basedir)
say ''

/*
 * Copy the files
 */
say
say 'Install is copying files, please wait...'
call CopyFile 'POPPLAY.EXE',  sourcedir, basedir
call CopyFile 'POPPLAY.CFG',  sourcedir, basedir
call CopyFile 'POPPLAY.DLL',  sourcedir, basedir
call CopyFile 'POPPLAY.LP',   sourcedir, basedir
call CopyFile 'VROBJ.DLL',    sourcedir, basedir
call CopyFile 'README.TXT',   sourcedir, basedir

'@e.exe '||destdir||'Readme.txt'


/*--------------------*/
/*
 * Create the objects on the desktop
 */
say
say 'Creating the program folder,'
x = SysCreateObject("WPFolder",,
                    "POP-Play",,
                    "<WP_DESKTOP>",,
                    "OBJECTID=<POP-Play>;OPEN=DEFAULT", "replace")

if x = 0 then do
  call DspError
  say 'Unable to create POP_play folder; cancelling.'
  pause
  exit
end

/*--------------------*/
say 'Adding the'
say 'Callme program file,'
path=PathDelSlash(destdir)
x = SysCreateObject("WPProgram",,
     "POP-Play",,
     "<POP-Play>",,
     "EXENAME="||destdir||"POPPLAY.EXE;STARTUPDIR="||PathDelSlash(destdir))

if x = 0 then do
  call DspError
  say 'Unable to create POP-Play program; cancelling.'
  pause
  exit
end

/*--------------------*/
say 'Adding the'
say 'Callme autostart program file,'
path=PathDelSlash(destdir)
x = SysCreateObject("WPProgram",,
     "POP-Play autostart",,
     "<POP-Play>",,
     "EXENAME="||destdir||"POPPLAY.EXE;"||,
     "STARTUPDIR="||PathDelSlash(destdir)||";"||,
     "PARAMETERS=/run /min")

if x = 0 then do
  call DspError
  say 'Unable to create POP-Play autostart program; cancelling.'
  pause
  exit
end

/*--------------------*/
say 'ReadMe file,'
x = SysCreateObject("WPProgram",,
                    "Read Me First",,
                    "<POP-Play>",,
                    "EXENAME=E.EXE;PARAMETERS="||destdir||"README.TXT")

if x = 0 then do
  call DspError
  say 'Unable to create README program; cancelling.'
  pause
  exit
end

/*--------------------*/
GoodBye:
  call DspGoodBye

exit

/*----------------------------------------------*/
/*-- FUNCTION:                                --*/
/*-- LoadLibs                                 --*/
/*-- ACTION:                                  --*/
/*-- loads the libraries needed by this REXX  --*/
/*----------------------------------------------*/
LoadLibs:
  if RxFuncQuery('SysLoadFuncs') THEN
  do
    /*-- load the load-function --*/
    CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
    /*-- load the Sys* utilities --*/
    CALL SysLoadFuncs
  end
return

HALT:
  say
  say 'Program cancelled; Interrupted by user.'
  exit

/*-----------------------------------------------------------------------------*/
/*-- CopyFile                                                                --*/
/*-----------------------------------------------------------------------------*/
CopyFile: parse Arg ArgFile2Copy, ArgSourceDir, ArgInstallDir
	
    Say 'Copying "'ArgSourceDir||ArgFile2Copy'" to "'ArgInstallDir||'\'||ArgFile2Copy'"...'
    Command = '@Copy "'ArgSourceDir||ArgFile2Copy'" "'ArgInstallDir||ArgFile2Copy'" >NUL'
    Command
    if rc \= 0 Then Do
	call DspError
        say 'Error! 'ArgFile2Copy' was not installed properly.'
        pull MyFinger
    End
    Return

/*-----------------------------------------------------------------------------*/
/*-- AskYN: defaults to 'YES'                                                --*/
/*-----------------------------------------------------------------------------*/
AskYN: parse arg argPrompt
  say
  say argPrompt||'(Y/n)?'
  k = SysGetKey('NOECHO')
  if k = 'N' | k = 'n' then return 0
  else return 1

/*-----------------------------------------------------------------------------*/
/*-- AskNY: defaults to 'NO'                                                 --*/
/*-----------------------------------------------------------------------------*/
AskNY: parse arg argPrompt
  say
  say argPrompt||'(y/N)?'
  k = SysGetKey('NOECHO')
  if k = 'Y' | k = 'y' then return 1
  else return 0

/*-----------------------------------------------------------------------------*/
/*-- PathAddSlash - Add slash                                                --*/
/*-----------------------------------------------------------------------------*/
PathAddSlash: procedure
    parse arg dir

    Parse upper var dir drive ":" path
    len=LENGTH(path)
    if len>0 then do
        if SUBSTR(path,len,1)<>'\' then path=path||'\'
    end
    else path='\'
    dir=Drive||":"||path

return dir

/*-----------------------------------------------------------------------------*/
/*-- PathDelSlash - Delete slash                                             --*/
/*-----------------------------------------------------------------------------*/
PathDelSlash: procedure
    parse arg dir

    Parse upper var dir drive ":" path
    len=LENGTH(path)
    if len>1 then do
        if SUBSTR(path,len,1)=='\' then
            path=SUBSTR(path,1,len-1)
    end
    else path="\"
    dir=Drive||":"||path
return dir    


DspError: procedure
  call SysCls
  say 'Ŀ'
  say '                   POP-Play v0.90 installation                       '
  say 'Ĵ'
  say '                                                                     '
  say 'ERROR ERROR ERROR ERROR ERROR ERROR ERROR ERROR ERROR ERROR ERROR ERR'
  say '                                                                     '
  say ''
return

DspGoodBye:procedure
  call SysCls
  say 'Ŀ'
  say '                   POP-Play v0.90 installation                       '
  say 'Ĵ'
  say '                                                                     '
  say '     The POP-Play has been installed on your system.                 '
  say '                                                                     '
  say ''
return
/* eof */

