/* example of using mpg123.dll in REXX - Samuel Audet <guardia@cam.org> */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

call RxFuncAdd 'RxMPG123Load', 'mpg123', 'RxMPG123Load'
call RxMPG123Load

MP123_PLAY   = 1
MP123_STOP   = 2
MP123_PAUSE  = 3
MP123_FFWD   = 4
MP123_VOLUME = 5
MP123_REW    = 6
MP123_JUMPTO = 7
MP123_SETUP  = 8

TOTALSECS    = 1
PLAYEDSECS   = 2

/* NOTE: REXX seems to have problems parsing slashes on the command line
   (used for HTTP URLs for example) */
parse arg cmdline

if cmdline = "" then exit

call RxDecoderInit

call RxDecoderFileInfo cmdline,"fileinfo"

say fileinfo.mpeg
say fileinfo.layer
say fileinfo.freq
say fileinfo.mode
say fileinfo.modext
say fileinfo.bpf
say fileinfo.channel
say fileinfo.bitrate
say fileinfo.extention
say fileinfo.junklength
say fileinfo.songlength


playinfo.filename = cmdline
playinfo.volume = 100
playinfo.flushbuffers = 1
playinfo.lockdevice = 0
playinfo.force8bit = 0
playinfo.forcemono = 0
playinfo.downsample = 0
playinfo.device = 0
playinfo.numbuffers = 32
playinfo.boostclass = 3
playinfo.boostdelta = 0
playinfo.normalclass = 2
playinfo.normaldelta = 31
playinfo.httpauth = ""
playinfo.proxyurl = ""

call RxDecoderCmd MP123_SETUP,"playinfo"
call RxDecoderCmd MP123_PLAY,"playinfo"

finished = 0
played = 0

do until finished

   if RxDecoderPlaying() then do
      call charout , d2c(13)
      call charout , RxDecoderTime(PLAYEDSECS) 'seconds played  '
      call charout , RxDecoderTime(TOTALSECS) 'total seconds  '
      played = 1
    end
    else if played then
       finished = 1

    call syssleep 1
end

call RxDecoderUninit
