/*
New function hgetbit implemented, which is optimized for
returning 1 bit from the stream.
Hendrik Pagenhardt (pagenhar@sunpool.cs.uni-magdeburg.de)

Last modified: 04/09/97
*/
#ifndef BIT_RES_H
#define BIT_RES_H

#define BUFSIZE 4096

class Bit_Reserve {

private:

  unsigned int offset, totbit, buf_byte_idx;
  unsigned int *buf;
  unsigned int buf_bit_idx;
  int *putmask;

public:

  Bit_Reserve();
  ~Bit_Reserve();

  unsigned int hsstell() { return(totbit); }
  unsigned int hgetbits(int N);

/*read 1 bit from the bit stream */
inline unsigned int Bit_Reserve::hgetbit()
{

  totbit++;
  /* BUFSIZE = 4096 = 2^12, so buf_byte_idx%BUFSIZE ==
     buf_byte_idx & 0xfff */
  buf_bit_idx--;
  if (!buf_bit_idx) {
	buf_bit_idx = 8;
	return(buf[buf_byte_idx++ & 0xfff] & 1);
  } else {
	return((buf[buf_byte_idx & 0xfff] >> buf_bit_idx) & 1);
  }
}

  void hputbuf(unsigned int val);

  void rewindNbits(int N);
  void rewindNbytes(int N);
};

#endif
