/*
 *  @(#) obuffer.h 1.8, last edit: 6/15/94 16:51:56
 *  @(#) Copyright (C) 1993, 1994 Tobias Bading (bading@cs.tu-berlin.de)
 *  @(#) Berlin University of Technology
 *
 *  Idea and first implementation for u-law output with fast downsampling by
 *  Jim Boucher (jboucher@flash.bu.edu)
 *
 *  LinuxObuffer class written by
 *  Louis P. Kruger (lpkruger@phoenix.princeton.edu)
 *
 *  optimization hack by
 *  Hendrik Pagenhardt (pagenhar@sunpool.cs.uni-magdeburg.de)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef OBUFFER_H
#define OBUFFER_H

#include <iostream.h>
#include <unistd.h>
#include <stdlib.h>
#include "all.h"
#include "header.h"
extern "C" {
#include "audio_includes.h"
}


static const uint32 OBUFFERSIZE = 2 * 1152;	// max. 2 * 1152 samples per frame
static const uint32 MAXCHANNELS = 2;		// max. number of channels


// Abstract base class for audio output classes:
class Obuffer
{
public:
// #### this permits direct access to the buffer and violates
// the object-orientation, but saves time. The append-
// method is now hard-coded into the synthesis_filter. Hendrik

  int16 *bufferp[MAXCHANNELS];
  uint32 channels;

  virtual     ~Obuffer (void) {}		// dummy
  virtual void append (uint32 channel, int16 value) = 0;
	       // this function takes a 16 Bit PCM sample
  virtual void write_buffer (int fd) = 0;
	       // this function should write the samples to the filedescriptor
	       // or directly to the audio hardware
};


// An audio output class for raw pcm output
// or if ULAW is defined:
// An audio output class for 8-bit ulaw output at 8 kHz:
class FileObuffer : public Obuffer
{
private:
  FILE *fop;
#ifdef ULAW
  ulawsample buffer[OBUFFERSIZE];
  ulawsample *bufferp[MAXCHANNELS];
#else
  int16 buffer[OBUFFERSIZE];
// #### int16 *bufferp[MAXCHANNELS];
#endif
// #### uint32 channels;

public:
	FileObuffer (uint32 number_of_channels);
       ~FileObuffer (void) {}
  void	append (uint32 channel, int16 value);
  void	write_buffer (int fd);
};



#ifdef OS2
class OS2Obuffer : public Obuffer
{
  char   bigbuf[OBUFFERSIZE*8*2],*next;
  int16  buffer[OBUFFERSIZE],bpos;
// #### int16 *bufferp[MAXCHANNELS];
// #### uint32 channels;
  static int audio_fd;

  static int open_audio_device (void);

public:
	OS2Obuffer (uint32 number_of_channels, Header *);
       ~OS2Obuffer (void);
#ifdef DEBUG
  void	append (uint32 channel, int16 value);
#else // little optimization // #### which seems to gain nothing, because this method is virtual
  inline void append (uint32 channel, int16 value) {
    *bufferp[channel] = value;
    bufferp[channel] += channels;
  }
#endif // DEBUG

  void	write_buffer (int dummy);

  class playwav *p;
};
#endif	// OS2

#endif

