/*
Adopted from "huffman.h" from the ISO MPEG Audio Subgroup Software Simulation
Group's public c source for its MPEG audio decoder. Miscellaneous changes by
Jeff Tsay (ctsay@pasteur.eecs.berkeley.edu).

Changed function huffman_decoder to inline. All hard-coded hgetbits(1) were
replaced by hgetbit().
Hendrik Pagenhardt (pagenhar@sunpool.ce.uni-magdeburg.de)

Last modified : 04/09/97 */

/**********************************************************************
Copyright (c) 1991 MPEG/audio software simulation group, All Rights Reserved
huffman.h
**********************************************************************/
/**********************************************************************
 * MPEG/audio coding/decoding software, work in progress              *
 *   NOT for public distribution until verified and approved by the   *
 *   MPEG/audio committee.  For further information, please contact   *
 *   Davis Pan, 508-493-2241, e-mail: pan@3d.enet.dec.com             *
 *                                                                    *
 * VERSION 4.1                                                        *
 *   changes made since last update:                                  *
 *   date   programmers                comment                        *
 *  27.2.92 F.O.Witte (ITT Intermetall)		                      *
 *  8/24/93 M. Iwadare          Changed for 1 pass decoding.          *
 *  7/14/94 J. Koller		useless 'typedef' before huffcodetab  *
 *				removed				      *
 *********************************************************************/

#ifndef HUFFMAN_H
#define HUFFMAN_H

#include "all.h"
#include "bit_res.h"

#define HUFFBITS uint32
#define HTN	34
#define MXOFF	250

struct huffcodetab {
  char tablename[3];	/* string, containing table_description   */
  uint32 xlen; 		/* max. x-index+			  */
  uint32 ylen;	        /* max. y-index+			  */
  uint32 linbits; 	/* number of linbits			  */
  uint32 linmax;	/* max number to be stored in linbits	  */
  int32 ref;		/* a positive value indicates a reference */
  HUFFBITS *table;	/* pointer to array[xlen][ylen]		  */
  unsigned char *hlen;	/* pointer to array[xlen][ylen]		  */
  unsigned char(*val)[2];/* decoder tree			  */
  uint32 treelen;	/* length of decoder tree		  */
};

extern struct huffcodetab ht[HTN];

/*int32 hexstr_to_int(char *hexstr);*/

int32 read_decoder_table(char *filename);

// ####
/* do the huffman-decoding 						*/
/* note! for counta,countb -the 4 bit value is returned in y, discard x */
inline int32 huffman_decoder(struct huffcodetab *h, int32 *x, int32 *y, int32 *v,
		      int32 *w, Bit_Reserve *br)
{
HUFFBITS dmask = 1 << (sizeof(HUFFBITS)*8-1);
  HUFFBITS level;
  int point = 0;
  int error = 0;//#### 1
  level     = dmask;

  if (h->val == NULL) return(2);

  /* table 0 needs no bits */
  if ( h->treelen == 0)
  {  *x = *y = 0;
	  return(0);
  }

  /* Lookup in Huffman table. */

  do {
	 if (h->val[point][0]==0) {   /*end of tree*/
		*x = h->val[point][1] >> 4;
		*y = h->val[point][1] & 0xf;

//		error = 0;
		break;
	 }
	 if (br->hgetbit()) {
		while (h->val[point][1] >= MXOFF) point += h->val[point][1];
		point += h->val[point][1];
	 }
	 else {
		while (h->val[point][0] >= MXOFF) point += h->val[point][0];
		point += h->val[point][0];
	 }
	 level >>= 1;
  } while (level  || (point < ht->treelen) );

  // Check for error.

//  if (error) { // set x and y to a medium value as a simple concealment
//    printf("Illegal Huffman code in data.\n");
//    *x = (h->xlen-1 << 1);
//    *y = (h->ylen-1 << 1);
//  }

  /* Process sign encodings for quadruples tables. */

  if (h->tablename[0] == '3'
      && (h->tablename[1] == '2' || h->tablename[1] == '3')) {

    /* v, w, x and y are reversed in the bitstream.
       switch them around to make test bistream work. */
    if (*y & 8)
      if (br->hgetbit()) *v = -1; else *v = 1;
    else *v = 0;
    if (*y & 4)
      if (br->hgetbit()) *w = -1; else *w = 1;
    else *w = 0;
    if (*y & 2)
      if (br->hgetbit()) *x = -1; else *x = 1;
    else *x = 0;
    if (*y &= 1)
      if (br->hgetbit()) *y = -1;

//    *v = (*y>>3) & 1;
//    *w = (*y>>2) & 1;
//    *x = (*y>>1) & 1;
//    *y = *y & 1;
//
//    /* v, w, x and y are reversed in the bitstream.
//       switch them around to make test bistream work. */
//
//    if (*v)
//      if (br->hgetbit()) *v = -*v;
//    if (*w)
//      if (br->hgetbit()) *w = -*w;
//    if (*x)
//      if (br->hgetbit()) *x = -*x;
//    if (*y)
//      if (br->hgetbit()) *y = -*y;
  }

  /* Process sign and escape encodings for dual tables. */

  else {

    /* x and y are reversed in the test bitstream.
       Reverse x and y here to make test bitstream work. */

    if (h->linbits)
      if ((h->xlen-1) == *x)
	*x += br->hgetbits(h->linbits);
    if (*x)
      if (br->hgetbit()) *x = -*x;
    if (h->linbits)
      if ((h->ylen-1) == *y)
	*y += br->hgetbits(h->linbits);
    if (*y)
      if (br->hgetbit()) *y = -*y;
  }

  return(error);
}

//int32 huffman_decoder(struct huffcodetab *h, int32 *x, int32 *y, int32 *v,
//                      int32 *w, Bit_Reserve *br);

#endif
