/*
Adopted from "huffman.c" from the ISO MPEG Audio Subgroup Software Simulation
Group's public c source for its MPEG audio decoder. Optimizations and
conversion of stdio routines to stream routines by Jeff Tsay
(ctsay@pasteur.eecs.berkeley.edu). Also most error checks were removed.

Conversion back to stdio and adding possibility to generate and use
Huffdec.h so we can get rid of both stdio and streams
by Timo Jantunen (timo.jantunen@hut.fi)

Changed function huffman_decoder to inline (is now in huffmann.h).
Hendrik Pagenhardt (pagenhar@sunpool.ce.uni-magdeburg.de)

Last modified : 04/09/97 */

/**********************************************************************
Copyright (c) 1991 MPEG/audio software simulation group, All Rights Reserved
huffman.c
**********************************************************************/
/**********************************************************************
 * MPEG/audio coding/decoding software, work in progress              *
 *   NOT for public distribution until verified and approved by the   *
 *   MPEG/audio committee.  For further information, please contact   *
 *   Davis Pan, 508-493-2241, e-mail: pan@gauss.enet.dec.com          *
 *                                                                    *
 * VERSION 2.10                                                       *
 *   changes made since last update:                                  *
 *   date   programmers                comment                        *
 *27.2.92   F.O.Witte                  (ITT Intermetall)              *
 *				       email: otto.witte@itt-sc.de    *
 *				       tel:   ++49 (761)517-125	      *
 *				       fax:   ++49 (761)517-880	      *
 *12.6.92   J. Pineda                  Added sign bit to decoder.     *
 * 08/24/93 M. Iwadare                 Changed for 1 pass decoding.   *
 *--------------------------------------------------------------------*
 *  7/14/94 Juergen Koller      Bug fixes in Layer III code           *
 *********************************************************************/

#include <stdio.h>
#include "all.h"
#include "bit_res.h"
#include "huffman.h"

uint32 hs      = sizeof(HUFFBITS)*8;

/* array of all huffcodtable headers	*/
/* 0..31 Huffman code table 0..31	*/
/* 32,33 count1-tables			*/

// windoze fixes
#define lstrlen strlen
#define lstrcmp strcmp

/* read the huffman decoder table */

#define USEHEADERTABLE /* link huffman table from Huffdec.h instead reading it from file */
#define DUMPTABLE /* dump Huffdec to a file called Huffdec.h.new as C data */


#ifdef USEHEADERTABLE

#include "Huffdec.h"

int32 read_decoder_table(char *)
{
  return TABLE_N;
}

#else

struct huffcodetab ht[HTN];

int32 read_decoder_table(char *filename)
{
  int32 n, i, nn, t;
  char command[100],line[100];

  FILE *fp=fopen(filename,"ra");
  if(!fp) {
    fprintf(stderr,"Can't open huffman table '%s'!\n",filename);
    exit(1);
  }

  for (n=0;n<HTN;n++) {
    // .table number treelen xlen ylen linbits
    do {
      fgets(line,99,fp);
    } while ((line[0] == '#') || (line[0] < ' '));

    sscanf(line,"%s %s %d %d %d %d",&command, &(ht[n].tablename), &(ht[n].treelen),
           &(ht[n].xlen), &(ht[n].ylen), &(ht[n].linbits));

    if (lstrcmp(command,".end")==0)
      return(n);
    else if (lstrcmp(command,".table")!=0) {
      fprintf(stderr,"huffman table %u data corrupted\n",n);
      return -1;
    }

    ht[n].linmax = (1<<ht[n].linbits)-1;

    sscanf(ht[n].tablename,"%u",&nn);
    if (nn != n) {
      fprintf(stderr,"wrong table number %u\n",n);
      return(-2);
    }

    do {
      fgets(line,99,fp);
    } while ((line[0] == '#') || (line[0] < ' '));

    sscanf(line,"%s %d",&command, &t);

    if (lstrcmp(command,".reference")==0) {
      ht[n].ref   = t;
      ht[n].val   = ht[t].val;
      ht[n].treelen  = ht[t].treelen;
      if ( (ht[n].xlen != ht[t].xlen) ||
	   (ht[n].ylen != ht[t].ylen)  ) {
	fprintf(stderr,"wrong table %u reference\n",n);
	return (-3);
      };

      while ((line[0] == '#') || (line[0] < ' ') ) {
	fgets(line,99,fp);
      }
    }
    else if (lstrcmp(command,".treedata")==0) {
      ht[n].ref  = -1;
      ht[n].val= new unsigned char[ht[n].treelen] [2];

      if (ht[n].val == NULL) {
	fprintf(stderr, "heaperror at table %d\n",n);
	exit (-10);
      }

      for (i=0;i<ht[n].treelen; i++) {
	int v0,v1;
	fscanf(fp,"%x %x",&v0,&v1);
	ht[n].val[i][0]=(unsigned char) v0;
	ht[n].val[i][1]=(unsigned char) v1;
      }

      fgets(line,99,fp);
    }
    else {
      fprintf(stderr,"huffman decodertable error at table %d\n",n);
    }
  }
  fclose(fp);

#ifdef DUMPTABLE

  fp=fopen("Huffdec.h.new","wa");

  fprintf(fp,"/* automagically generated. Don't edit, see huffman.cc */\n\n"
	  "#define TABLE_N %ld\n\n"
	  ,(long)n);

  for(i=0;i<n;i++) {
    if(ht[i].ref<0) {
      fprintf(fp,"unsigned char ValTab%d[%d][2] = {\n\t",i,ht[i].treelen);
      for(nn=0;nn<ht[i].treelen;nn++)
	fprintf(fp,"{%d,%d},%s",ht[i].val[nn][0],ht[i].val[nn][1],nn%10==9?"\n\t":"");
      fprintf(fp,"\n};\n");
    }
  }

  fprintf(fp,"\nstruct huffcodetab ht[HTN] = {\n");

  for(i=0;i<n;i++) {
    struct huffcodetab *h=&(ht[i]);
    int r;
    r=h->ref;
    if(r<0) r=i;

    fprintf(fp,"\t{\"%s\",%u,%u,%u,%u,%d,NULL,NULL,ValTab%d,%u},\n"
	    ,h->tablename,h->xlen,h->ylen,h->linbits,h->linmax,
	    h->ref,r,h->treelen);
  }

  fprintf(fp,"};\n\n");
  fclose(fp);

#endif

  return n;
}
#endif /* !USEHEADERTABLE */



