/*
hgetbits(N) rewritten.
Hendrik Pagenhardt (pagenhar@sunpool.cs.uni-magdeburg.de)

Last modified: 04/09/97
*/

#include <stdio.h>
#include <limits.h>

#include "bit_res.h"

Bit_Reserve::Bit_Reserve ()
{
  offset = totbit = buf_byte_idx = 0;
  buf = new unsigned int[BUFSIZE];
  buf_bit_idx = 8;
// ####
  putmask = new int [1 + sizeof(unsigned int) * 8];
  putmask[0] = 0x000;
  putmask[1] = 0x001;
  for ( int i = 2; i <= sizeof(unsigned int) * 8; i++)
	putmask[i] = (putmask[i - 1] << 1) | 1;
}

Bit_Reserve::~Bit_Reserve ()
{
  delete [] putmask;
  delete [] buf;
}

/*read N bit from the bit stream */
unsigned int Bit_Reserve::hgetbits(int N)
{
  unsigned int val=0;
  int j = N;
  int k, tmp;

  totbit += N;
  if (N > sizeof(unsigned int) * 8) {
	buf_byte_idx += 1 + ((N - buf_bit_idx) >> 3);
	buf_bit_idx = 8 - ((N - buf_bit_idx) & 7);
	return(UINT_MAX);
//	j = sizeof(unsigned int) * 8;
//	buf_byte_idx += ((N - buf_bit_idx) >> 3) - 3;
//	buf_bit_idx= 8 - ((N - buf_bit_idx) & 7);
  }
  
    /* BUFSIZE = 4096 = 2^12, so buf_byte_idx%BUFSIZE ==
       buf_byte_idx & 0xfff */
  for (;;) {
//    k = (j < buf_bit_idx) ? j : buf_bit_idx;
//    tmp = buf[buf_byte_idx & 0xfff] & putmask[buf_bit_idx];
//    buf_bit_idx -= k;
//    j -= k;
//    val |= (tmp >> buf_bit_idx) << j;
    if (j <= buf_bit_idx) {
	buf_bit_idx -= j;
	if (!buf_bit_idx) {
		buf_bit_idx = 8;
//		if (buf_byte_idx > offset)
//			{ printf("Bit_Reserve::hgetbits: Buffer overflow !!\n");exit(3); } 
		return((val | buf[buf_byte_idx++ & 0xfff]) & putmask[N]);
	} else {
		return((val | (buf[buf_byte_idx & 0xfff] >> buf_bit_idx)) & putmask[N]);
	}
    } else {
	j -= buf_bit_idx;
	val |= buf[buf_byte_idx++ & 0xfff] << j;
	buf_bit_idx = 8;
//      if (buf_byte_idx > offset)
//	{ printf("Bit_Reserve::hgetbits: Buffer overflow !!\n");exit(3); } 
    }
  }
}

/*write 8 bits into the bit stream */
void Bit_Reserve::hputbuf(unsigned int val)
{
  buf[offset & 0xfff] = val;
  offset++;
}

void Bit_Reserve::rewindNbits(int N)
{
  totbit -= N;
  buf_bit_idx += N;
  while( buf_bit_idx >= 8 ) {
    buf_bit_idx -= 8;
    buf_byte_idx--;
  }
// ####
  if (!buf_bit_idx) {
    buf_bit_idx = 8;
    buf_byte_idx++;
//    if (buf_byte_idx > offset)
//      { printf("Bit_Reserve::hgetbits: Buffer overflow !!\n");exit(3); } 
    }
}

void Bit_Reserve::rewindNbytes(int N)
{
  totbit -= (N << 3);
  buf_byte_idx -= N;
}
