   //*********************************************************
  //
 // playwav.cc
// class for playing continous digital audio stream

// Copyright (C) 1996 Timo Jantunen
// Permission granted to do anything else except make money or take credit

// mci_err was taken from mm4ems example by Marc E.E. van Woerkom

// these routines don't work in all machines, so please use them only if
// you don't have any other way of doing this!

// Playwav class makes ten buffers and assigns them to a circular playlist.
// The problem is that playlist data is read before it is actually processed
// so it is difficult to determine which buffer has already been used
// (and different sound drivers seem to do it in a different way).

// This is worked around by introducing a offset, which represents the
// read-ahead.
// Done by Hendrik Pagenhardt (pagenhar@sunpool.cs.uni-magdeburg.de)
// Last modified: 04/09/97

#include <os2.h>

#define  INCL_OS2MM
#include <os2me.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "all.h"
#include "playwav.h"


bool playwav::playdata(char *b,int s)
{
  if(debug_mode) {
    printf("in %d bytes: ",s);printstate();
  }

  if(s==0) return TRUE;
//  if(s>BUFSIZE) {
//    printf("buffer overflow!\n");
//    s=BUFSIZE;
//  }

// #### testing takes offset into account
  while (pl[(plpos+mmOffset)%PLSIZE+1].operand3!=pl[(plpos+mmOffset)%PLSIZE+1].operand2) {
//    printf("w");
    _sleep2(100); // #### 200
  }

  memcpy((char*)pl[plpos+1].operand1,b,s);

  pl[plpos+1].operation=(ULONG)DATA_OPERATION;
  pl[plpos+1].operand2=(ULONG)s;
  pl[plpos+1].operand3=0;

//  printf("out: ");printstate();

  plpos=(plpos+1)%PLSIZE;
  if(!playing && plpos==0) start();

  return TRUE;
}


void playwav::printstate()
{
  int q;

  for(q=0;q<PLSIZE;q++) {
    if(pl[q+1].operand2==0)
	printf("_");
    else
	if(pl[q+1].operand2==pl[q+1].operand3) printf("."); else 
	  if(pl[q+1].operand3==0) printf("r"); else printf("P");
  }
  printf("\n");
}


playwav::playwav(int bufsize,int freq,int chan)
{
  int q;
  ULONG rc;
  char buf2[128];

  MCI_OPEN_PARMS mop;
  MCI_INFO_PARMS mip;
  MCI_WAVE_SET_PARMS msp;

  playing=0;
  plpos=0;
  channels=chan;

/*  char *t;
  t=new char[bufsize*PLSIZE];  
*/
  /* setup ringbuffer */

  pl[0].operation=(ULONG)NOP_OPERATION;
  pl[0].operand1=0;
  pl[0].operand2=0;
  pl[0].operand3=0;

  for(q=0;q<PLSIZE;q++) {
    buf[q]=/*t+q*bufsize*/new char[bufsize];
    //printf("buf %d: %X\n",q,buf[q]);
    memset(buf[q],0,bufsize);
    pl[q+1].operation=(ULONG)DATA_OPERATION;
    pl[q+1].operand1=(ULONG)buf[q];
    pl[q+1].operand2=0;
    pl[q+1].operand3=0;
  }

//  pl[q+1].operation=(ULONG)EXIT_OPERATION;
  pl[q+1].operation=(ULONG)BRANCH_OPERATION;
  pl[q+1].operand1=0;
  pl[q+1].operand2=0;
  pl[q+1].operand3=0;

  /* open waveaudio device */

  mop.hwndCallback=0;
  mop.pszDeviceType=(PSZ)MCI_DEVTYPE_WAVEFORM_AUDIO_NAME;
  mop.pszElementName=(PSZ)&pl;

  rc=mciSendCommand(0,MCI_OPEN,MCI_WAIT|MCI_OPEN_PLAYLIST,(PVOID)&mop,0);
  if(rc) {mci_err(rc);exit(1);}
  ID=mop.usDeviceID;
//  printf("device #%d\n",ID);

  /* get device name */

  mip.hwndCallback=0;
  mip.pszReturn=(PSZ)buf2;
  mip.ulRetSize=128;

  rc=mciSendCommand(ID,MCI_INFO,MCI_WAIT|MCI_INFO_PRODUCT,(PVOID)&mip,0);
  if(rc) {mci_err(rc);exit(1);}

  if(debug_mode) printf("MMPM playback device: %s\n",buf2);


  /* set DAC */

  msp.hwndCallback=0;
  msp.ulSamplesPerSec=freq;
  msp.usChannels=chan;
  msp.usBitsPerSample=16;

  rc=mciSendCommand(ID,MCI_SET,
  		MCI_WAIT|MCI_WAVE_SET_CHANNELS
		|MCI_WAVE_SET_SAMPLESPERSEC|MCI_WAVE_SET_BITSPERSAMPLE,
		(PVOID)&msp,0);
  if(rc) {mci_err(rc);exit(1);}

  if(debug_mode) printf("MMPM waveaudio OK.\n");
}


playwav::~playwav()
{
  ULONG rc;
  int q;

  if(debug_mode) printf("closing...\n");

  for(q=0;q<PLSIZE;q++) {
    pl[plpos+1].operation=(ULONG)EXIT_OPERATION;
    pl[plpos+1].operand1=0;
    pl[plpos+1].operand2=0;
    pl[plpos+1].operand3=0;

    if(debug_mode) {
      //printf("clo: ");printstate();
    }
    while (pl[plpos+1].operand3!=pl[plpos+1].operand2) {
      //printf("w");
      _sleep2(100);
    }
    plpos=(plpos+1)%PLSIZE;
  }

  for(q=0;q<10;q++) {
//    _sleep2(100);
  }

  // close device

  rc=mciSendCommand(ID,MCI_CLOSE,MCI_WAIT,(PVOID)NULL,0);
  if(rc) mci_err(rc);

  for(q=0;q<PLSIZE;q++) {
    delete buf[q];
  }
}


void playwav::start()
{
  ULONG rc;
  MCI_PLAY_PARMS mpp;

  /* start playing */
  
  if(debug_mode) {printf("ply: ");printstate();}
  mpp.hwndCallback=0;
  rc=mciSendCommand(ID,MCI_PLAY,MCI_WAIT&0,(PVOID)&mpp,0);
  if(rc) {mci_err(rc);exit(1);}

// #### this calculates the read-ahead offset
  for(int q=0;q<PLSIZE;q++) {
	if (pl[q+1].operand2==pl[q+1].operand3)
		mmOffset = q + 1;
  }


  if(debug_mode) {printf("ply: ");printstate();}
  
  playing=1;
// #### sleep(4/channels);
}


//
// mci_err: translate the MCI return code into an error string
//
// this is taken from mm4ems example by Marc E.E. van Woerkom

void mci_err(ULONG rc)
{
    const rsize = 512;
    UCHAR rbuff[rsize];

    ULONG rc2 = mciGetErrorString(rc,      // error code
                                  rbuff,   // return buffer
                                  rsize);  // rbuff size

    if (rc2 == MCIERR_SUCCESS)
	fprintf(stderr,"MCI error: %s\n\n",rbuff);
    else
	fprintf(stderr,"MCI error #%ld has occured!\n\n",rc);
}

