#ifndef DMP_H
#define DMP_H
/******************************************************************************/
/* DMP Program : Symbolic Definitions (ADMP.H)                                */
/******************************************************************************/
// NOTE: WE RECOMMEND USING A FIXED SPACE FONT TO LOOK AT THE SOURCE          */
//**************************************************************************
// window ids - used by IWindow constructors (eg IStaticText, AMMWindow)   *
//**************************************************************************
#define FENETRE_CHEF     0x1000         //Main Window ID
#define ZONE_INFO        0x1001         //Information Area                    v2
#define LIGNE_ETAT       0x1002         //Status Line Window ID               v3
#define LIGNE_ETAT2      0x1003         //Status Line Window ID               v3
#define BOUTONS          0x1008
#define ID_PREVSONG      0x1009
#define ID_PREVTRACK     0x1010
#define ID_STOP          0x101A
#define ID_PLAY          0x101B
#define ID_NEXTTRACK     0x101C
#define ID_NEXTSONG      0x101D
#define ID_ICONBUTTON    0x101e
#define ID_PAUSE         0x101f

//**************************************************************************  v2
// string ids - used to relate resources to IStaticText and ITitle         *   .
//**************************************************************************  v2
#define STR_TEST        0x1200         //DMP String ID               v2
#define STR_INFO        0x1220         //Info String ID                      v2
#define STR_NOTHING     0x1230
#define STR_PLAYING     0x1240
#define APROPOS         0x1250
#define INI_FILE        0x1300
#define APP_NAME        0x1301
#define CANAUX          0x1302
#define FREQUENCE       0x1303
#define RESOLUTION      0x1304
#define PILOTE          0x1305
#define AMPLIFICATION   0x1306
#define QUALITE         0x1307
#define BUFFER_DART     0x1308
#define AUTO_DETECTION  0x1309
#define OK              0x130A
#define STR_PATTERN     0x130B
#define DLL_NAME        0x130C
#define FRANCAIS        0x130D
#define AMERICAIN       0x130E
#define FINLANDAIS      0x130F
#define ERROR_DLL       0x1313
#define PREFERENCES     0x1314
#define DRIVER          0x1315
#define MMPM2           0x1316
#define DAUDIO          0x1317
#define DARTBUFFER      0x1318
#define SAMPLING_PARMS  0x1319
#define AUTODETECT      0x131A
#define TXT_11K         0x131B
#define TXT_22K         0x131C
#define TXT_44K         0x131D
#define STEREO_TXT      0x131E
#define HIGHRES         0x131F
#define AMPLIFICATION_TXT       0x1320
#define NO_AMPLIFICATION        0x1321
#define AUTO_AMPLIFICATION      0x1322
#define LOW_AMPLIFICATION       0x1323
#define MEDIUM_AMPLIFICATION    0x1324
#define HIGH_AMPLIFICATION      0x1325
#define QUALITY_TXT             0x1326
#define NOSND                   0x1327
#define CANCEL_TXT              0x1328
#define HELP_TXT                0x1329
#define VERSION_TXT             0x132A
#define CHAN_TXT                0x132B
#define LANGUAGE                0x132C
#define CHEMIN                  0x132D
#define AUTEUR                  0x132E
#define BARRE1                  0x132F
#define BARRE2                  0x1330

//**************************************************************************  v3
// menu ids - used on relate command ID to Menu Items and Function Keys    *   .
//**************************************************************************   .
#define CMD_CHARGER     0x1599
#define CMD_SON         0x1600
#define CMD_JOUER       0x1601
#define CMD_ARRETER     0x1602
#define CMD_FENETREVOL  0x1603
#define CMD_REPETER     0x1604
#define CMD_APROPOS     0x1605
#define CMD_PARAMS      0x1606
#define CMD_PAUSE       0x1607
#define CMD_CHANNELS    0x1608
#define CMD_LISTE       0x1609
#define CMD_EFFETS      0x160A
#define CMD_STARTTIMER  0x160B
#define CMD_STOPTIMER   0x160C

#define FENETRE_VOLUME   0x10a0         //Demo Speed Window                   v6
#define FENETRE_PARAMS   0x10a8         //Demo Speed Window                   v6
#define WND_DEMO_CLIENT  0x10a1         //Demo Speed Client                    .
#define WND_DEMO_LABEL1  0x10a2         //Demo Speed Label                     .
#define WND_DEMO_LABEL2  0x10a3         //Demo Speed Label                     .
#define WND_DEMO_BUTTONS 0x10a4         //Demo Speed Buttons                   .
#define WND_DEMO_SLIDER  0x10a5         //Demo Slider                          .
#define WND_DEMO_APPLY   0x10a6         //Apply Button                         .
#define WND_DEMO_CANCEL  0x10a7         //Cancel Button                       v6
#define CHANNELS_WINDOW  0x10a8

#define SOUND_PARAMETERS 0x1300

#define DEFAULT_FILE_SPEC           0x0063
#define COPYRIGHT_DIALOG            0x0064
#define BITMAP_ID                   0x0065
#define NEXTSONG                    0x0066
#define NEXTTRACK                   0x0067
#define PLAY                        0x0068
#define PREVSONG                    0x0069
#define PREVTRACK                   0x006a
#define STOP                        0x006b
#define PAUSE                       0x006c

#define SNDDIALOG                   0x2000
#define SOUND8BITS                  0x200B
#define SOUND16BITS                 0x200C
#define MONO                        0x200D
#define STEREO                      0x200E
#define SR11K                       0x200F
#define SR22K                       0x2010
#define SR44K                       0x2011

#define LANGUAGE_MARK               0x3000
#define LANGUAGE_STRING             0x3001
#define COUNTRY_CODE                0x3002

#endif

