/*                 To create an .ASC file from any or all                 */
/*                       addresses found in a note                        */
/*                         Parameters: note_file                          */
/*    InnoVal Systems Solutions, Inc., and the authors cannot be held     */
/*   responsible for damage that might occur while using this program.    */
/*                         Use at your own risk.                          */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
signal on syntax name NoRexx
call SysLoadFuncs
signal on syntax name Syntax
'@ECHO OFF'
parse arg filename
if filename='' then do
   say ""
   say "Creates .ASC file (from which ASC2ADR.CMD can create a Post Road Mailer"
   say "address book file) from any or all addresses found in a note file."
   say "Specify the filename of the note as a command line parameter."
   say ""
   exit
end
if translate(right(filename,4))<>'.POP' then filename=filename||'.POP'
if stream(filename,'c','query exists')='' then do
   say "File" filename "does not exist."
   exit
end
addresses=0 ; data.=''
do while lines(filename)
   line=linein(filename)
   check=line
   do while pos('@',check)>0
      parse var check now check
      star=pos('@',now)
      if star>0 & pos('.',now)>star then do
         addresses=addresses+1
         if left(now,1)='05'x then parse var now . 3 now
         if left(now,1)='<' then parse var now . '<' now '>'
         if left(now,1)='(' then parse var now . '(' now ')'
         if left(now,1)='[' then parse var now . '[' now ']'
         if left(now,1)='{' then parse var now . '{' now '}'
         if left(now,1)='"' then parse var now . '"' now '"'
         if left(now,1)="'" then parse var now . "'" now "'"
         data.string.addresses=now
         data.lin.addresses=line
      end
   end
end
do i=1 to addresses
   say ""
   say "Address" data.string.i "found in line"
   say data.lin.i
   say ""
   say "Please enter name, if desired:"
   parse pull data.name.i
   if data.name.i<>'' then do
      if outfile='OUTFILE' then do
         outfile=systempfilename('PRMBK???.ASC')
         Call LineOut outfile, 'Addresses from' filename 'note (Post Road Mailer address book)'
         Call LineOut outfile, 'The fields are:'
         Call LineOut outfile, 'Last Name<tab>First Name<tab>Organization<tab>Email 1<tab>Nickname 1<tab>....Email 5<tab>Nickname 5<tab>Telephone 1<tab>Telephone 2<tab>Fax<tab>Notes 1<tab>Notes 2<tab>Notes 3<tab>....Notes X'
         call lineout outfile,''
      end
      call entry data.string.i data.name.i
   end
end
if email<>'EMAIL' then do
   say ""
   say "The address book entrie(s) have been saved in file" outfile
   say "(Press any key to exit....)"
   call sysgetkey
end
exit
entry:
   parse arg email nametext
   last='' ; first='' ; check=''
   nametext=strip(nametext)
   if pos(',',nametext)>0 then do
      parse var nametext last ',' first
      first=strip(first)
      check=translate(first)
      if check='JR.' | check='SR.' | check='JR' | check='SR' | check='' then do
         lastspace=lastpos(' ',last)
         check=first
         parse var last first =(lastspace) last
         last=last check
      end
   end
   else do
      lastspace=lastpos(' ',nametext)
      parse var nametext first =(lastspace) last
   end
   last=strip(last)
   first=strip(first)
   if last='' then last=first
   if last=first then first=''
   call lineout outfile,LAST||'09'x||FIRST||'09'x||'09'x||EMAIL||copies('09'x,13)
return
Syntax:
  say 'Error' rc 'in line' sigl':' errortext(rc)
  say sigl':' sourceline(sigl)
  exit
return
NoRexx:
   say 'Unable to load the REXXUtil functions.  Either the REXXUTIL.DLL file'
   say 'is not on the LIBPATH or REXX support is not installed on this system.'
   exit
return
