/* rexx: pgp send filter for use with PineOS2
 */

'@echo off'

parse arg infile rest

outfile=infile||'.asc'

/* You can do one of two things:
 * Comment the next line out, so that pgp will ask for your password,
 * and remove "+batchmode" from the invocation of PGP,
 * OR, you can substitute your PGP secret phrase for the one given
 */

call setenv 'PGPPASS', 'top secret'

'pgp -sta +batchmode -o' outfile rest infile
if rc<>0 then
    exit rc

p=lastpos('\',infile)
if p > 0 then
    basename=substr(infile,p+1)
else
    basename=infile
'del' infile
'ren' outfile basename

/* comment the next line out if you prefer to add
   your .signature after the pgp text rather than
   have pine add it beforehand. If you do, make sure
   you set the %SIGNATURE% env var or adjust the code
   below to pick up the correct path!
*/

exit 0

exit addsig(infile)

addsig: procedure
    parse arg tmpfile .
    sigfile=getenv('SIGNATURE')
    if sigfile='' then do
        sigfile=getenv('PINEHOME')
        if sigfile='' then
            sigfile=getenv('HOME')
        sigfile=sigfile||'\'||'.signature'
    end

    rc=stream(sigfile,'C','open read')
    if rc<>'READY:' then do
        SAY "Warning: no sig" sigfile "("rc")"
        return 0
    end
    rc=stream(tmpfile,'C','open write')
    if rc<>'READY:' then do
        SAY "Can't open" tmpfile ":" rc
        return 1
    end

    rc=stream(tmpfile,'C','seek <0')
    rc=lineout(tmpfile,'')
    do while lines(sigfile)
        line=linein(sigfile)
        rc=lineout(tmpfile,line)
    end

    rc=stream(tmpfile,'C','close')
    rc=stream(sigfile,'C','close')
    return 0

getenv: procedure
    parse arg var .
    return value(var,,'OS2ENVIRONMENT')

setenv: procedure
    parse arg var, value
    return value(var,value,'OS2ENVIRONMENT')

