/*******************************************************************************
*
* This module presents example PowerWeb Server++ Direct APIs.
*
*	Implements SERVER-PUSH to demonstrate a sequence of documents being
*	sent to the client's browser at one second intervals.
*
* IMPORTANT:
*
*  YOU MUST HAVE A SERVER-PUSH COMPATIBLE BROWSER in order to view
*  this document properly. Netscape Navigator 1.1 or later is OK.
*  IBM's WebExplorer currently (version 1.03) does NOT support it.
*
* COPYRIGHT:
*   CompuSource (Pty) Ltd
*   Licensed Materials - Property of CompuSource (Pty) Ltd
*   (C) Copyright CompuSource (Pty) Ltd 1994, 1995.
*   All Rights Reserved
*   Use, duplication, or disclosure restricted by international
*   copyright law.
*
*******************************************************************************/

Parse Arg parcel

/* Set up some constants we will be using several times */
boundary	= "YouShouldNeverSeeThis"
crlf		= '0d0a'x
mimeStart= "--"boundary""crlf
mimeEnd	= "--"boundary"--"crlf
content	= 'multipart/x-mixed-replace;boundary="'boundary'"'

/* Add in an extra Rexx package for sleeping */
call RxFuncAdd 'SysSleep', 'RexxUtil', 'SysSleep'

/* Grab a handle to the server's output variable for quick reference */
html = ServerFind(parcel, "Request:/Result")

/* Tell the server we are not sending normal HTML output */
call ServerWriteText parcel, "Request:/Header/Out/Content-type", content

/* Tell the server to send data immediately to the client's browser */
call ServerWriteText parcel, "Request:/ImmediateWrite", "1"

/* Tell the browser we will replace the current page being viewed */
call ServerWriteText html,,"HTTP/1.0 200 OK"crlf
call ServerAppendText html,,'Content-type: 'content''crlf''crlf

/* Send the boundary text for the first document */
call ServerAppendText html,, mimeStart

/* Display a series of 10 documents in sequence */
do counter=1 to 10 by 1

	/* Compose the document to send - it could equally have been an image instead */
	message	=	"Content-type: text/html"crlf
	message	=	message || crlf
	message	=	message || "<h2>Document number" counter"</h2>"crlf

	/* The final document has a special trailer to tell the browser we are finished */
	if counter < 10 then
		message	=	message || mimeStart
	else
		message	=	message || mimeEnd

	/* Send the document to the client's browser */
	call ServerAppendText html,,message

	/* Wait for a second before sending the next document */
	if counter < 10 then
		call SysSleep 1
end

/* Tell the server everything was OK */
return "0"

