#ifndef	_PowerAPI_
#define	_PowerAPI_

   #ifdef __cplusplus
      extern "C" {
   #endif

// -------------------------------------------------------------------------

#ifndef	APIENTRY
	#define	APIENTRY	_System
#endif

// -------------------------------------------------------------------------
//	Definition of a function contained in a dynamic link library that can
//	be called via a PowerWeb Server hook.
//	The return value must be a member of the rcAPI enum.

enum		rcAPI
{
	HOOK_OK						=	0,
	HOOK_NO_ACTION,
	HOOK_CALL_AGAIN,
	HOOK_ERROR,
	HOOK_ABORT_CONNECTION,
	HOOK_ABORT_SERVER
};

typedef		long		(*pfnAPI)(void* parcel);

// -------------------------------------------------------------------------
//	Generic C interface to PowerWeb Server.
//	If pszName is 0, the operation occurs on the current atom, indicated
//	by handle, else a find() is performed first, unless an Append() operation
//	is being used on a list, in which case pszName defines the new atom name.
//	Note that the C interface does not depend on any structure definitions -
//	it is totally generic on purpose to avoid version control problems
//	and to allow cross-platform independence - both at run time and at
//	compile time.
//	All of these calls map on to the underlying C++ equivalents.

enum		rcServer
{
	ERR_INTERNAL		=	-3,
	ERR_MEMORY			=	-2,
	ERR_BAD_ARGUMENTS	=	-1,
	ERR_NONE				=	0,
	ERR_NOT_FOUND,
	ERR_NO_LONGER_EXISTS,
	ERR_ACCESS_DENIED,
	ERR_BUSY,
	ERR_INVALID_TYPE,
	ERR_NOT_A_LIST,
	ERR_VALUE_TRUNCATED,
	ERR_INCOMPATIBLE_VERSION,
	ERR_BAD_NAME,
	ERR_MAX
};

long	APIENTRY	ServerGetConfig		(void* parcel, void**	handle);
long	APIENTRY	ServerGetServer		(void* parcel, void**	handle);
long	APIENTRY	ServerGetConnect		(void* parcel, void**	handle);
long	APIENTRY	ServerGetRequest		(void* parcel, void**	handle);
long	APIENTRY	ServerGetParameters	(void* parcel, void**	handle);
long	APIENTRY	ServerGetArguments	(void* parcel, void**	handle);

long	APIENTRY	ServerFind				(void* parent, const char*		pszName,	void**			item);
long	APIENTRY	ServerKind				(void* handle, unsigned long*	type);
long	APIENTRY	ServerSize				(void* handle, unsigned long*	size);
long	APIENTRY	ServerName				(void* handle, char*				value,	unsigned long	size);
long	APIENTRY	ServerFlush				(void* handle);

long	APIENTRY	ServerReadInteger		(void* parent, const char* pszName, long*   			value);
long	APIENTRY	ServerReadFloat		(void* parent, const char* pszName, double* 			value);
long	APIENTRY	ServerReadText			(void* parent, const char* pszName, char*   			value, unsigned long size);
long	APIENTRY	ServerReadBinary		(void* parent, const char* pszName, unsigned char*	value, unsigned long size);

long	APIENTRY	ServerWriteInteger	(void* parent, const char* pszName, long       				value);
long	APIENTRY	ServerWriteFloat		(void* parent, const char* pszName, double     				value);
long	APIENTRY	ServerWriteText		(void* parent, const char* pszName, const char*				value);
long	APIENTRY	ServerWriteBinary		(void* parent, const char* pszName, const unsigned char*	value, unsigned long size);

long	APIENTRY	ServerAppendText		(void* parent, const char* pszName, const char*				value);
long	APIENTRY	ServerAppendBinary	(void* parent, const char* pszName, const unsigned char*	value, unsigned long size);

long	APIENTRY	ServerNewInteger		(void* parent, const char* pszName, long       				value);
long	APIENTRY	ServerNewFloat			(void* parent, const char* pszName, double     				value);
long	APIENTRY	ServerNewText			(void* parent, const char* pszName, const char*				value);
long	APIENTRY	ServerNewBinary		(void* parent, const char* pszName, const unsigned char*	value, unsigned long size);
long	APIENTRY	ServerNewList			(void* parent, const char* pszName);

long	APIENTRY	ServerParent			(void* here,	void**	handle);
long	APIENTRY	ServerChild				(void* here,	void**	handle);
long	APIENTRY	ServerSibling			(void* here,	void**	handle);

// -------------------------------------------------------------------------

   #ifdef __cplusplus
      }
   #endif

#endif

