//-------------------------------------------------------------------------------
// FILE: SAMPLE16.CPP
//
// April 98 sample for How Do I in OS/2 e-Zine!
//
// Created by Eric Slaats
// File created with Smalled 2.00.01a
//-------------------------------------------------------------------------------
#define  INCL_WIN
#include <os2.h>

#include <stdio.h>
#include <string.h>
#include <math.h>

#include "sample16.h"

//-------------------------------------------------------------------------------
//Dialog Window procedure prototype
//-------------------------------------------------------------------------------
MRESULT EXPENTRY DlgMenu ( HWND, ULONG ,MPARAM, MPARAM );
void proceslastaction  ( void );        // Calculate result based on the last action
void PrintOutput	   ( HWND );    	// Print the output
void PrintListboxLine  ( PSZ, HWND );   // Print line in tally rol
//-------------------------------------------------------------------------------
// Global vars
//-------------------------------------------------------------------------------
double	flLeftMember  = 0;	// leftMember in equation
double	flRightMember = 0;	// RightMember in equation
char		chLastAction;		// Contains the action to be executed on = etc.

//-------------------------------------------------------------------------------
// Main
//
// Sets up a simple dialogbox to demonstrate that a dialog can act as a main
// window
// By using a dialog none of the usual window control has to be included.
// Everything exept the coupling of the menu is done in a dialog editor.
//-------------------------------------------------------------------------------

void main(void)
	{
	HAB hab = WinInitialize(0);
	HMQ hmq = WinCreateMsgQueue(hab,0);

	WinDlgBox(HWND_DESKTOP,
			HWND_DESKTOP,
			DlgMenu,
			NULLHANDLE,
			DIALOGWIN,
			0);

	WinDestroyMsgQueue(hmq);
	WinTerminate(hab);
	}


//---------------------------------------------------------------------------------
// dialog procedure
//---------------------------------------------------------------------------------
MRESULT EXPENTRY DlgMenu(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
	{
	switch (msg)
		{

		//-----------------------------------------------------------------------
		// Handle the initialization of the dialog
		//-----------------------------------------------------------------------
		case WM_INITDLG:
			{
			//------------------------------------------------------------------
			// Set icon
			//------------------------------------------------------------------
			HPOINTER hptr = (HPOINTER)WinLoadPointer(HWND_DESKTOP, NULLHANDLE, 1);
			WinSendMsg(hwndDlg, WM_SETICON, (MPARAM) hptr, 0l);
			//------------------------------------------------------------------
			// Attach menu to dialogwindow
			//------------------------------------------------------------------
			WinLoadMenu(hwndDlg, NULLHANDLE, MAIN);
			WinSendMsg(hwndDlg, WM_UPDATEFRAME, (MPARAM) FCF_MENU, 0l);
			}
		break;

		//NEW NEW NEW NEW NEW NEW NEW NEW
		//-----------------------------------------------------------------------
		// handle the backspace char.
		//-----------------------------------------------------------------------
		case WM_CHAR:
			{
			if (CHARMSG(&msg)->vkey == VK_BACKSPACE)
				{
				char achValue[32];
				long ValueLength;

				WinQueryDlgItemText(hwndDlg , ENTRYFIELD1, 32, achValue);
				ValueLength = strlen(achValue);

				if (ValueLength)
					{
					achValue[ValueLength-1] = 0;
					WinSetDlgItemText(hwndDlg, ENTRYFIELD1, achValue);
					}

				}
			}		
		break;

		case WM_CONTROL:
			{
			if (SHORT2FROMMP(mp1) == LN_ENTER)
				{
				//-------------------------------------------------------------
				// Query selected listbox entry
				//-------------------------------------------------------------
				char achListValue[32];
				HWND hwndLbox;
				long lSelected;

				hwndLbox  = WinWindowFromID(hwndDlg, LISTBOX1);
				lSelected = WinQueryLboxSelectedItem(hwndLbox);
				WinQueryLboxItemText(hwndLbox, lSelected, achListValue, 32);
				//-------------------------------------------------------------
				// Check if entry is a number
				//-------------------------------------------------------------
				if (strlen(achListValue) !=1 ||
					(achListValue[0] != '=' && achListValue[0] != '-' &&
					 achListValue[0] != '+' && achListValue[0] != '*' &&
					 achListValue[0] != '/'))
					//--------------------------------------------------------
					// Place selected item in the listbox
					//--------------------------------------------------------
					WinSetDlgItemText(hwndDlg, ENTRYFIELD1, achListValue);
				}
			}
		break;

		//-----------------------------------------------------------------------
		// Handle WM_COMMAND
		// Only one menuitem, and that is exit!
		//-----------------------------------------------------------------------
		case WM_COMMAND:
			{
			//------------------------------------------------------------------
			// Query the value in the Entryfield and put it in flRightMember
			//------------------------------------------------------------------
			char achValue[32];
			WinQueryDlgItemText(hwndDlg , ENTRYFIELD1, 32, achValue);
			//------------------------------------------------------------------
			// Handle the buttons
			//------------------------------------------------------------------
			switch (SHORT1FROMMP(mp1))
				{
				//-------------------------------------------------------------
				// Proces number button
				//-------------------------------------------------------------
				case BUTTON1:	case BUTTON2:	case BUTTON3:
				case BUTTON4:	case BUTTON5:	case BUTTON6:
				case BUTTON7:	case BUTTON8:	case BUTTON9:	case BUTTON0:
					{
					if (flRightMember == 0)
						strcpy(achValue, "");

					char achButton[2];
					sprintf(achButton, "%d", SHORT1FROMMP(mp1));
					strcat(achValue, achButton);
					WinSetDlgItemText(hwndDlg, ENTRYFIELD1, achValue);
					flRightMember = 1;	// Right member filled
					}
				return(0);

				//-------------------------------------------------------------
				// Proces Dot button (decimal separator)
				//-------------------------------------------------------------
				case BUTTONDOT:
					{
					if (!strchr(achValue, '.'))
						{
						strcat(achValue, ".");
						WinSetDlgItemText(hwndDlg, ENTRYFIELD1, achValue);
						}
					}
				return(0);

				//-------------------------------------------------------------
				// Proces action buttons (+, -, /, *)
				//-------------------------------------------------------------
				case BUTTONSUB:
					{
					//--------------------------------------------------------
					// Set negative sign
					//--------------------------------------------------------
					if (flRightMember == 0 && chLastAction != ' ')
						{
						WinSetDlgItemText(hwndDlg, ENTRYFIELD1, "-");
						flRightMember = 1;	// Right member filled
						return(0);
						}
					}
				case BUTTONDEV:
				case BUTTONADD:
				case BUTTONMUL:
					{
					flRightMember = atof(achValue); 		// Get value in Entryfield
					PrintListboxLine (achValue, hwndDlg);	// Value in listbox

					if (flLeftMember == 0)
						{
						flLeftMember  = flRightMember;
						flRightMember = 0;
						WinSetDlgItemText(hwndDlg, ENTRYFIELD1, "");
						}
					else
						{
						//---------------------------------------------------
						// Proces last action
						//---------------------------------------------------
						if (flRightMember != 0)		// NEW-NEW
							{
							proceslastaction( );
							flRightMember = 0;
							PrintOutput(hwndDlg);	// NEW-NEW
							}
						}
					//--------------------------------------------------------
					// Set new last action
					// And print it in the listbox
					//--------------------------------------------------------
					switch (SHORT1FROMMP(mp1))
						{
						case BUTTONSUB: chLastAction = '-'; break;
						case BUTTONADD: chLastAction = '+'; break;
						case BUTTONMUL: chLastAction = '*'; break;
						case BUTTONDEV: chLastAction = '/'; break;
						}
					char achLastAction[2];
					sprintf(achLastAction,"%c",chLastAction);
					PrintListboxLine(achLastAction, hwndDlg);
					}
				return(0);

				//-------------------------------------------------------------
				// Proces the = button
				//-------------------------------------------------------------
				case BUTTONEQ:
					{
					flRightMember = atof(achValue);		// Get value in Entryfield
					if (flRightMember != 0)
						{
						PrintListboxLine (achValue, hwndDlg);	// Value in listbox
						proceslastaction( ); 			// Proces last action
						PrintOutput(hwndDlg);
						//-----------------------------------------------------
						// Reinit
						//-----------------------------------------------------
						flRightMember = 0;				// Right member becomes 0
						flLeftMember  = 0;				// Left member becomes 0
						chLastAction  = ' ';			// No last action
						}
					}
				return(0);

				//-------------------------------------------------------------
				// Proces the C and CA buttons  (Also Clear and Clear all from edit menu)
				//-------------------------------------------------------------
				case BUTTONCA:
					{
					flLeftMember  = 0;				// Left member becomes 0
					chLastAction  = ' ';			// No last action
					}
				case BUTTONC:
					{
					flRightMember = 0;				// Right member becomes 0
					WinSetDlgItemText(hwndDlg, ENTRYFIELD1, ""); // Clear entryfield
					}
				return(0);
				//NEW NEW NEW NEW NEW NEW NEW NEW
				//-------------------------------------------------------------
				// Clear the Tally rol
				//-------------------------------------------------------------
				case IDM_CLEARTALLY:
					{
					WinSendDlgItemMsg(hwndDlg, LISTBOX1, LM_DELETEALL, 0L, 0L);
					}
				return(0);
                    //NEW NEW NEW NEW NEW NEW NEW NEW
				//-------------------------------------------------------------
				// Show the about box
				//-------------------------------------------------------------
				case IDM_ABOUT:
					{
					WinDlgBox(HWND_DESKTOP,
							hwndDlg,
							WinDefDlgProc,
							NULLHANDLE,
							ABOUTDLG,
							0);

					}
				return(0);
				//-------------------------------------------------------------
				// Close the calculator
				//-------------------------------------------------------------
				case IDM_EXIT:	WinSendMsg(hwndDlg, WM_CLOSE, 0L, 0L); break;
				}
			}
		break;
		}
	return WinDefDlgProc(hwndDlg, msg, mp1, mp2);
	}


//---------------------------------------------------------------------------------
// Calculate the result af the last action and return it
//---------------------------------------------------------------------------------
void proceslastaction( void )
	{
	switch (chLastAction)
		{
		case '-': flLeftMember -= flRightMember; break;
		case '+': flLeftMember += flRightMember; break;
		case '*': flLeftMember *= flRightMember; break;
		case '/': flLeftMember /= flRightMember; break;
		}
	}

//---------------------------------------------------------------------------------
// Print the output and
// Format outputstring (trim zerors and dot)
//---------------------------------------------------------------------------------
void PrintOutput (HWND hwndDlg)
	{
	char achOutput[32];
	sprintf(achOutput, "%g", flLeftMember); 		// Leftmember in string

	WinSetDlgItemText(hwndDlg, ENTRYFIELD1, achOutput); // Value in entryfield
	PrintListboxLine ("=", hwndDlg);			 	  // Value in listbox
	PrintListboxLine (achOutput, hwndDlg);			  // Value in listbox
	}

//---------------------------------------------------------------------------------
// Set value in tallyrol (listbox)
//---------------------------------------------------------------------------------
void PrintListboxLine (PSZ achLine, HWND hwndDlg)
	{
	short I;
	I = (short) WinSendDlgItemMsg(hwndDlg, LISTBOX1,
							LM_INSERTITEM,
							(MPARAM)LIT_END,
							(MPARAM)achLine);
	WinSendDlgItemMsg(hwndDlg, LISTBOX1,
				   LM_SELECTITEM,
				   (MPARAM)I, 0L);
	}
