//-------------------------------------------------------------------------------
// FILE: SAMPLE14.CPP
//
// Jan 98 sample for How Do I in OS/2 e-Zine!
//
// Created by Eric Slaats
// File created with Smalled 2.00.00
//-------------------------------------------------------------------------------
#define  INCL_WIN
#include <os2.h>

#include <stdio.h>
#include <string.h>
#include <math.h>

#include "sample14.h"

//-------------------------------------------------------------------------------
//Dialog Window procedure prototype
//-------------------------------------------------------------------------------
MRESULT EXPENTRY DlgMenu ( HWND, ULONG ,MPARAM, MPARAM );
void proceslastaction  ( void );   // Calculate result based on the last action
//-------------------------------------------------------------------------------
// Global vars
//-------------------------------------------------------------------------------
double	flLeftMember  = 0;	// leftMember in equation
double	flRightMember = 0;	// RightMember in equation
char		chLastAction;		// Contains the action to be executed on = etc.

//-------------------------------------------------------------------------------
// Main
//
// Sets up a simple dialogbox to demonstrate that a dialog can act as a main
// window
// By using a dialog none of the usual window control has to be included.
// Everything exept the coupling of the menu is done in a dialog editor.
//-------------------------------------------------------------------------------

void main(void)
	{
	HAB hab = WinInitialize(0);
	HMQ hmq = WinCreateMsgQueue(hab,0);

	WinDlgBox(HWND_DESKTOP,
			HWND_DESKTOP,
			DlgMenu,
			NULLHANDLE,
			DIALOGWIN,
			0);

	WinDestroyMsgQueue(hmq);
	WinTerminate(hab);
	}


//---------------------------------------------------------------------------------
// dialog procedure
//---------------------------------------------------------------------------------
MRESULT EXPENTRY DlgMenu(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
	{
	switch (msg)
		{
		//-----------------------------------------------------------------------
		// Handle the initialization of the dialog
		//-----------------------------------------------------------------------
		case WM_INITDLG:
			{
			//------------------------------------------------------------------
			// Set icon
			//------------------------------------------------------------------
			HPOINTER hptr = (HPOINTER)WinLoadPointer(HWND_DESKTOP, NULLHANDLE, 1);
			WinSendMsg(hwndDlg, WM_SETICON, (MPARAM) hptr, 0l);
			//------------------------------------------------------------------
			// Attach menu
			//------------------------------------------------------------------
			WinLoadMenu(hwndDlg, NULLHANDLE, MAIN);
			WinSendMsg(hwndDlg, WM_UPDATEFRAME, (MPARAM) FCF_MENU, 0l);
			}
		break;

		//-----------------------------------------------------------------------
		// Handle WM_COMMAND
		// Only one menuitem, and that is exit!
		//-----------------------------------------------------------------------
		case WM_COMMAND:
			{
			//------------------------------------------------------------------
			// Query the value in the Entryfield and put it in flRightMember
			//------------------------------------------------------------------
			char achValue[32];
			WinQueryDlgItemText(hwndDlg , ENTRYFIELD1, 32, achValue);
			//------------------------------------------------------------------
			// Handle the buttons
			//------------------------------------------------------------------
			switch (SHORT1FROMMP(mp1))
				{
				//-------------------------------------------------------------
				// Proces number button
				//-------------------------------------------------------------
				case BUTTON1:	case BUTTON2:	case BUTTON3:
				case BUTTON4:	case BUTTON5:	case BUTTON6:
				case BUTTON7:	case BUTTON8:	case BUTTON9:
				case BUTTON0:
					{
					if (flRightMember == 0)
						strcpy(achValue, "");

					char achButton[2];
					sprintf(achButton, "%d", SHORT1FROMMP(mp1));
					strcat(achValue, achButton);
					WinSetDlgItemText(hwndDlg, ENTRYFIELD1, achValue);
					flRightMember = 1;	// Right member filled
					}
				return(0);

				//-------------------------------------------------------------
				// Proces Dot button (decimal separator)
				//-------------------------------------------------------------
				case BUTTONDOT:
					{
					if (!strchr(achValue, '.'))
						{
						strcat(achValue, ".");
						WinSetDlgItemText(hwndDlg, ENTRYFIELD1, achValue);
						}
					}
				return(0);

				//-------------------------------------------------------------
				// Proces action buttons (+, -, /, *)
				//-------------------------------------------------------------
				case BUTTONSUB:
					{
					//--------------------------------------------------------
					// Set negative sign
					//--------------------------------------------------------
					if (flRightMember == 0)
						{
						WinSetDlgItemText(hwndDlg, ENTRYFIELD1, "-");
						flRightMember = 1;	// Right member filled
						return(0);
						}
					}
				case BUTTONADD:
				case BUTTONMUL:
				case BUTTONDEV:
					{
					flRightMember = atof(achValue); 	// Get value in Entryfield

					if (flLeftMember == 0)
						{
						flLeftMember  = flRightMember;
						flRightMember = 0;
						WinSetDlgItemText(hwndDlg, ENTRYFIELD1, "");
						}
					else
						{
						//---------------------------------------------------
						// Proces last action
						//---------------------------------------------------
						proceslastaction( );
						flRightMember = 0;
						sprintf(achValue, "%f", flLeftMember);
						WinSetDlgItemText(hwndDlg, ENTRYFIELD1, achValue);
						}
					//--------------------------------------------------------
					// Set new last action
					//--------------------------------------------------------
					switch (SHORT1FROMMP(mp1))
						{
						case BUTTONSUB: chLastAction = '-'; break;
						case BUTTONADD: chLastAction = '+'; break;
						case BUTTONMUL: chLastAction = '*'; break;
						case BUTTONDEV: chLastAction = '/'; break;
						}
					}
				return(0);

				//-------------------------------------------------------------
				// Proces the = button
				//-------------------------------------------------------------
				case BUTTONEQ:
					{
					flRightMember = atof(achValue);	// Get value in Entryfield
					proceslastaction( ); 			// Proces last action
					sprintf(achValue, "%f", flLeftMember);
					WinSetDlgItemText(hwndDlg, ENTRYFIELD1, achValue);
					//-----------------------------------------------------
					// Reinit
					//-----------------------------------------------------
					flRightMember = 0;				// Right member becomes 0
					flLeftMember  = 0;				// Left member becomes 0
					chLastAction  = ' ';			// No last action
					}
				return(0);

				//-------------------------------------------------------------
				// Proces the C and CA buttons
				//-------------------------------------------------------------
				case BUTTONCA:
					{
					flLeftMember  = 0;				// Left member becomes 0
					chLastAction  = ' ';			// No last action
					}
				case BUTTONC:
					{
					flRightMember = 0;				// Right member becomes 0
					WinSetDlgItemText(hwndDlg, ENTRYFIELD1, ""); // Clear entryfield
					}
				return(0);



				//-------------------------------------------------------------
				// Close the calculator
				//-------------------------------------------------------------
				case IDM_EXIT:	WinSendMsg(hwndDlg, WM_CLOSE, 0L, 0L); break;
				}
			}
		break;
		}
	return WinDefDlgProc(hwndDlg, msg, mp1, mp2);
	}


//---------------------------------------------------------------------------------
// Calculate the result af the last action and return it
//---------------------------------------------------------------------------------
void proceslastaction( void )
	{
	switch (chLastAction)
		{
		case '-': flLeftMember -= flRightMember; break;
		case '+': flLeftMember += flRightMember; break;
		case '*': flLeftMember *= flRightMember; break;
		case '/': flLeftMember /= flRightMember; break;
		}
	}

