/* This script issues a dccsend to nickname for the filename */
/*  inbound message should look like                         */
/*  *someone* !DCC thisfile.txt                              */

RETURN  /* Remove this line to enable this script. */

/* NOTE: Read carefully this file before using it.  It uses  */
/* search features of REXX to locate files to send when a    */
/* !DCC request comes in.  It can send files from anywhere   */
/* you specify.                                              */

/* To add search paths to this file, add lines lines and     */
/* increment the number. The number after the first line,    */
/* should equal the highest line you add. There should be no */
/* gaps in numbering. All paths should be enclosed in single */
/* quotes, and should have trailing \ on them.               */

paths.0=2
paths.1='x:\server\'
paths.2='x:\sounds\'


/*     EDIT THIS FILE BELOW THIS LINE AT YOUR OWN RISK       */

parse arg channel bogusnick dcccommand filename

/* If coming from MAIN, the NICK will have 2 extra characters on the */
/* lead/trail instead of ONE.  Test for and set trimming rules.      */
   if substr(bogusnick,1,2)= '**'
      then
      do
      trimstart=3
      trimlength=4
      end
      else
      do
      trimstart=2
      trimlength=2
      end

/* fix the bogusnick by stripping off the * from each end    */
   bnlength=length(bogusnick) - trimlength
   fixednick=substr(bogusnick,trimstart,bnlength)

   filename=strip(filename)
   if pos('.',filename)=0 then signal failure
   if substr(dcccommand,1,1) \= '!' then signal ignore

/* Search all paths defined above */
do i=1 to paths.0
call SysFileTree paths.i||filename, 'file' , 'FO'
if file.0=0 then NOP ; else signal laststage
end

laststage:
/* if not found signal failure and send notice to requestor  */
if file.0=0
   then
    signal failure
   else
    signal success

signal end

Success:
    sendfilename=file.1
    str = '/dccsend '||fixednick||' '||sendfilename
    signal end

Failure:
str = '/notice '||fixednick||' : The file you requested >'||filename||'< is not valid. |/notice '||fixednick||' : Please check the file name and try again.'

end:
say str
return str

ignore:
return

/* This enhanced sendfile.cmd was written to enhance the use */
/* of EZirc. I take no responsibility for how it acts on     */
/* your system.  I have coded a RETURN near the TOP to       */
/* prevent it from working until you have examined and test  */
/* it for yourself.  I have made every attempt to document   */
/* it carefully, so that you can easily understand it.  I    */
/* am not a REXX guru, I just used the online help in OS/2   */
/* to find the functions that would do the things I want. I  */
/* am sure there are REXX gurus out there that can probably  */
/* do better. If so your welcome to do so.  This code is     */
/* free for your use and modification. But please do not     */
/* share modified versions of this script with this notice   */
/* attached.                                                 */
/* Have fun                                                  */
/* Phillip Catt                                              */
/* prcatt@netrover.com                                       */
/* I am often on Efnet IRC as Number99                       */

