//---------------------------------------------------------------------------------------------
// File SAMPLE6.CPP (Eric Slaats Mar 97 for OS/2 e-Zine!)
//
// March 1997
// Saving the window status
//---------------------------------------------------------------------------------------------
#define INCL_WIN
#define INCL_DOS

#include <os2.h>
#include <stdio.h>
#include "sample6.h"

//------------------------------------------------------------------------------
// Global variables
//------------------------------------------------------------------------------
USHORT usChecked = 0;
//------------------------------------------------------------------------------
// Prototypes
//------------------------------------------------------------------------------
MRESULT EXPENTRY ClientWndProc (HWND,ULONG,MPARAM,MPARAM);

HWND hwndFrame;

void main()
     {
     HAB   hab;                    // Anchor
     HMQ   hmq;                    // Message queue handle
     QMSG  qmsg;                   // Message struct
     HWND  hwndClient;             // Client window handles

     ULONG flFrameFlags = FCF_TITLEBAR   |FCF_SYSMENU |FCF_MENU    |
                          FCF_SIZEBORDER |FCF_MINMAX  |FCF_TASKLIST;

     //-------------------------------------------------------------------------
     // Initialize application and create message queue
     //-------------------------------------------------------------------------
     hab = WinInitialize (0);
     hmq = WinCreateMsgQueue (hab, 0);
     //-------------------------------------------------------------------------
     // Register class and create window
     //-------------------------------------------------------------------------
     WinRegisterClass (hab, "SampleClass", ClientWndProc, CS_SIZEREDRAW, 0);

     hwndFrame = WinCreateStdWindow (HWND_DESKTOP,     // Parent
                                     WS_VISIBLE,       // Style (visible)
                                     &flFrameFlags,    // Creation flags
                                     "SampleClass",    // Class name
                                     "Sample 6 for OS/2 e-Zine!",// Titlebar text
                                     0,                // Client style
                                     NULLHANDLE,       // Resource handle
                                     MAIN,             // Frame ID
                                     &hwndClient);     // Client handle

     //-------------------------------------------------------------------------
     // Restore size/place and PP fromOS2.INI
     //-------------------------------------------------------------------------
     if (!WinRestoreWindowPos(APPNAME, WINPOS, hwndFrame))
          {
          WinSetWindowPos(hwndFrame,
                          NULLHANDLE,
                          10,10,550,300,
                          SWP_ACTIVATE| SWP_MOVE| SWP_SIZE |SWP_SHOW);
          }
     //-------------------------------------------------------------------------
     // Message loop
     //-------------------------------------------------------------------------
     while (WinGetMsg (hab, &qmsg, 0, 0, 0))
           WinDispatchMsg (hab, &qmsg);
     //-------------------------------------------------------------------------
     // Clean up (destroy window, queue and hab)
     //-------------------------------------------------------------------------
     WinDestroyWindow (hwndFrame);
     WinDestroyMsgQueue (hmq);
     WinTerminate (hab);
     }


//------------------------------------------------------------------------------
// Window procedure
//------------------------------------------------------------------------------
MRESULT EXPENTRY ClientWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
     {
     static bSave = TRUE;

     switch (msg)
          {
          //--------------------------------------------------------------------
          // Fill client with default color
          //--------------------------------------------------------------------
          case WM_ERASEBACKGROUND:
          return MRFROMSHORT(TRUE);
          //--------------------------------------------------------------------
          // Handle the menu and accelerator commands
          //--------------------------------------------------------------------
          case WM_COMMAND:
               {
               switch (SHORT1FROMMP(mp1))
                    {
                    case DEL_INI_ENTRY:
                         DosBeep(2000,100);
                         PrfWriteProfileData(HINI_USERPROFILE, APPNAME, NULL, NULL, 0);
                         bSave = FALSE;
                         WinPostMsg(hwnd, WM_CLOSE, 0l, 0l);
                    break;
                    }
               }
          break;

          //----------------------------------------------------------------------------
          // Save the window size and position on exit
          //----------------------------------------------------------------------------
          case WM_SAVEAPPLICATION:
          	{
               if (bSave)
          	     WinStoreWindowPos(APPNAME, WINPOS,
                                      WinQueryWindow(hwnd, QW_PARENT));
          	}
          break;
          }
     return (WinDefWindowProc (hwnd,msg,mp1,mp2));
     }

