/* REXX preprocessor for HTML files */
Parse Arg SourceFile TargetFile
If SourceFile="" | TargetFile="" then Do
   Say "Usage: rexxpp Source_File Target_File"
   Exit
End
crlf=d2c(13)||d2c(10) /* CR/LF pair */
NChars=Chars(SourceFile)
SourceText=Charin(SourceFile,1,NChars)
rc=Stream(SourceFile,"C","Close")
N=Pos("<!--- include",SourceText,1)
Do While N<>0
   End=Pos(">",SourceText,N) /* The end of the include tag */
   If SubStr(SourceText,End+1,2)=crlf then /* Eliminates extra CR/LF */
      End=End+2
   FirstPart=SubStr(SourceText,1,N-1) /* The text up to the include tag */
   LastPart=SubStr(SourceText,End+1)  /* The text after the include tag */
   IncludeTag=SubStr(SourceText,N,End-N+1)
   Parse Var IncludeTag . "include" IncludeFile "--->"
   IncludeFile=Strip(IncludeFile) /* Strip any leading/trailing spaces */
   NChars=Chars(IncludeFile)
   IncludeText=Charin(IncludeFile,1,NChars) /* Read in the include file */
   rc=Stream(IncludeFile,"C","Close")
   SourceText=FirstPart||IncludeText||LastPart /* Put all of the pieces together */
   Drop FirstPart LastPart IncludeText /* Don't need these anymore so clear them */
   N=Pos("<!--- include",SourceText,1)
End
rc=SysFileDelete(TargetFile) /* Make sure that the output file does not exist */
rc=Charout(TargetFile,SourceText) /* Write out the output file */
rc=Stream(TargetFile,"C","Close")
Exit
