/* List all applications in OS/2 INI files */
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs /* Load REXXUTIL library */
call sysloadfuncs
Parse Arg IniFile
If IniFile="" then Do /* The user didn't tell us which INI file to use */
   Say 
   Say "You must enter either an INI file name or"
   Say "USER for OS2.INI"
   Say "SYSTEM for OS2SYS.INI"
   Exit
end /* do */

Tab=d2c(9) /* The TAB character */
Spacer="="
rc=SysIni(IniFile, 'All:', 'Record.')
if Result \= 'ERROR:' then   /* Was the call successful? */
  do i = 1 to Record.0 /* If so, then step through all records (applications) */
         rc=SysIni(IniFile, Record.i, 'All:', 'Keys')
         Say "["||Record.i||"]"
         do j=1 to Keys.0
            val = SysIni('htmlwiz.ini', Record.i, Keys.j)
            Say Tab||Keys.j||Spacer||val
         end
  end
Exit
