//---------------------------------------------------------------------------------------------
// File SIMPLE3.CPP (Example for OS/2 e-Zine!) Eric Slaats 1996
//
// November 1996
// Simple Messages used upon creation and termination
//---------------------------------------------------------------------------------------------
#define INCL_WIN
#define INCL_DOS

#include <os2.h>
#include <stdio.h>
#include "simple3.h"                        //<================================ NEW
//------------------------------------------------------------------------------
// Prototypes
//------------------------------------------------------------------------------
MRESULT EXPENTRY ClientWndProc (HWND,ULONG,MPARAM,MPARAM);

HWND hwndFrame;

void main()
     {
     HAB   hab;                    // Anchor
     HMQ   hmq;                    // Message queue handle
     QMSG  qmsg;                   // Message struct
     HWND  hwndClient;             // Client window handles

     ULONG flFrameFlags = FCF_TITLEBAR   |FCF_SYSMENU |FCF_SHELLPOSITION |
                          FCF_SIZEBORDER |FCF_MINMAX  |FCF_TASKLIST|
                          FCF_MENU;          //<================================ NEW

     //-------------------------------------------------------------------------
     // Initialize application and create message queue
     //-------------------------------------------------------------------------
     hab = WinInitialize (0);
     hmq = WinCreateMsgQueue (hab, 0);
     //-------------------------------------------------------------------------
     // Register class and create window
     //-------------------------------------------------------------------------
     WinRegisterClass (hab, "SampleClass", ClientWndProc, CS_SIZEREDRAW, 0);

     hwndFrame = WinCreateStdWindow (HWND_DESKTOP,     // Parent
                                     WS_VISIBLE,       // Style (visible)
                                     &flFrameFlags,    // Creation flags
                                     "SampleClass",    // Class name
                                     "Simple 2 for OS/2 e-Zine!",// Titlebar text
                                     0,                // Client style
                                     NULLHANDLE,       // Resource handle
                                     MAIN,             // Frame ID  <=========== NEW
                                     &hwndClient);     // Client handle
     //-------------------------------------------------------------------------
     // Message loop
     //-------------------------------------------------------------------------
     while (WinGetMsg (hab, &qmsg, 0, 0, 0))
           WinDispatchMsg (hab, &qmsg);
     //-------------------------------------------------------------------------
     // Clean up (destroy window, queue and hab)
     //-------------------------------------------------------------------------
     WinDestroyWindow (hwndFrame);
     WinDestroyMsgQueue (hmq);
     WinTerminate (hab);
     }


//------------------------------------------------------------------------------
// Window procedure
//------------------------------------------------------------------------------
MRESULT EXPENTRY ClientWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
     {
     static HWND hwndButton;

     switch (msg)
          {
          //--------------------------------------------------------------------
          // Fill client with default color
          //--------------------------------------------------------------------
          case WM_ERASEBACKGROUND:
          return MRFROMSHORT(TRUE);

          //--------------------------------------------------------------------
          // WM_CREATE occurs only during creation
          //--------------------------------------------------------------------
          case WM_CREATE:
               {
               hwndButton  =
               WinCreateWindow(hwnd,              // Parent handle (Client area)
                               WC_BUTTON,         // Window class (Button)
                               "This is a button",// Window text
                               WS_VISIBLE | BS_DEFAULT, // Button flags
                               0, 0, 0, 0,        // client window has no size or position at this point
                               hwnd,              // Owner handle (Client area)
                               HWND_TOP,          // Z-order ontop
                               IDM_BUTTON,        // Window ID (Main listbox resource ID)
                               0,                 // Control
                               0);                // Presentation Parameters

               }
          break;

          //--------------------------------------------------------------------
          // WM_SIZE occurs during every resize, size setting event
          //--------------------------------------------------------------------
          case WM_SIZE:
               {
               short x = SHORT1FROMMP(mp2)/3;
               short y = SHORT2FROMMP(mp2)/3;

               WinSetWindowPos(hwndButton,        // Place and size button
                               HWND_TOP,          // ONTOP in Z-order
                               x,                 // x coord
                               y,                 // y coord
                               x,                 // cx size
                               y,                 // cy size
                               SWP_SIZE|SWP_MOVE);// Change size|move en Show
               }
          break;

          //--------------------------------------------------------------------
          // NEW NEW NEW NEW NEW NEW NEW NEW NEW NEW NEW NEW NEW NEW NEW NEW NEW
          // Handling of the menu-items and the button by WM_COMMAND
          //--------------------------------------------------------------------
          case WM_COMMAND:
               {
               DosBeep(2000,100);  // Audio signal
               char String[64];    // Temporary string for message box

               switch(SHORT1FROMMP(mp1))
                    {
                    case IDM_BUTTON:  sprintf(String,"Button pressed"); break;
                    case IDM_ITEM1_1: sprintf(String,"Menu item 1.1");  break;
                    case IDM_ITEM1_2: sprintf(String,"Menu item 1.2");  break;
                    case IDM_ITEM2_1: sprintf(String,"Menu item 2.1");  break;
                    case IDM_ITEM2_2: sprintf(String,"Menu item 2.2");  break;
                    case IDM_ITEM2_3: sprintf(String,"menu item 2.3");  break;
                    case IDM_ABOUT:   sprintf(String,"Simple 3 By Eric Slaats"); break;
                    }
               //---------------------------------------------------------------
               // Display message box
               //---------------------------------------------------------------
               WinMessageBox(HWND_DESKTOP, HWND_DESKTOP,
                             String, "WM_COMMAND event", 0,
                             MB_OK|MB_SYSTEMMODAL);               }
          break;
          }
     return (WinDefWindowProc (hwnd,msg,mp1,mp2));
     }

