//---------------------------------------------------------------------------------------------
// File STDWIN.CPP (Example for OS/2 e-Zine!) Eric Slaats 1996
//
// November 1996
// Simple Messages used upon creation and termination
//---------------------------------------------------------------------------------------------
#define INCL_WIN
#define INCL_DOS

#include <os2.h>
#include <stdio.h>
//------------------------------------------------------------------------------
// Prototypes
//------------------------------------------------------------------------------
MRESULT EXPENTRY ClientWndProc (HWND,ULONG,MPARAM,MPARAM);

HWND hwndFrame;

void main()
     {
     HAB   hab;                    // Anchor
     HMQ   hmq;                    // Message queue handle
     QMSG  qmsg;                   // Message struct
     HWND  hwndClient;//, hwndFrame;  // Client and Frame handles

     ULONG flFrameFlags = FCF_TITLEBAR   |FCF_SYSMENU |FCF_SHELLPOSITION |
                          FCF_SIZEBORDER |FCF_MINMAX  |FCF_TASKLIST;

     //-------------------------------------------------------------------------
     // Initialize application and create message queue
     //-------------------------------------------------------------------------
     hab = WinInitialize (0);
     hmq = WinCreateMsgQueue (hab, 0);
     //-------------------------------------------------------------------------
     // Register class and create window
     //-------------------------------------------------------------------------
     WinRegisterClass (hab, "SampleClass", ClientWndProc, CS_SIZEREDRAW, 0);

     hwndFrame = WinCreateStdWindow (HWND_DESKTOP,     // Parent
                                     WS_VISIBLE,       // Style (visible)
                                     &flFrameFlags,    // Creation flags
                                     "SampleClass",    // Class name
                                     "Simple 2 for OS/2 e-Zine!",// Titlebar text
                                     0,                // Client style
                                     NULLHANDLE,       // Resource handle
                                     0,                // Frame ID
                                     &hwndClient);     // Client handle
     //-------------------------------------------------------------------------
     // Message loop
     //-------------------------------------------------------------------------
     while (WinGetMsg (hab, &qmsg, 0, 0, 0))
           WinDispatchMsg (hab, &qmsg);
     //-------------------------------------------------------------------------
     // Clean up (destroy window, queue and hab)
     //-------------------------------------------------------------------------
     WinDestroyWindow (hwndFrame);
     WinDestroyMsgQueue (hmq);
     WinTerminate (hab);
     }


//------------------------------------------------------------------------------
// Window procedure
//------------------------------------------------------------------------------
MRESULT EXPENTRY ClientWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
     {
     static HWND hwndButton;

     switch (msg)
          {
          //--------------------------------------------------------------------
          // Fill client with default color
          //--------------------------------------------------------------------
          case WM_ERASEBACKGROUND:
          return MRFROMSHORT(TRUE);

          //--------------------------------------------------------------------
          // WM_CREATE occurs only during creation
          //--------------------------------------------------------------------
          case WM_CREATE:
               {
               hwndButton  =
               WinCreateWindow(hwnd,              // Parent handle (Client area)
                               WC_BUTTON,         // Window class (Button)
                               "This is a button",// Window text
                               WS_VISIBLE | BS_DEFAULT, // Button flags
                               0, 0, 0, 0,        // client window has no size or position at this point
                               hwnd,              // Owner handle (Client area)
                               HWND_TOP,          // Z-order ontop
                               100,               // Window ID (Main listbox resource ID)
                               0,                 // Control
                               0);                // Presentation Parameters

               }
          break;

          //--------------------------------------------------------------------
          // WM_SIZE occurs during every resize, size setting event
          //--------------------------------------------------------------------
          case WM_SIZE:
               {
               short x = SHORT1FROMMP(mp2)/3;
               short y = SHORT2FROMMP(mp2)/3;

               WinSetWindowPos(hwndButton,        // Place and size button
                               HWND_TOP,          // ONTOP in Z-order
                               x,                 // x coord
                               y,                 // y coord
                               x,                 // cx size
                               y,                 // cy size
                               SWP_SIZE|SWP_MOVE);// Change size|move en Show
               }
          break;
          }
     return (WinDefWindowProc (hwnd,msg,mp1,mp2));
     }

