{$ifDef VirtualPascal}
{$AlignCode-,AlignData-,AlignRec-,G3+,Speed-,Frame-}
{$define OS_MAP_CASE}
{$endIf}
Unit strOp;

Interface uses use32;

const
{keywords separator for 'Keyword', 'KeywordSpc', 'GetKeyword'}
     keywordSep = '';

type
     Str2       = String[2];
     Str4       = String[4];
     Str8       = String[8];
     Str10      = String[10];
     Str16      = String[16];
{$ifDef OS_MAP_CASE}
var
     uCaseMap,
     lCaseMap   : array[Char] of Char;
{$endIf OS_MAP_CASE}

{Convert a string to lower case}
 Procedure LowStr(var S : String);

{Convert a string to upper case}
 Procedure UpStr(var S : String);

{Return the lowercase string of argument}
 Function  LowStrg(S : String) : String;

{Return the uppercase string of argument}
 Function  UpStrg(S : String) : String;

{Return hexadecimal representation of a number}
 Function  Hex8(A : Longint) : Str8;
 Function  Hex4(A : Word) : Str4;
 Function  Hex2(A : Byte) : Str2;

{Return binary representation of a number}
 Function  Bin16(a : Word) : Str16;
 Function  Bin8(a : Byte) : Str8;

{Extract from a string a hexadecimal number. Cuts out the number from string}
 Function  HexVal(var s : String) : Longint;

{Same as HexVal but decimal. Example: DecVal('123 test') returns 123 and S = ' test' }
 Function  DecVal(var s : String) : Longint;

{Return decimal representation of A right-justified in N positions filled with Ch}
 Function  SStr(a : LongInt; n : Byte; ch : Char) : String;

{Converts a longint to string (decimal)}
 Function  long2str(L : Longint) : String;

{Signed version of long2str: Returns '+###', '-###' or ' 0'}
 Function  signStr(L : Longint) : String;

{Remove starting spaces and tabs from a string}
 Procedure DelStartSpaces(var S : String);

{Remove trailing blanks and tabs from a string}
 Procedure DelTrailingSpaces(var S : String);

{Extract directory from a full file name}
 Function extractDir(const fName : string) : String;
{Extract filename from a full file name}
 Function extractName(const fName : string) : String;

{Get string number No from a structure of type:}
{ db 'string-number-one',0 }
{ db 'string-number-two',0 etc. }
 Function  GetASCIIZ(var Text; No : Longint) : String;
{The same but returns pChar to that string}
 Function  GetASCIIZptr(var Text; No : Longint) : pChar;
{Count ASCIIZ strings in above structure}
 Function  CountASCIIZ(var Text; Size : Longint) : Longint;

{Strip off all blanks and tabs from a string}
 Function  StripBlanks(const S : String) : String;

{Return a string which represents percental relation of Val to Max with nFrac decimals}
 Function  StrPercent(Val,Max : Longint; NFrac : Byte) : String;

{Convert fixed-point float to string; Max is fixed-point unit (ONE);}
{nFrac is number of decimals. Example: StrFloat(8,16,3) = 0.500}
 Function  StrFloat(Val,Max : Longint; NFrac : Byte) : String;

{Return a roman number A = 0..2000}
 Function  RomanNumber(A : Word) : string;

{Return only filename from PathName}
 Function  JustFilename(const pathName : String) : String;

{Return `short` version of pathName which fits into width W}
 Function  Short(const pathName : String; W : Byte) : String;

{Return a string containing Num characters Ch}
{$ifDef VirtualPascal} {$SAVES eax,ebx,edx,esi} {$endIf}
 Function  Strg(Ch : Char; Num : Integer) : String;

{Return position of first occurence of character Ch in string S}
{$ifDef VirtualPascal} {$SAVES ebx,esi} {$EndIf}
 Function  First(ch : Char; const S : String) : Byte;

{Return position of last occurence of character Ch in string S}
{$ifDef VirtualPascal} {$SAVES ebx,esi} {$EndIf}
 Function  Last(ch : Char; const S : String) : Byte;

{Return position of Nth occurence of character Ch in string S counting from head}
{$ifDef VirtualPascal} {$SAVES esi} {$EndIf}
 Function  ScanFwd(ch : Char; const S : String; N : Byte) : Byte;

{Return position of Nth occurence of character Ch in string S counting from tail}
{$ifDef VirtualPascal} {$SAVES ebx,esi} {$EndIf}
 Function  ScanBwd(ch : Char; const S : String; N : Byte) : Byte;

{Count occurences of character Ch in string S}
{$ifDef VirtualPascal} {$SAVES ebx,esi} {$EndIf}
 Function  CharCount(ch : Char; const S : String) : Byte;

{Exclude from string S all characters Ch and return it}
{$ifDef VirtualPascal} {$SAVES edx} {$EndIf}
 Function  Exclude(const S : String; Ch : Char) : String;

{Search for a keyword in string S and return its ordinal number.}
{Keyword definitions is an array of structure:}
{db 'keyword1keyword2keyword3[...]',0}
{If keyword is recognized it is cut out from input string}
{$ifDef VirtualPascal} {$SAVES none} {$EndIf}
 Function  Keyword(var S : String; var Keyword) : Byte;

{The same as `Keyword` but after keyword must come a space or tab}
{(`Keyword`) recognize even keywords like 'keyword1thisis'}
{$ifDef VirtualPascal} {$SAVES none} {$EndIf}
 Function  KeywordSpc(var S : String; var Keyword) : Byte;

{Return keyword number `No` from structure Keyword (same as above)}
{$ifDef VirtualPascal} {$SAVES edx} {$EndIf}
 Function  GetKeyword(var Keyword; No : Word) : String;

{Return upper case of character C}
{$ifDef VirtualPascal} {$SAVES eax,ecx,edx,esi,edi} {$EndIf}
 Function  UpCase(C : Char) : Char;

{Return lower case of character C}
{$ifDef VirtualPascal} {$SAVES eax,ecx,edx,esi,edi} {$EndIf}
 Function  LowCase(C : Char) : Char;

{Return hexadecimal representation of lower nubble of A}
{$ifDef VirtualPascal} {$SAVES all} {$EndIf}
 Function  HexChar(A : Byte) : Char;

Implementation uses miscUtil {$IfDef OS2}, os2base {$EndIf};

{$ifDef VirtualPascal} {$SAVES ebx,esi,edi} {$EndIf}

Function HexChar; assembler;
asm             mov     al,a
                and     al,0Fh
                add     al,'0'
                cmp     al,58
                jc      @loc1
                add     al,7
@Loc1:
end;

Function Hex2;
begin
 Hex2 := HexChar(a shr 4) + HexChar(a);
end;

Function Hex4;
begin
 Hex4 := HexChar(Hi(a) shr 4) + HexChar(Hi(a))+
         HexChar(Lo(a) shr 4) + HexChar(Lo(a));
end;

Function Hex8;
begin
 Hex8 := Hex4(a shr 16) + Hex4(a);
end;

Function Bin16;
var s : Str16;
    i : Byte;
begin
 s := '';
 for i:=0 to 15 do
  begin
   asm rol a,1 end;
   s:=s + Char(48+(a and 1));
  end;
 Bin16 := s;
end;

Function Bin8;
var s : Str8;
    i : Byte;
begin
 s := '';
 for i := 0 to 7 do
  begin
   asm rol a,1 end;
   s := s + Char(48 + (a and 1));
  end;
 Bin8 := s;
end;

{$ifDef OS_MAP_CASE}
Function upCase; assembler;
asm             mov     al,&C
                lea     ebx,uCaseMap
                xlat
end;

Function lowCase; assembler;
asm             mov     al,&C
                lea     ebx,lCaseMap
                xlat
end;
{$else}
Function upCase; assembler;
asm             mov     al,&C
                cmp     al,'a'
                jb      @@ok
                cmp     al,'z'
                jbe     @@lo
                cmp     al,''
                jb      @@ok
                cmp     al,''
                jbe     @@lo
                cmp     al,''
                jb      @@ok
                cmp     al,''
                ja      @@ok
                sub     al,80-32
@@lo:           sub     al,20h
@@ok:
end;

Function lowCase; assembler;
asm             mov     al,&C
                cmp     al,'A'
                jb      @@ok
                cmp     al,'Z'
                jbe     @@up
                cmp     al,''
                jb      @@ok
                cmp     al,''
                jbe     @@up
                cmp     al,''
                jb      @@ok
                cmp     al,''
                ja      @@ok
                add     al,80-32
@@up:           add     al,20h
@@ok:
end;
{$endIf}

procedure LowStr;
var i : byte;
begin
 for i:=1 to length(s) do s[i]:=LowCase(s[i]);
end;

Function LowStrg;
begin
 LowStr(s); LowStrg := s;
end;

Procedure UpStr;
var i : byte;
begin
 for i:=1 to length(s) do s[i]:=UpCase(s[i]);
end;

Function UpStrg;
begin
 UpStr(s); UpStrg := s;
end;

Function SStr;
var s : String;
    i : Byte;
begin
 Str(a:n,s);
 for i := 1 to n do if s[i] = ' ' then s[i] := ch else break;
 SStr := s;
end;

{$ifDef use32}
Function Strg; assembler;
asm             cld
                mov     edi,@result
                mov     ecx,Num
                cmp     cx,255
                jbe     @@lenOK
                xor     ecx,ecx
@@lenOK:        mov     al,cl
                stosb
                mov     al,&Ch
                mov     ah,al
                shr     ecx,1
                rep     stosw
                adc     cl,cl
                rep     stosb
end;

{$SAVES ebx,edx,esi,edi}
Function SetUpCase(var c : Char) : boolean; assembler;
asm             mov     ecx,&c
                mov     al,[ecx]
                cmp     al,'a'
                jb      @E1
                cmp     al,'z'
                ja      @E1
                and     al,0DFh
                mov     [ecx],al
@E1:            mov     ah,0
                cmp     al,'0'
                jb      @E3
                cmp     al,'F'
                ja      @E3
                cmp     al,'9'
                jbe     @E2
                cmp     al,'A'
                jb      @E3
@E2:            mov     ah,1
@E3:            mov     al,ah
end;
{$SAVES ebx,esi,edi}

{$else}

Function Strg; assembler;
asm             cld
                les     di,@result
                mov     cx,Num
                cmp     cx,255
                jbe     @@lenOK
                xor     cx,cx
@@lenOK:        mov     al,cl
                stosb
                mov     al,&Ch
                mov     ah,al
                shr     cx,1
                rep     stosw
                adc     cl,cl
                rep     stosb
end;

Function SetUpCase(var c : Char) : boolean; assembler;
asm             les     si,c
                mov     al,es:[si]
                cmp     al,'a'
                jb      @E1
                cmp     al,'z'
                ja      @E1
                and     al,$5F
                mov     es:[si],al
@E1:            mov     ah,0
                cmp     al,'0'
                jb      @E3
                cmp     al,'F'
                ja      @E3
                cmp     al,'9'
                jbe     @E2
                cmp     al,'A'
                jb      @E3
@E2:            mov     ah,1
@E3:            mov     al,ah
end;

{$endIf}

Function HexVal;
var i,j : Byte;
    k   : LongInt;
begin
 k:=0;i:=1;
 While SetUpCase(s[i]) and (i<=Length(s)) and (i<9) do
  begin
   j:=Byte(UpCase(s[i]))-48;if j>9 then Dec(j,7);
   k:=(k shl 4) or j;Inc(i);
  end;
 HexVal:=k;Delete(s,1,i-1);
end;

Function DecVal;
var i : Byte;
    k : LongInt;
    m : Boolean;
begin
 k := 0; i:=1;
 if s[1] = '-'
  then begin m := True; Inc(i); end
  else m := False;
 While (i <= Length(s)) and (i < 11) and (UpCase(s[i]) in ['0'..'9']) do
  begin
   k := (k * 10) + (Byte(UpCase(s[i])) - 48);
   Inc(i);
  end;
 if m
  then DecVal := -k
  else DecVal := k;
 Delete(s, 1, i - 1);
end;

{$ifDef use32}
Function First; assembler;
asm             cld
                mov     edi,S
                movzx   ecx,[edi].byte
                mov     edx,ecx
                inc     edi
                mov     al,&ch
                jecxz   @@NO
                repne   scasb
                je      @@OK
@@NO:           mov     al,0
                jmp     @@locEx
@@OK:           sub     edx,ecx
                mov     al,dl
@@locEx:
end;

Function Last; assembler;
asm             std
                mov     edi,S
                movzx   ecx,[edi].byte
                mov     edx,ecx
                add     edi,ecx
                mov     al,&Ch
                jecxz   @@NO
                repne   scasb
                je      @@OK
@@NO:           mov     al,0
                jmp     @@LocEx
@@OK:           mov     eax,edx
                sub     edx,ecx
                sub     eax,edx
                inc     al
@@LocEx:        cld
end;

Function ScanFwd; assembler;
asm             cld
                mov     edi,S
                mov     dh,N
                or      dh,dh
                je      @@NO
                movzx   ecx,[edi].byte
                mov     ebx,ecx
                inc     edi
                mov     al,&Ch
@@NS:           jecxz   @@NO
                repne   scasb
                je      @@OK
@@NO:           mov     al,0
                jmp     @@LocEx
@@OK:           dec     dh
                jne     @@NS
                sub     ebx,ecx
                mov     al,bl
@@LocEx:
end;

Function ScanBwd; assembler;
asm             std
                mov     edi,S
                mov     dh,N
                or      dh,dh
                je      @@NO
                movzx   ecx,[edi].byte
                add     edi,ecx
                mov     al,&Ch
@@NS:           jecxz   @@NO
                repne   scasb
                je      @@OK
@@NO:           mov     al,0
                jmp     @@LocEx
@@OK:           dec     dh
                jne     @@NS
                mov     eax,ecx
                inc     al
@@LocEx:        cld
end;

Function CharCount; assembler;
asm             cld
                mov     edi,S
                mov     dh,0
                movzx   ecx,[edi].byte
                mov     edx,ecx
                inc     edi
                mov     al,&Ch
@@next:         jecxz   @@done
                repne   scasb
                jne     @@done
                inc     dh
                jmp     @@next
@@done:         mov     al,dh
end;

Function Exclude; assembler;
asm             cld
                mov     esi,S
                mov     edi,@result
                inc     edi
                lodsb
                mov     cl,al
                mov     ebx,edi
                test    al,al
                je      @@done
                mov     ah,&ch
@@nextCh:       lodsb
                cmp     al,ah
                je      @@skip
                stosb
@@skip:         dec     cl
                jne     @@nextCh
@@done:         sub     edi,ebx
                mov     eax,edi
                mov     [ebx-1],al
end;

Function Keyword; assembler;
asm             cld
                mov     esi,S
                lodsb
                movzx   ecx,al
                mov     bx,100h
                mov     edi,Keyword
@@1:            push    esi
                push    ecx
@@2:            mov     al,[edi]
                inc     edi
                push    ebx
                push    eax
                call    UpCase
                pop     ebx
                or      al,al
                je      @@5
                mov     ah,al
                lodsb
                push    ebx
                push    eax
                call    upCase
                pop     ebx
                cmp     ah,keywordSep
                je      @@4
                inc     bl
                cmp     al,ah
                loope   @@2
                je      @@36
@@3:            mov     bl,0
                inc     bh
@@35:           mov     al,[edi]
                inc     edi
                or      al,al
                je      @@5
                cmp     al,keywordSep
                jne     @@35
                pop     ecx
                pop     esi
                jmp     @@1
@@36:           cmp     [edi].byte,keywordSep
                jne     @@3
@@4:            pop     ecx
                pop     esi
                mov     al,bh
                movzx   ebx,bl
                sub     [esi-1],bl
                sub     cl,bl
                mov     edi,esi
                add     esi,ebx
                rep     movsb
                jmp     @@6
@@5:            mov     al,0
                pop     ecx
                pop     esi
@@6:
end;

Function KeywordSpc; assembler;
asm             cld
                mov     esi,S
                lodsb
                movzx   ecx,al
                mov     bx,100h
                mov     edi,Keyword
@@1:            push    esi
                push    ecx
@@2:            mov     al,[edi]
                inc     edi
                push    ebx
                push    eax
                call    UpCase
                pop     ebx
                or      al,al
                je      @@5
                mov     ah,al
                lodsb
                push    ebx
                push    eax
                call    upCase
                pop     ebx
                cmp     ah,keywordSep
                je      @@36
                inc     bl
                cmp     al,ah
                loope   @@2
                je      @@4
@@34:           mov     bl,0
                inc     bh
@@35:           mov     al,[edi]
                inc     edi
                or      al,al
                je      @@5
                cmp     al,keywordSep
                jne     @@35
                pop     ecx
                pop     esi
                jmp     @@1
@@36:           dec     edi
                cmp     [esi-1].byte,' '
                ja      @@34
@@4:            cmp     [edi].byte,keywordSep
                jne     @@34
                pop     ecx
                pop     esi
                mov     al,bh
                movzx   ebx,bl
                sub     [esi-1],bl
                sub     cl,bl
                mov     edi,esi
                add     esi,ebx
                rep     movsb
                jmp     @@6
@@5:            mov     al,0
                pop     ecx
                pop     esi
@@6:
end;

Function GetKeyword; assembler;
asm             cld
                mov     esi,Keyword
                mov     edi,@result
                mov     ecx,No
@@nextWord:     dec     ecx
                jz      @@done
@@scan:         lodsb
                test    al,al
                jz      @@notFound
                cmp     al,keywordSep
                jne     @@scan
                jmp     @@nextWord
@@done:         mov     ah,0
                mov     ebx,edi
                inc     edi
@@copyWord:     lodsb
                cmp     al,keywordSep
                je      @@end
                stosb
                jmp     @@copyWord
@@end:          mov     al,ah
                mov     edi,ebx
@@notFound:     stosb
end;

{$else}
Function First(ch : Char; const S : String) : Byte; assembler;
asm             cld
                les     di,S
                mov     cl,es:[di]
                mov     ch,0
                mov     bx,cx
                inc     di
                mov     al,&Ch
                jcxz    @@NO
                repne   scasb
                je      @@OK
@@NO:           mov     al,0
                jmp     @@LocEx
@@OK:           sub     bx,cx
                mov     ax,bx
@@LocEx:
end;

Function Last(ch : Char; const S : String) : Byte; assembler;
asm             std
                les     di,S
                mov     cl,es:[di]
                mov     ch,0
                mov     bx,cx
                add     di,cx
                mov     al,&Ch
                jcxz    @@NO
                repne   scasb
                je      @@OK
@@NO:           mov     al,0
                jmp     @@LocEx
@@OK:           mov     ax,bx
                sub     bx,cx
                sub     ax,bx
                inc     ax
@@LocEx:        cld
end;

Function ScanFwd(ch : Char; const S : String; N : Byte) : Byte; assembler;
asm             cld
                les     di,S
                mov     dh,N
                or      dh,dh
                je      @@NO
                mov     cl,es:[di]
                mov     ch,0
                mov     bx,cx
                inc     di
                mov     al,&Ch
@@NS:           jcxz    @@NO
                repne   scasb
                je      @@OK
@@NO:           mov     al,0
                jmp     @@LocEx
@@OK:           dec     dh
                jne     @@NS
                sub     bx,cx
                mov     ax,bx
@@LocEx:
end;

Function ScanBwd(ch : Char; const S : String; N : Byte) : Byte; assembler;
asm             std
                les     di,S
                mov     dh,N
                or      dh,dh
                je      @@NO
                mov     cl,es:[di]
                mov     ch,0
                mov     bx,cx
                add     di,cx
                mov     al,&Ch
@@NS:           jcxz    @@NO
                repne   scasb
                je      @@OK
@@NO:           mov     al,0
                jmp     @@LocEx
@@OK:           dec     dh
                jne     @@NS
                mov     ax,bx
                sub     bx,cx
                sub     ax,bx
                inc     ax
@@LocEx:        cld
end;

Function CharCount(ch : Char; const S : String) : Byte; assembler;
asm             cld
                les     di,S
                xor     dh,dh
                mov     cl,es:[di]
                mov     ch,0
                mov     bx,cx
                inc     di
                mov     al,&Ch
@@NS:           jcxz    @@NO
                repne   scasb
                je      @@OK
@@NO:           mov     al,dh
                jmp     @@LocEx
@@OK:           inc     dh
                jmp     @@NS
@@LocEx:
end;

Function Keyword(var S : String; var Keyword) : Byte; assembler;
asm             cld
                push    ds
                lds     si,S
                lodsb
                mov     cl,al
                mov     ch,0
                mov     bx,100h
                les     di,Keyword
@@1:            push    si
                push    cx
@@2:            mov     al,es:[di]
                inc     di
                call    @@loCase
                mov     ah,al
                lodsb
                call    @@loCase
                or      ah,ah
                je      @@5
                cmp     ah,keywordSep
                je      @@4
                inc     bl
                cmp     al,ah
                loope   @@2
                je      @@36
@@34:           mov     bl,0
                inc     bh
@@35:           mov     al,es:[di]
                inc     di
                or      al,al
                je      @@5
                cmp     al,keywordSep
                jne     @@35
                pop     cx
                pop     si
                jmp     @@1
@@36:           cmp     es:[di].byte,keywordSep
                jne     @@34
@@4:            pop     cx
                pop     si
                mov     al,bh
                sub     ds:[si-1],bl
                sub     cl,bl
                mov     bh,0
                mov     di,si
                add     si,bx
                push    ds
                pop     es
                rep     movsb
                jmp     @@6

@@loCase:       cmp     al,'A'
                jb      @@lcEx
                cmp     al,'Z'
                ja      @@lcEx
                or      al,20h
@@lcEx:         retn

@@5:            mov     al,0
                pop     cx
                pop     si
@@6:            pop     ds
end;

Function KeywordSpc(var S : String; var Keyword) : Byte; assembler;
asm             cld
                push    ds
                lds     si,S
                lodsb
                mov     cl,al
                mov     ch,0
                mov     bx,100h
                les     di,Keyword
@@1:            push    si
                push    cx
@@2:            mov     al,es:[di]
                inc     di
                call    @@loCase
                mov     ah,al
                lodsb
                call    @@loCase
                or      ah,ah
                je      @@5
                cmp     ah,keywordSep
                je      @@36
                inc     bl
                cmp     al,ah
                loope   @@2
                je      @@4
@@34:           mov     bl,0
                inc     bh
@@35:           mov     al,es:[di]
                inc     di
                or      al,al
                je      @@5
                cmp     al,keywordSep
                jne     @@35
                pop     cx
                pop     si
                jmp     @@1
@@36:           dec     di
                cmp     ds:[si-1].byte,' '
                ja      @@34
@@4:            cmp     es:[di].byte,keywordSep
                jne     @@34
                pop     cx
                pop     si
                mov     al,bh
                sub     ds:[si-1],bl
                sub     cl,bl
                mov     bh,0
                mov     di,si
                add     si,bx
                push    ds
                pop     es
                rep     movsb
                jmp     @@6

@@loCase:       cmp     al,'A'
                jb      @@lcEx
                cmp     al,'Z'
                ja      @@lcEx
                or      al,20h
@@lcEx:         retn

@@5:            mov     al,0
                pop     cx
                pop     si
@@6:            pop     ds
end;

Function GetKeyword; assembler;
asm             cld
                push    ds
                lds     si,Keyword
                les     di,@result
                mov     cx,No
@@nextWord:     dec     cx
                jz      @@done
@@scan:         lodsb
                test    al,al
                jz      @@notFound
                cmp     al,keywordSep
                jne     @@scan
                jmp     @@nextWord
@@done:         mov     ah,0
                mov     bx,di
                inc     di
@@copyWord:     lodsb
                cmp     al,keywordSep
                je      @@end
                inc     ah
                stosb
                jmp     @@copyWord
@@end:          mov     al,ah
                mov     di,bx
@@notFound:     stosb
                pop     ds
end;

Function Exclude; assembler;
asm             cld
                push    ds
                lds     si,S
                les     di,@result
                inc     di
                lodsb
                mov     cl,al
                mov     bx,di
                test    al,al
                je      @@done
                mov     ah,&ch
@@nextCh:       lodsb
                cmp     al,ah
                je      @@skip
                stosb
@@skip:         dec     cl
                jne     @@nextCh
@@done:         sub     di,bx
                mov     ax,di
                mov     es:[bx-1],al
                pop     ds
end;

{$endIf}

Procedure DelStartSpaces;
var I : Integer;
begin
 I := 1; While (I <= length(S)) and (S[I] in [' ',#9]) do Inc(I);
 Delete(S, 1, I - 1);
end;

Procedure DelTrailingSpaces;
begin
 While S[length(S)] in [' ', #9] do Dec(byte(S[0]));
end;

Function extractDir(const fName : string) : String;
var I : Byte;
begin
 I := length(fName);
 While (I > 0) and (not (fName[I] in ['/', '\', ':'])) do Dec(I);
 extractDir := Copy(fName, 1, I);
end;

Function extractName(const fName : string) : String;
var I : Byte;
begin
 I := length(fName);
 While (I > 0) and (not (fName[I] in ['/', '\', ':'])) do Dec(I);
 extractName := Copy(fName, I + byte(I > 0), 255);
end;

Function GetASCIIZ;
var I : Integer;
    P : pChar;
    S : String;
begin
 P := GetASCIIZptr(Text, No);
 S := '';
 While P^ <> #0 do begin S := S + P^; Inc(P); end;
 GetASCIIZ := S;
end;

Function GetASCIIZptr;
var I : Integer;
    P : pChar;
begin
 P := @Text;
 For I := 2 to No do
  begin
   While P^ <> #0 do Inc(P);
   Inc(P);
  end;
 GetASCIIZptr := P;
end;

Function CountASCIIZ;
var C : Longint;
    P : pChar;
begin
 P := @Text; C := 0;
 While Size > 0 do
  begin
   While (Size > 0) and (P^ <> #0) do begin Inc(P); Dec(Size); end;
   if Size > 0 then begin Inc(P); Dec(Size); end;
   Inc(C);
  end;
 CountASCIIZ := C;
end;

Function StripBlanks(const S : String) : String;
var RS  : String;
    I,J : Integer;
begin
 J := 0;
 For I := 1 to length(S) do
  if not (S[I] in [' ',#9,#0]) then begin Inc(J); RS[J] := S[I]; end;
 RS[0] := char(J);
 StripBlanks := RS;
end;

Function StrPercent;
var S : String;
    P : Longint;
    I : Integer;
begin
 P := 1; For I := 1 to NFrac + 2 do P := P * 10;
 S := SStr(longint(Val) * P div Max, NFrac + 1, '0');
 if NFrac > 0 then Insert('.', S, length(S) - NFrac + 1);
 StrPercent := S;
end;

Function StrFloat;
var S : String;
    P : Longint;
    I : Integer;
begin
 P := 1; For I := 1 to NFrac do P := P * 10;
 S := SStr(longint(Val) * P div Max, NFrac + 1, '0');
 if NFrac > 0 then Insert('.', S, length(S) - NFrac + 1);
 StrFloat := S;
end;

function RomanNumber(A : Word) : string; {0 < A < 2000}
var S : String[10];
begin
 if A >= 1000 then S := 'M' else S := '';
 A := A mod 1000;
 if A >= 100
    then case A div 100 of
          1..3 : S := S + Strg('C', A div 100);
          4    : S := S + 'CL';
          5..8 : S := S + 'L' + Strg('C', A div 100 - 5);
          9    : S := S + 'CM';
         end;
 A := A mod 100;
 if A >= 10
    then case A div 10 of
          1..3 : S := S + Strg('X', A div 10);
          4    : S := S + 'XL';
          5..8 : S := S + 'L' + Strg('X', A div 10 - 5);
          9    : S := S + 'XC';
         end;
 A := A mod 10;
 if A >= 1
    then case A of
          1..3 : S := S + Strg('I', A);
          4    : S := S + 'IV';
          5..8 : S := S + 'V' + Strg('I', A - 5);
          9    : S := S + 'IX';
         end;
 RomanNumber := S;
end;

Function Long2str(L : Longint) : String;
var A : String;
begin
 Str(L, A);
 Long2str := A;
end;

Function SignStr(L : Longint) : String;
var A : String;
begin
 Str(L, A);
 if L < 0
  then SignStr := A
  else
 if L > 0
  then SignStr := '+' + A
  else SignStr := ' ' + A;
end;

Function JustFilename(const PathName : String) : String;
var I : Integer;
begin
 I := length(PathName);
 While (I > 0) and (not (PathName[I] in [':','\'])) do Dec(I);
 JustFilename := Copy(PathName, I + 1, 255);
end;

Function Short;
var i,j : integer;
    ss  : string;
begin
 if length(pathName) < w then begin Short := pathName; Exit; end;
 i := 1; While (pathName[i] <> '\') and (pathName[i] <> ':') and (i < length(pathName)) do Inc(i);
 j := length(pathName); While (pathName[j] <> '\') and (pathName[j] <> ':') and (j > 1) do Dec(j);
 Inc(j);
 if i >= j then begin Short:=Copy(pathName, 1, w); Exit; end;
 ss := Copy(pathName, 1, i)+'\...\' + Copy(pathName, j, 255);
 if length(ss) > w then ss := Copy(pathName, 1, i)+Copy(pathName, j, 255);
 if length(ss) > w then ss := Copy(pathName, j, 255);
 Short:=Copy(ss, 1, w);
end;

{$ifDef OS_MAP_CASE}
var cc : CountryCode;
    I  : Longint;

begin
 FillChar(cc, SizeOf(cc), 0);
 For I := 0 to 255 do uCaseMap[char(I)] := char(I);
 lCaseMap := uCaseMap;
 if DosMapCase(256, cc, @uCaseMap) <> 0 then Halt(1);
 For I := 0 to 255 do
  if uCaseMap[char(I)] <> char(I)
   then lCaseMap[uCaseMap[char(I)]] := char(I);
{$endIf}
end.

