/*******************************************************\
* SwapMonitor Monitor Installation                      *
* Version 1.0                                           *
* (c) BMT Micro                     All Rights Reserved.*
\*******************************************************/

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

Parse Arg Directory

if Directory = "" then
   do
   r=Help();
   exit;
   end;

Call SysCls

Say
Say 'Installing SwapMonitor'

'md ' Directory ' 2> nul:'
'copy swapmon.exe '||Directory
'copy swapmon.hlp '||Directory
'copy swapmon.inf '||Directory
'copy swapdll.dll '||Directory
'copy order.frm '||Directory
'copy readthis.txt '||Directory
'copy file_id.diz '||Directory

Say;
Say 'Creating SwapMonitor Desktop objects.';
Say;

r = Call SysCreateObject("WPFolder","SwapMonitor","<WP_DESKTOP>","OBJECTID=<SWAPMON>","update")

if (r <> 0 ) then do

      r = Call SysCreateObject("WPProgram","SwapMonitor","<SWAPMON>",,
               "EXENAME="||Directory||"\SWAPMON.EXE;STARTUPDIR="||Directory,"replace" );

      r = Call SysCreateObject("WPProgram","SwapMon Reference","<SWAPMON>",,
               "EXENAME=VIEW.EXE;PARAMETERS="||Directory||"\SWAPMON.INF;STARTUPDIR="||Directory,"replace" );
   end;

else do
   say;
   say   'There was an error while creating the SwapMonitor Folder ';
   end;

Say 'SwapMonitor installation terminated.'
Say

Exit

Help:
      Say
      Say
      Say '     SwapMonitor Installation: '
      Say
      Say
      Say 'Usage:    Select your target directory and specify it as'
      Say '          parameter.'
      Say
      Say
      Say 'Example:      SINSTALL C:\SWAPMON '
      Say

Return 0;
