/****************************************************************************
 * Copyright Notice:                                                        *
 *  (c) Copyright 1995 by Stardock Systems, Inc. ALL RIGHTS RESERVED.       *
 *      This work protected by US Copyright Law.                            *
 *  You may not create derived works from this material.                    *
 ****************************************************************************
 * Name:            FIXORDER.CMD                                            *
 *                                                                          *
 * Description:     Reorder object replacement list so that Object Desktop  *
 *                  is first in chain for folder classes.                   *
 *                                                                          *
 *                  This "fixes" a bug in IBM's peer LAN product.           *
 *                                                                          *
 *                  Other Workplace Shell folder enhancements may also      *
 *                  conflict.  If you find some folder enhancement features *
 *                  are missing, this batch file may fix the problem.       *
 *                                                                          *
 ****************************************************************************/

/* Load system functions. */
Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs

/* Get replacelist for folder. */
ReplaceList = SysIni( USER, "PM_Workplace:ReplaceList", "WPFolder" )

/* If no class replacements are in place, quit. */
If ReplaceList = '' | ReplaceList = '00'x | ReplaceList = 'ERROR:' Then Do
    Say 'No need for adjustment.'
    Say 'There is no system folder replacement list.'
    Exit
End

/* If enhanced folder not in replace list, quit. */
If Pos( 'TSEnhFolder', ReplaceList ) <= 0 Then Do
    Say 'No need for adjustment.'
    Say 'Object Desktop folder replacement is not installed.'
    Exit
End

/* Disassemble replacement list. */
ParseReplaceList = ReplaceList
NextClass = '   '
iNext = 0
Do While ParseReplaceList <> '' & Pos( '00'x, ParseReplaceList ) > 0

    /* Get position of next NULL */
    iPos = Pos( '00'x, ParseReplaceList )

    /* Take leftmost portion of replace list. */
    AClass = Left( ParseReplaceList, iPos - 1 )
    If AClass = '' | AClass = '00'x Then Leave

    /* Assign class to list. */
    iNext = iNext + 1
    Class.iNext = AClass
    Class.0 = iNext

    /* Take rightmost portion of replace list. */
    ParseReplaceList = Right( ParseReplaceList, Length( ParseReplaceList ) - iPos )
End

/* for each class we have in the replace list. (ignore our class) */
Say
NewReplaceList = ''
Do i = 1 To Class.0
    If Class.i <> 'TSEnhFolder' Then Do
        NewReplaceList = NewReplaceList||Class.i||'00'x
    End
    Say 'Found class 'i':  ['Class.i']'
End
NewReplaceList = NewReplaceList||'TSEnhFolder'||'0000'x

/* Ask for confirmation. */
Say
Say 'Old replacement list: ['ReplaceList']'
Say 'New replacement list: ['NewReplaceList']'
If ReplaceList = NewReplaceList Then Do
    Say 'Replace list adjustment does not seem to be necessary.'
    Exit
End
Call CharOut, 'Make replacement?  (yN)  '
AKey = SysGetKey( 'NOECHO' )
Say
If AKey <> 'y' Then Exit

/* Write out new replacement list. */
Say 'Writing new replacment list....'
rc = SysIni( USER, "PM_Workplace:ReplaceList", "WPFolder", NewReplaceList )
If rc <> '' Then Do
    Say 'Failed!'
    Exit
End
Say 'OK.'
Say
Say 'Please restart your system to finish this adjustment.'


