/****************************************************************************
 * Copyright Notice:                                                        *
 *  (c) Copyright 1996 by Stardock Systems, Inc. ALL RIGHTS RESERVED.       *
 *      This work protected by US Copyright Law.                            *
 *  You may not create derived works from this material.                    *
 ****************************************************************************
 * Name:            AUTOINST.CMD                                            *
 *                                                                          *
 * Description:     Script file to start the reponse-file installation      *
 *                  of Object Desktop, assuming the current directory       *
 *                  as the source for installation.                         *
 *                                                                          *
 *                  Please customize the file OBJDESK.RSP for your site.    *
 ****************************************************************************/


/* Load system functions. */
Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs

/* Get source directory */
Parse Source . . szRexxName
szCurDir = Filespec( 'D', szRexxName ) || Filespec( 'P',szRexxName )

/* Get boot drive. */
szSystemDrive = FileSpec( 'Drive', Value( 'SYSTEM_INI',,'OS2ENVIRONMENT' ) )'\'

/* Build command line. */
szCmdLine = szCurDir'INSTALL.EXE /X /A:I /L1:'szSystemDrive'ACTION.LOG /L2:'szSystemDrive'HISTORY.LOG /R:'szCurDir'OBJDESK.RSP'

Say
Say 'AUTOINST:  Automatically install Object Desktop'
Say

/* Messages. */
Say 'Installing Object Desktop with: '
Do i = 1 To Words( szCmdLine )
    Say '   'Word( szCmdLine, i )
End
Say

/* Confirm. */
If ( Pos( 'Y', Arg(1) ) == 0 ) & ( Pos( 'y', Arg(1) ) == 0 ) Then Do
    Say 'NOTE: You may avoid this confirmation by specifying "y" on the command line.'
    Say
    Call CharOut, 'Install with these parameters? (y or n)  '
    Do Forever
        Key = SysGetKey( 'NOECHO' )
        If Key = 'Y' | Key = 'y' Then Leave
        Else If Key = 'N' | Key = 'n' Then Exit
        Call CharOut, '07'x
    End
    Say
    Say
End

'@start 'szCmdLine
