/****************************************************************************
 * Copyright Notice:                                                        *
 *  (c) Copyright 1995 by Stardock Systems, Inc. ALL RIGHTS RESERVED.       *
 *      This work protected by US Copyright Law.                            *
 *  You may not create derived works from this material.                    *
 ****************************************************************************
 * Name:            OBJDRMOV.CMD                                            *
 *                                                                          *
 * Description:     Remove SDS Object Desktop object ids and INI references *
 ****************************************************************************/

/* Load system functions. */
Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs

/* Confirm. */
Say
Say 'REMOBJD:  Utility to remove Object Desktop from your system.'
Say
Say 'This utility will remove the Object Desktop objects COMPLETELY.'
Call CharOut, 'Are you sure? (y or n)  '
Do Forever
    Key = SysGetKey( 'NOECHO' )
    If Key = 'Y' | Key = 'y' Then Leave
    Else If Key = 'N' | Key = 'n' Then Exit
    Call CharOut, '07'x
End
Say

/* List of object ids. */
Objects =,
      ' <OBJD_SETUP>',
      ' <OBJD_OBJECTNAVIGATOR>',
      ' <OBJD_ENHFOLDER>',
      ' <OBJD_ENHDATAFILE>',
      ' <OBJD_TASKMGR>',
      ' <OBJD_KEYLAUNCHPAD>',
      ' <OBJD_SHUTDOWN>',
      ' <OBJD_FIND>',
      ' <OBJD_LOCKUP>',
      ' <OBJD_TABLAUNCHPAD>',
      ' <OBJD_CONTROLCENTER>',
      ' <OBJD_CONTROLCENTER_DESKTOP>',
      ' <OBJD_CONTROLCENTER_OS2SYS>',
      ' <OBJD_CONTROLCENTER_DRIVES>',
      ' <OBJD_CONTROLCENTER_CONFIG>',
      ' <OBJD_CONTROLCENTER_INFO>',
      ' <OBJD_CONTROLCENTER_PROMPTS>',
      ' <OBJD_EMPTYZIP>',
      ' <OBJD_EMPTYLZH>',
      ' <OBJD_EMPTYZOO>',
      ' <OBJD_EMPTYARC>',
      ' <OBJD_TEMPLATE_EMPTYZIP>',
      ' <OBJD_TEMPLATE_EMPTYLZH>',
      ' <OBJD_TEMPLATE_EMPTYZOO>',
      ' <OBJD_TEMPLATE_EMPTYARC>',
      ' <OBJD_GETTINGSTARTED>',
      ' <OBJD_READMEFIRST>',
      ' <OBJD_PACKAGESDIR>',
      ' <OBJD_FOLDER_PACKAGES>',
      ' <STARDOCK_EXTRAS>',
      ' <STARDOCK_EXTRAS_README>',
      ' <STARDOCK_EXTRAS_ICONS>',
      ' <STARDOCK_EXTRAS_BITMAPS>',
      ' <STARDOCK_EXTRAS_ARCHIVERS>',
      ' <STARDOCK_EXTRAS_ARCHIVERS_DOC1>',
      ' <STARDOCK_EXTRAS_ARCHIVERS_DOC2>',
      ' <STARDOCK_EXTRAS_ARCHIVERS_DOC3>',
      ' <STARDOCK_EXTRAS_ARCHIVERS_DOC4>',
      ' <STARDOCK_EXTRAS_ARCHIVERS_DOC5>',
      ' <STARDOCK_EXTRAS_ARCHIVERS_DOC6>',
      ' <STARDOCK_EXTRAS_ARCHIVERS_DOC7>',
      ' <STARDOCK_EXTRAS_ARCHIVERS_DOC8>',
      ' <STARDOCK_EXTRAS_ARCHIVERS_COPYRIGHT>',
      ' <OBJD_TEMPLATE_OBJECTPACKAGE>',
      ' <OBJD_OBJECTPACKAGE>',
      ' <OBJD_STARDOCKINTERNET_PACKAGE_SHADOW>',
      ' <OBJD_STARDOCKINTERNET_SHADOW>',
      ' <OBJD_PACKAGEFOLDER>',
      ' <OBJD_OBJECTADVISOR>',
      ' <OBJD_OBJECTINSPECTOR>',
      ' <OBJD_BACKUPADVISOR>',
      ' <OBJD_OBJECTBACKUP_PROGRAM>',
      ' <OBJD_OBJECTBACKUP_DEVICE>',
      ' <OBJD_OBJECTBACKUP_SET>',
      ' <OBJD_OBJECTBACKUP_DRIVEA>',
      ' <OBJD_OBJECTBACKUP_SCHEDULER>',
      ' <OBJD_OBJECTBACKUP_USERGUIDE>',
      ' <OBJD_OBJECTBACKUP_UTILDISKS>',
      ' <OBJD_OBJECTBACKUP_SETS>',
      ' <OBJD_OBJECTBACKUP_CATALOGS>',
      ' <OBJD_OBJECTBACKUP_LOGS>',
      ' <OBJD_OBJECTBACKUP_TAPE>',
      ' <OBJD_OBJECTBACKUP>',
      ' <OBJD_FOLDER>'

/* List of object classes. */
Classes = ,
       ' TSZooElem',
       ' TSZooMgr',
       ' TSLHAElem',
       ' TSLHAMgr',
       ' TSZipElem',
       ' TSZipMgr',
       ' TSArcFileMgr',
       ' TSArcFileElem',
       ' TSArcElem',
       ' TSArcMgr',
       ' TSTabFolder',
       ' TSFldrParent',
       ' TSEnhDrives',
       ' TSEnhFolder',
       ' TSKeyLaunch',
       ' TSKeyDefn',
       ' TSEnhDataFile',
       ' TSTaskMgr',
       ' TSCPad',
       ' TSScript',
       ' TSScriptFind',
       ' TSScriptShutdown',
       ' TSScriptLockup',
       ' TSMasterSetup',
       ' TSPackageFile',
       ' TSPackageElem',
       ' TSInspect',
       ' TSObjAdv',
       ' TSPkgFolder'

Say
Say 'Destroying objects....'
Do i = 1 to Words( Objects )

    Object = Word( Objects, i )
    Call KillObj Object
End

Say
Say 'Removing classes....'
Do i = 1 to Words( Classes )

    If SysDeregisterObjectClass( Word( Classes, i ) ) <> 1 Then
        Say '    Can''t deregister class 'Word( Classes, i )'.'
    Else
        Say '    Deregistered class 'Word( Classes, i ) '.'
End

Exit

KillObj: Arg Object
    Say '    Killing 'Object'.'
    rc = SysDestroyObject( Object )
    Say '        Return = 'rc'.'
    rc = SysIni( USER, "PM_Workplace:Location", Object, 'DELETE:' )
    Say '        Return = 'rc'.'
    return

