/*****************************************************************************\
* NEWLOOK.CMD - main procedure                                                *
\*****************************************************************************/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
'@echo off'
'ECHO [47;31m'
'cls'

/* check working directory                                                   */
wkdir = SysSearchPath('PATH', 'NEWLOOK.CMD')
if wkdir = '' then do
   call alarm
   call SysCurPos 5, 0
   say '  NEWLOOK.CMD must be run in its own directory. Just double clic on its icon.'
   call SysCurPos 15, 2
   'pause'
   call SysDropFuncs
   exit
end

/* look for RC.EXE                                                           */
rcpath = SysSearchPath('PATH', 'RC.EXE')
if rcpath = '' then do
   call alarm
   call SysCurPos 5, 0
   say '  You must install RC.EXE in a directory included in the PATH statement of'
   say '  your CONFIG.SYS'
   call SysCurPos 15, 2
   'pause'
   call SysDropFuncs
   exit
end

/* look for Martin Lafaix's RESMGR                                           */
rdcpath = SysSearchPath('PATH', 'RDC.CMD')
resmgrpath = SysSearchPath('PATH', 'RESMGR.CMD')
rdcpppath = SysSearchPath('PATH', 'RDCPP.EXE')
nldir = DIRECTORY()
if (rdcpath = '' | resmgrpath = '' | rdcpppath = '') then do
   call alarm
   call SysCurPos 5, 0
   say '  You must install Martin Lafaix''s RESMGR in...'
   say '  'nldir
   say '  or any other directory included in the PATH statement of your CONFIG.SYS.'
   say '  See NEWLOOK.TXT for more details.'
   call SysCurPos 15, 2
   'pause'
   call SysDropFuncs
   exit
end

/* look for CMD.EXE                                                          */
cmdpath = SysSearchPath('PATH', 'CMD.EXE')
if cmdpath = '' then do
   call alarm
   call SysCurPos 5, 0
   say '  cannot find CMD.EXE. If you use a different command processor you must'
   say '  reinstall CMD.EXE or edit NEWLOOK.CMD file, replacing all CMD.EXE'
   say '  occurrencies with the name of the executable of your command processor.'
   call SysCurPos 15, 2
   'pause'
   call SysDropFuncs
   exit
end

/* gets OS/2 drive and directory                                             */
os2drive = FILESPEC('drive', cmdpath)
os2path = FILESPEC('path', cmdpath)

call mainmenu
call SysDropFuncs
exit


/*****************************************************************************\
*  mainmenu: menu procedure                                                   *
\*****************************************************************************/

mainmenu:
   say '[47m'
   'cls'
   call SysCurPos 2, 0
   say '  [37;1m [30m'
   say '  [37;1m  [40;31;1m                                                                      [47;30m '
   say '  [37;1m  [40;31;1m   ACTION                                                  COMMAND    [47;30m '
   say '  [37;1m  [40;32;1m   Read NEWLOOK.TXT ...................................... read       [47;30m '
   say '  [37;1m  [40;32;1m   Edit the new system icons ............................. editico    [47;30m '
   say '  [37;1m  [40;32;1m   Edit the new window controls .......................... editctls   [47;30m '
   say '  [37;1m  [40;32;1m   Change the default system icons ....................... newico     [47;30m '
   say '  [37;1m  [40;32;1m   Change window controls ................................ newctls    [47;30m '
   say '  [37;1m  [40;32;1m   Change both system icon and window controls ........... newall     [47;30m '
   say '  [37;1m  [40;32;1m   Restore original system icons ......................... restico    [47;30m '
   say '  [37;1m  [40;32;1m   Restore original window controls ...................... restctls   [47;30m '
   say '  [37;1m  [40;32;1m   Restore both original system icons and window controls  restall    [47;30m '
   say '  [37;1m  [40;32;1m   Exit .................................................. quit       [47;30m '
   say '  [37;1m  [40;31;1m                                                                      [47;30m '
   say '  [37;1m [47;30m'

   say '[34m'
   call SysCurPos 18, 0
   say '  [37;1m [30m'
   say '  [37;1m  [40m                                                                      [47;30m '
   say '  [37;1m  [40m                                                                      [47;30m '
   say '  [37;1m  [40m                                                                      [47;30m '
   say '  [37;1m [47;30m'
   do while done \= 1
      call SysCurPos 20, 8
      say '[40;32;1m                                                          '
      call SysCurPos 20, 8
      pull action
      say '[47;34m'
      select
         when action = 'READ'          /* read program documentation         */
            then do
               call readdoc
               call mainmenu
               done = 1
            end
         when action = 'EDITICO'       /* open SYSICONS folder for editing   */
            then do
               call editing 'SYSICONS'
               call mainmenu
               done = 1
            end
         when action = 'EDITCTLS'      /* open WINCTLS folder for editing    */
            then do
               call editing 'WINCTLS'
               call mainmenu
               done = 1
            end
         when action = 'NEWICO'        /* patch PMWP.DLL                     */
            then do
               call patchdll 'PMWP'
               call endmsg
               done = 1
            end
         when action = 'NEWCTLS'       /* patch PMMERGE.DLL                  */
            then do
               call patchdll , 'PMMERGE'
               call endmsg
               done = 1
            end
         when action = 'NEWALL'        /* patch both PMWP.DLL and PMMERGE.DLL*/
            then do
               call patchdll 'PMWP', 'PMMERGE'
               call endmsg
               done = 1
            end
         when action = 'RESTICO'       /* restore original PMWP.DLL          */
            then do
               call restore 'PMWP'
               call endmsg
               done = 1
            end
         when action = 'RESTCTLS'      /* restore original PMMERGE.DLL       */
            then do
               call restore , 'PMMERGE'
               call endmsg
               done = 1
            end
         when action = 'RESTALL'       /* restore original PMWP and PMMERGE  */
            then do
               call restore 'PMWP', 'PMMERGE'
               call endmsg
               done = 1
            end
         when action = 'QUIT'          /* terminate NEWLOOK.CMD and exit     */
            then do
               call SysDropFuncs
               exit
            end
         otherwise                     /* unvalid command: alarm and loop    */
            call alarm
      end                              /* end select                         */
   end                                 /* end do                             */
return


/*****************************************************************************\
*  readdoc: shows the program documentation                                   *
\*****************************************************************************/

readdoc:
   editpath = SysSearchPath('PATH', 'E.EXE')
   if editpath = '' then do
      'cls'
      call alarm
      call SysCurPos 5, 0
      say '  Cannot find E.EXE.'
      call SysCurPos 15, 2
      pause
      call SysDropFuncs
      exit
   end
   e NEWLOOK.TXT
return


/*****************************************************************************\
*  editing: opens "SYSICONS" or "WINCTLS" folder for editing                  *
\*****************************************************************************/

editing:
arg folder
   'cls'
   call alarm
   call SysCurPos 5, 0
   say '  Now the' folder 'folder will be opened.'
   say '  Icons are saved with a PTR extension. Do not rename them!'
   say '  Icons and Bitmaps are saved in various formats. Remember to check all'
   say '  the available formats by the "Device | List... | View" menu commands.'
   say '  See NEWLOOK.TXT for more details.'
   call SysCurPos 15, 2
   pause
   rc = SysOpenObject(nldir || '\' || folder, 'default', 'FALSE')
   if rc = 0 then do
      call alarm
      call SysCurPos 5, 0
      say '  Cannot open ' nldir || '\' || folder
      call SysCurPos 15, 2
      pause
      call SysDropFuncs
      exit
   end
return


/*****************************************************************************\
*  endmsg: after patching DDLs says you must reboot                           *
\*****************************************************************************/

endmsg:
   cls
   call endsnd
   call SysCurPos 5, 0
   say '  Your system files have been updated. You must reboot in order to'
   say '  let changes take into effect'
   call SysCurPos 15, 2
   pause
return


/*****************************************************************************\
*  patchdll: backups DLLs passed as arguments, patches them, patches          *
*  CONFIG.SYS and swaps old DLLs with new ones on next reboot                 *
\*****************************************************************************/

patchdll:
arg name1, name2
   'cls'
   say
   'copy' os2drive || '\CONFIG.SYS' os2drive || '\CONFIG.NLK'
   'del' os2drive || '\CONFIG.SYS'     /* back up config.sys                 */
   if name1 = ''
      then nop
   else do                             /* PMWP.DLL                           */
      call checkbackup name1, 'PATCH'
      filename = checkdll(name1)
      'copy' filename
      'copy PMWP.DLL PMWP.SAV'
      'rc -r SYSICONS\PMWP.RC'
      call resmgr '-a PMWP.DLL SYSICONS\PMWP.RES'
      ' del SYSICONS\PMWP.RES'
      'echo call=' || cmdpath '/c copy' nldir || '\PMWP.DLL' os2drive || os2path,
                   || 'DLL >>' os2drive || '\CONFIG.SYS'
      'echo call=' || cmdpath '/c del' nldir || '\PMWP.DLL >>' os2drive,
                   || '\config.sys'
   end
   if name2 = ''
      then nop
   else do                             /* PMMERGE.DLL                        */
      call checkbackup name2, 'PATCH'
      filename = checkdll(name2)
      'copy' filename
      'copy PMMERGE.DLL PMMERGE.SAV'
      'rc -r WINCTLS\PMMERGE.RC'
      call resmgr '-a PMMERGE.DLL WINCTLS\PMMERGE.RES'
      'del WINCTLS\PMMERGE.RES'
      'echo call='|| cmdpath '/c copy' nldir || '\PMMERGE.DLL' os2drive || os2path,
                  || 'DLL >>' os2drive || '\CONFIG.SYS'
      'echo call=' || cmdpath '/c del' nldir || '\PMMERGE.DLL >>' os2drive,
                   || '\config.sys'
   end
   'type' os2drive || '\CONFIG.NLK >>' os2drive || '\CONFIG.SYS'
   'echo call=' || cmdpath '/c copy' os2drive || '\CONFIG.NLK' os2drive,
                || '\CONFIG.SYS >>' os2drive || '\CONFIG.SYS'
return


/*****************************************************************************\
*  checkdll: checks PMWP.DLL or PMMERGE.DLL existence                         *
\*****************************************************************************/

checkdll: procedure expose os2drive os2path
arg dllname
   filename = stream( os2drive || os2path || '\DLL\' || dllname || '.DLL', 'C',,
                     'query exists')
   if filename = '' then do
      call alarm
      call SysCurPos 5, 0
      say '  Cannot find ' dllname || '.DLL in ' os2drive || os2path,
             || '\DLL directory'
      call SysCurPos 15, 2
      'pause'
      'rename ' os2drive || '\CONFIG.NLK CONFIG.SYS'
      call SysDropFuncs
      exit
   end
return filename


/*****************************************************************************\
*  restore: restore backup copies of original DLLs                            *
\*****************************************************************************/

restore:
arg name1, name2
   'cls'
   say
   'copy' os2drive || '\CONFIG.SYS' os2drive || '\CONFIG.NLK'
   'del' os2drive || '\CONFIG.SYS'     /* back up config.sys                 */
   if name1 = ''
      then nop
   else do                             /* PMWP.DLL                           */
      filename = checkbackup(name1, 'RESTORE')
      'echo call=' || cmdpath '/c copy' filename os2drive || os2path,
                  || 'DLL\PMWP.DLL >>' os2drive || '\CONFIG.SYS'
      'echo call=' || cmdpath '/c del' filename '>>' os2drive || '\CONFIG.SYS'
   end
   if name2 = ''
      then nop
   else do                             /* PMMERGE.DLL                        */
      filename = checkbackup(name2, 'RESTORE')
      'echo call=' || cmdpath '/c copy' filename os2drive || os2path,
                  || 'DLL\PMMERGE.DLL >>' os2drive || '\CONFIG.SYS'
      'echo call=' || cmdpath '/c del' filename '>>' os2drive || '\CONFIG.SYS'
   end
   'type' os2drive || '\CONFIG.NLK >>' os2drive || '\CONFIG.SYS'
   'echo call=' || cmdpath '/c copy' os2drive || '\CONFIG.NLK' os2drive,
                || '\CONFIG.SYS >>' os2drive || '\CONFIG.SYS'
return


/*****************************************************************************\
*  checkbackup: checks the existence of original backup copies of PMWP.DLL    *
*  or PMMERGE.DLL                                                             *
\*****************************************************************************/

checkbackup: procedure expose nldir os2drive
arg dllname, action
   filename = stream( nldir || '\' || dllname || '.SAV', 'C', 'query exists')
   select
      when (filename = '' & action = 'RESTORE')
         then do
            'cls'
            call alarm
            call SysCurPos 5, 0
            say '  Cannot find backup copy of' dllname || '.DLL in ' nldir || 'directory!'
            say '  You must copy the original from the installation disk renaming it',
                   dllname || '.SAV'
            call SysCurPos 15, 2
            'pause'
            'rename ' os2drive || '\CONFIG.NLK CONFIG.SYS'
            call SysDropFuncs
            exit
         end
      when (filename \= '' & action = 'PATCH')
         then do
            'cls'
            call alarm
            call SysCurPos 5, 0
            say '  NEWLOOK has detected a backup copy of' dllname || '.DLL .'
            say '  Since RESMGR does not work correctly when re-patching DLLs,'
            say '  you must restore original OS/2 DLLs before patching them.'
            say '  Anyway if you have just installed an OS/2 fixpack, overwriting so'
            say '  previously patched DLLs, you can patch the new DLLs now.'
            say '  Type "continue" to patch DLLs, press "enter" to go back to mainmenu'
            pull reply
            if reply = 'CONTINUE' then
               return filename
            else do
               'rename ' os2drive || '\CONFIG.NLK CONFIG.SYS'
               call mainmenu
            end
         end
      otherwise
         nop
   end
return filename


alarm:
  call beep 1000,300
  call beep 100, 300
return

endsnd:
  x=5000
  do 99
    x = x - 50
    call beep (x), 1
  end
return
