/* SUOMI.CMD: Install MEMSIZE in Finnish. */

'@Echo Off'
'CHCP 850'

/* Load REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Initialize */

Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say 'Asennan MEMSIZE-ohjelmaa...'
Say ''


/* Verify the existence of the various component files. */

Language = 'SUOMI'

Result = SysFileTree( 'MEMSIZE.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'VIRHE: En lytnyt MEMSIZE.EXE-tiedostoa!'
  Signal DONE
  End

Result = SysFileTree( Language".DLL", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'VIRHE: En lytnyt 'Language'.DLL-tiedostoa!'
  Signal DONE
  End

Result = SysFileTree( Language".HLP", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'VIRHE: En lytnyt 'Language'.HLP-tiedostoa!'
  Signal DONE
  End

/* Ask for the target directory name. */

Default = SysIni('USER', 'MEMSIZE', 'INIPATH' )
If Default = 'VIRHE:'
  Then Default = 'C:\OS2\Apps'
If SUBSTR(Default,LENGTH(Default),1) <= ' '
  Then Default = SUBSTR(Default,1,LENGTH(Default)-1)

Say 'Kirjoita hakemiston nimi, johon haluat MEMSIZE-ohjelman asennettavaksi'
Say '  ja paina ENTER (oletushakemisto on 'Default'): '
Parse Pull Directory
If Directory = "" Then Directory = Default


/* Create the target directory if necessary. */

Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'VIRHE: Asennushakemiston tekeminen ei onnistunut.'
    Signal DONE
    End
  End
Say ''


/* Save the target directory. */

SysIni( "USER", "MEMSIZE", "INIPATH", Directory )
SysIni( Directory"\MEMSIZE.INI", "MEMSIZE", "INIPATH", Directory )


/* Ask for the target folder. */

Say 'Haluatko, ett MEMSIZE kynnistetn alkulatauksen yhteydess? (K/E)'
Pull YesNo
If YesNo = "K" Then
  Do
  Folder = '<WP_START>'
  Say 'Ohjelmakuvake sijoitetaan Aloitus-kansioon.'
  End
Else
  Do
  Folder = '<WP_DESKTOP>'
  Say 'Ohjelmakuvake sijoitetaan typydlle.'
  End
Say ''


/* Destroy the old object, if present. */

Call SysDestroyObject( '<MEMSIZE>' )
Call SysSleep( 5 )


/* Perform the installation. */

Say 'Kopioin MEMSIZE-ohjelman hakemistoon 'Directory' ...'
Copy MEMSIZE.EXE Directory                  '1>NUL'
Copy Language".DLL" Directory"\MEMSIZE.DLL" '1>NUL'
Copy Language".HLP" Directory"\MEMSIZE.HLP" '1>NUL'
Copy Language".DOC" Directory"\MEMSIZE.DOC" "1>NUL"

Result = SysFileTree( "HLP2INF.EXE", 'Files', 'F' )
If Files.0 > 0 Then
   Do
   Result = SysFileTree( Directory"\MEMSIZE.INF", 'Files', 'F' )
   If Files.0 > 0 Then
      Do
      "Erase" Directory"\MEMSIZE.INF"
      End
   "HLP2INF" Directory"\MEMSIZE.HLP"
   End

Result = SysFileTree( "SNAPSHOT.EXE", 'Files', 'F' )
If Files.0 > 0 Then
   Do
   Copy "SNAPSHOT.EXE" Directory"\SNAPSHOT.EXE"  '1>NUL'
   End

Say 'Luon ohjelmakuvaketta...'
Type = 'WPProgram'
Title = 'Jrjestelmresurssit'
Parms = 'OPEN=DEFAULT;MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\MEMSIZE.EXE;STARTUPDIR='Directory';OBJECTID=<MEMSIZE>;NOPRINT=YES;'
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )

If Result = 1 Then
  Say 'Ohjelmakuvake on luotu!  Asennus on valmis.'
Else
  Say 'VIRHE: Ohjelmakuvakkeen luominen eponnistui!'

Signal DONE

FAILURE:
Say 'REXX: eponnistuminen.'
Signal DONE

HALT:
Say 'REXX-pyshdys.'
Signal DONE

SYNTAX:
Say 'REXX-kielioppivirhe.'
Signal DONE

DONE:
Exit
