/******************************************************************** ITEMS.H
 *                                                                          *
 *                     Display Item Class Definition                        *
 *                                                                          *
 ****************************************************************************/

#ifndef ITEMS_H
#define ITEMS_H

#ifndef OS2_INCLUDED
   #define INCL_BASE
   #define INCL_PM
   #include <os2.h>
#endif

#include <time.h>

#include "Dde.h"
#include "ReString.h"

extern void Log ( char *Message, ... ) ;

class Item {

   private:
      USHORT Id ;                  // Item ID.
      BOOL   Flag ;                // Flag: Show this item at this time?
      char   Name [80] ;           // Text for items profile name.
      char   DefaultLabel [80] ;   // Text to display on left part of line (default).
      Dde_Server *pDdeServer ;     // -> DDE Server object
      char Topic [80] ;            // DDE Topic name
      Dde_Item *pDdeItem ;         // -> DDE Item object

   protected:
      char   CurrentLabel [80] ;   // Text to display on left part of line.
      ULONG  Value ;               // Current value.
      int    LevelSense ;          // Flag: If +1, level sensing has Error > Warning > Normal.
      ULONG  MinLevel, MaxLevel ;  //       If -1, Error < Warning < Normal.  If zero, level checks are disabled.
      ULONG  WarningLevel, ErrorLevel, DefaultLevels[2] ;
      COLOR  NormalColors[2], WarningColors[2], ErrorColors[2] ;

   public:
      Item ( USHORT id, char *pName, char *pCurrentLabel, char *pDefaultLabel, Dde_Server *ddeserver, char *topic ) ;
      virtual ~Item ( ) ;

      void GetProfile ( HINI IniHandle ) ;
      void PutProfile ( HINI IniHandle ) ;

      USHORT QueryId           ( void ) { return ( Id   ) ; }
      BOOL   QueryFlag         ( void ) { return ( Flag ) ; }
      PCHAR  QueryName         ( void ) { return ( Name ) ; }
      PCHAR  QueryCurrentLabel ( void ) { return ( CurrentLabel ) ; }
      PCHAR  QueryDefaultLabel ( void ) { return ( DefaultLabel ) ; }
      ULONG  QueryValue        ( void ) { return ( Value ) ; }

      void SetLabel ( char *label ) { strcpy ( CurrentLabel, label ) ;  Value = 0 ; }

      void SetNormalColors ( COLOR Background, COLOR Foreground ) {
         NormalColors[0] = Background ;
         NormalColors[1] = Foreground ;
      } /* endmethod */

      ULONG QueryMinLevel   ( ) { return ( MinLevel ) ; }
      ULONG QueryMaxLevel   ( ) { return ( MaxLevel ) ; }
      int   QueryLevelSense ( ) { return ( LevelSense ) ; }

      void SetMinLevel   ( ULONG Level ) { MinLevel = Level ; }
      void SetMaxLevel   ( ULONG Level ) { MaxLevel = Level ; }
      void SetLevelSense ( int   Sense ) { LevelSense = Sense ; }

      void QueryDefaultLevels ( ULONG &Warning, ULONG &Error ) {
         Warning = DefaultLevels [0] ;
         Error = DefaultLevels [1] ;
      } /* endmethod */

      ULONG QueryWarningLevel ( ) { return ( WarningLevel ) ; }
      void SetWarningLevel ( ULONG Level ) { WarningLevel = Level ; }
      void SetWarningColors ( COLOR Background, COLOR Foreground ) {
         WarningColors[0] = Background ;
         WarningColors[1] = Foreground ;
      } /* endmethod */

      ULONG QueryErrorLevel ( ) { return ( ErrorLevel ) ; }
      void SetErrorLevel ( ULONG Level ) { ErrorLevel = Level ; }
      void SetErrorColors ( COLOR Background, COLOR Foreground ) {
         ErrorColors[0] = Background ;
         ErrorColors[1] = Foreground ;
      } /* endmethod */

      void SetFlag   ( void ) { Flag = TRUE ; }
      void ResetFlag ( void ) { Flag = FALSE ; }

      void DdeUpdate ( char *Text ) ;

      void Paint ( HPS hPS, RECTL &Rectangle, 
         char *Label, char *Text, ULONG NewValue, int Scale=1 ) ;

      // The following functions must be provided by all subclasses.

      virtual int Measure ( HPS hPS, RECTL &Rectangle ) = 0 ;

      virtual ULONG NewValue ( void ) = 0 ;

      virtual void FormatText ( char *Label, char *Text, ULONG Value ) = 0 ;

      virtual void FormatLine ( char *Buffer, int MaxWidth ) ;

      virtual void Repaint ( HPS hPS, RECTL &Rectangle, BOOL Mandatory ) = 0 ;
} ;

class Clock : public Item {

   private:
      COUNTRYINFO CountryInfo ;
      char szAm [8] ;
      char szPm [8] ;
      ResourceString *DaysOfWeek ;
      BOOL ShowSeconds ;
      BOOL Hour24 ;

   public:
      Clock ( USHORT id, char *pName, char *pCurrentLabel, char *pDefaultLabel, 
         Dde_Server *pDdeServer, char *Topic, COUNTRYINFO &countryinfo,
         char *szam, char *szpm, ResourceString *daysofweek, BOOL showseconds, BOOL hour24 ) ;

      void SetShowSeconds ( BOOL showseconds ) { ShowSeconds = showseconds ; Value = 0 ; }
      void SetHour24 ( BOOL hour24 ) { Hour24 = hour24 ; Value = 0 ; } 

      int Measure ( HPS hPS, RECTL &Rectangle ) ;
      ULONG NewValue ( void ) ;
      void FormatText ( char *Label, char *Text, ULONG Value ) ;
      void FormatLine ( char *Buffer, int MaxWidth ) ;
      void Repaint ( HPS hPS, RECTL &Rectangle, BOOL Mandatory ) ;
} ;

class ElapsedTime : public Item {

   private:
      COUNTRYINFO CountryInfo ;
      ResourceString *Day ;
      ResourceString *Days ;
      BOOL ShowSeconds ;

   public:
      ElapsedTime ( USHORT id, char *pName, char *pCurrentLabel, char *pDefaultLabel, 
         Dde_Server *pDdeServer, char *Topic, COUNTRYINFO &countryinfo,
         ResourceString *day, ResourceString *days, BOOL showseconds ) ;

      void SetShowSeconds ( BOOL showseconds ) { ShowSeconds = showseconds ;  Value = 0 ; }

      int Measure ( HPS hPS, RECTL &Rectangle ) ;
      ULONG NewValue ( void ) ;
      void FormatText ( char *Label, char *Text, ULONG Value ) ;
      void Repaint ( HPS hPS, RECTL &Rectangle, BOOL Mandatory ) ;
} ;

class MemoryFree : public Item {

   private:
      COUNTRYINFO CountryInfo ;
      USHORT ShowK, ShowTrueK, ShowM ;

   public:
      MemoryFree ( USHORT id, char *pName, char *pCurrentLabel, char *pDefaultLabel, 
         Dde_Server *pDdeServer, char *Topic, COUNTRYINFO &countryinfo, USHORT sk, USHORT stk, USHORT sm ) ;

      void SetShowK     ( USHORT flag ) { ShowK = flag ;  Value = 0 ; }
      void SetShowTrueK ( USHORT flag ) { ShowTrueK = flag ;  Value = 0 ; }
      void SetShowM     ( USHORT flag ) { ShowM = flag ;  Value = 0 ; }

      int Measure ( HPS hPS, RECTL &Rectangle ) ;
      ULONG NewValue ( void ) ;
      void FormatText ( char *Label, char *Text, ULONG Value ) ;
      void Repaint ( HPS hPS, RECTL &Rectangle, BOOL Mandatory ) ;
} ;

class VirtualFree : public Item {

   private:
      COUNTRYINFO CountryInfo ;
      USHORT ShowK, ShowTrueK, ShowM ;

   public:
      VirtualFree ( USHORT id, char *pName, char *pCurrentLabel, char *pDefaultLabel, 
         Dde_Server *pDdeServer, char *Topic, COUNTRYINFO &countryinfo, USHORT sk, USHORT stk, USHORT sm ) ;

      void SetShowK     ( USHORT flag ) { ShowK = flag ;  Value = 0 ; }
      void SetShowTrueK ( USHORT flag ) { ShowTrueK = flag ;  Value = 0 ; }
      void SetShowM     ( USHORT flag ) { ShowM = flag ;  Value = 0 ; }

      int Measure ( HPS hPS, RECTL &Rectangle ) ;
      ULONG NewValue ( void ) ;
      void FormatText ( char *Label, char *Text, ULONG Value ) ;
      void Repaint ( HPS hPS, RECTL &Rectangle, BOOL Mandatory ) ;
} ;

class SwapSize : public Item {

   private:
      COUNTRYINFO CountryInfo ;
      USHORT ShowK, ShowTrueK, ShowM ;
      PSZ SwapPath ;

   public:
      SwapSize ( USHORT id, char *pName, char *pCurrentLabel, char *pDefaultLabel, 
         Dde_Server *pDdeServer, char *Topic, COUNTRYINFO countryinfo, 
         USHORT sk, USHORT stk, USHORT sm, PSZ swappath, ULONG initialsize ) ;
      ~SwapSize ( void ) ;

      void SetShowK     ( USHORT flag ) { ShowK = flag ;  Value = 0 ; }
      void SetShowTrueK ( USHORT flag ) { ShowTrueK = flag ;  Value = 0 ; }
      void SetShowM     ( USHORT flag ) { ShowM = flag ;  Value = 0 ; }

      int Measure ( HPS hPS, RECTL &Rectangle ) ;
      ULONG NewValue ( void ) ;
      void FormatText ( char *Label, char *Text, ULONG Value ) ;
      void Repaint ( HPS hPS, RECTL &Rectangle, BOOL Mandatory ) ;
} ;

class SwapFree : public Item {

   private:
      COUNTRYINFO CountryInfo ;
      USHORT ShowK, ShowTrueK, ShowM ;
      PSZ SwapPath ;
      ULONG MinFree ;

   public:
      SwapFree ( USHORT id, char *pName, char *pCurrentLabel, char *pDefaultLabel, 
         Dde_Server *pDdeServer, char *Topic, COUNTRYINFO &countryinfo,
         USHORT sk, USHORT stk, USHORT sm, PSZ swappath, ULONG minfree ) ;
      ~SwapFree ( void ) ;

      void SetShowK     ( USHORT flag ) { ShowK = flag ;  Value = 0 ; }
      void SetShowTrueK ( USHORT flag ) { ShowTrueK = flag ;  Value = 0 ; }
      void SetShowM     ( USHORT flag ) { ShowM = flag ;  Value = 0 ; }

      int Measure ( HPS hPS, RECTL &Rectangle ) ;
      ULONG NewValue ( void ) ;
      void FormatText ( char *Label, char *Text, ULONG Value ) ;
      void Repaint ( HPS hPS, RECTL &Rectangle, BOOL Mandatory ) ;
} ;

class SpoolSize : public Item {

   private:
      COUNTRYINFO CountryInfo ;
      USHORT ShowK, ShowTrueK, ShowM ;
      PSZ SpoolPath ;

   public:
      SpoolSize ( USHORT id, char *pName, char *pCurrentLabel, char *pDefaultLabel, 
         Dde_Server *pDdeServer, char *Topic, COUNTRYINFO &countryinfo, 
         USHORT sk, USHORT stk, USHORT sm, PSZ spoolpath ) ;
      ~SpoolSize ( void ) ;

      void SetShowK     ( USHORT flag ) { ShowK = flag ;  Value = 0 ; }
      void SetShowTrueK ( USHORT flag ) { ShowTrueK = flag ;  Value = 0 ; }
      void SetShowM     ( USHORT flag ) { ShowM = flag ;  Value = 0 ; }

      int Measure ( HPS hPS, RECTL &Rectangle ) ;
      ULONG NewValue ( void ) ;
      void FormatText ( char *Label, char *Text, ULONG Value ) ;
      void Repaint ( HPS hPS, RECTL &Rectangle, BOOL Mandatory ) ;
} ;

class CpuLoad : public Item {

   private:
      PULONG IdleCount ;
      ULONG MaxCount ;
      ResourceString *Error ;

   public:
      CpuLoad ( USHORT id, char *pName, char *pCurrentLabel, char *pDefaultLabel, 
         Dde_Server *pDdeServer, char *Topic, ULONG maxcount, PULONG idlecount, ResourceString *error ) ;

      int Measure ( HPS hPS, RECTL &Rectangle ) ;
      ULONG NewValue ( void ) ;
      void FormatText ( char *Label, char *Text, ULONG Value ) ;
      void Repaint ( HPS hPS, RECTL &Rectangle, BOOL Mandatory ) ;
} ;

class TaskCount : public Item {

   private:
      HAB Anchor ;

   public:
      TaskCount ( USHORT id, char *pName, char *pCurrentLabel, char *pDefaultLabel, 
         Dde_Server *pDdeServer, char *Topic, HAB anchor ) ;

      int Measure ( HPS hPS, RECTL &Rectangle ) ;
      ULONG NewValue ( void ) ;
      void FormatText ( char *Label, char *Text, ULONG Value ) ;
      void Repaint ( HPS hPS, RECTL &Rectangle, BOOL Mandatory ) ;
} ;

class DriveFree : public Item {

   private:
      COUNTRYINFO CountryInfo ;
      USHORT ShowK, ShowTrueK, ShowM ;
      ResourceString *DriveError ;
      USHORT DriveNumber ;
      BOOL ShowFileSystemName ;
      BYTE FileSystem [80] ;
      BOOL ShowDiskLabel ;
      BYTE DiskLabel [12] ;
      BOOL Error ;

   public:
      DriveFree ( USHORT id, char *pName, char *pCurrentLabel, char *pDefaultLabel, 
         Dde_Server *pDdeServer, char *Topic, COUNTRYINFO &countryinfo, 
         USHORT sk, USHORT stk, USHORT sm, USHORT drivenumber, ResourceString *driveerror, BOOL showfilesystemname, 
         PSZ filesystem, BOOL showdisklabel, PSZ disklabel ) ;

      void SetShowK     ( USHORT flag ) { ShowK = flag ;  Value = 0 ; }
      void SetShowTrueK ( USHORT flag ) { ShowTrueK = flag ;  Value = 0 ; }
      void SetShowM     ( USHORT flag ) { ShowM = flag ;  Value = 0 ; }
      void SetShowFileSystemName ( BOOL showfilesystemname ) { ShowFileSystemName = showfilesystemname ;  Value = 0 ; }
      void SetShowDiskLabel ( BOOL showdisklabel ) { ShowDiskLabel = showdisklabel ;  Value = 0 ; }
      void ResetError ( ) { Error = FALSE ; } 

      int Measure ( HPS hPS, RECTL &Rectangle ) ;
      ULONG NewValue ( void ) ;
      void FormatText ( char *Label, char *Text, ULONG Value ) ;
      void Repaint ( HPS hPS, RECTL &Rectangle, BOOL Mandatory ) ;
} ;

class TotalFree : public Item {

   private:
      COUNTRYINFO CountryInfo ;
      USHORT ShowK, ShowTrueK, ShowM ;
      ULONG Drives ;

   public:
      TotalFree ( USHORT id, char *pName, char *pCurrentLabel, char *pDefaultLabel, 
         Dde_Server *pDdeServer, char *Topic, COUNTRYINFO &countryinfo, 
         USHORT sk, USHORT stk, USHORT sm, ULONG drives ) ;

      void SetShowK     ( USHORT flag ) { ShowK = flag ;  Value = 0 ; }
      void SetShowTrueK ( USHORT flag ) { ShowTrueK = flag ;  Value = 0 ; }
      void SetShowM     ( USHORT flag ) { ShowM = flag ;  Value = 0 ; }
      void ResetMask ( ULONG drives ) { Drives = drives ; }
      ULONG QueryMask ( ) { return ( Drives ) ; }

      int Measure ( HPS hPS, RECTL &Rectangle ) ;
      ULONG NewValue ( void ) ;
      void FormatText ( char *Label, char *Text, ULONG Value ) ;
      void Repaint ( HPS hPS, RECTL &Rectangle, BOOL Mandatory ) ;
} ;

class SwapSlack : public Item {

   private:
      COUNTRYINFO  CountryInfo ;
      USHORT ShowK, ShowTrueK, ShowM ;
      VirtualFree *pVirtualFree ;
      SwapFree    *pSwapFree ;
      MemoryFree  *pMemFree ;

   public:
      SwapSlack ( USHORT id, char *pName, char *pCurrentLabel, char *pDefaultLabel, 
         Dde_Server *pDdeServer, char *Topic, COUNTRYINFO &countryinfo, 
         USHORT sk, USHORT stk, USHORT sm, VirtualFree *pvf, SwapFree *psf, MemoryFree *pmf ) ;

      void SetShowK     ( USHORT flag ) { ShowK = flag ;  Value = 0 ; }
      void SetShowTrueK ( USHORT flag ) { ShowTrueK = flag ;  Value = 0 ; }
      void SetShowM     ( USHORT flag ) { ShowM = flag ;  Value = 0 ; }

      int Measure ( HPS hPS, RECTL &Rectangle ) ;
      ULONG NewValue ( void ) ;
      void FormatText ( char *Label, char *Text, ULONG Value ) ;
      void Repaint ( HPS hPS, RECTL &Rectangle, BOOL Mandatory ) ;
} ;

class ProcessCount : public Item {

   private:
      PULONG DQPS_Buffer ;

   public:
      ProcessCount ( USHORT id, char *pName, char *pCurrentLabel, char *pDefaultLabel,
         Dde_Server *pDdeServer, char *Topic ) ;
      ~ProcessCount ( ) ;

      int Measure ( HPS hPS, RECTL &Rectangle ) ;
      ULONG NewValue ( void ) ;
      void FormatText ( char *Label, char *Text, ULONG Value ) ;
      void Repaint ( HPS hPS, RECTL &Rectangle, BOOL Mandatory ) ;
} ;

extern PSZ ScanSystemConfig ( HAB Anchor, PSZ Keyword ) ;

class ThreadCount : public Item {

   private:
      PULONG DQPS_Buffer ;

   public:
      ThreadCount ( USHORT id, char *pName, char *pCurrentLabel, char *pDefaultLabel,
         Dde_Server *pDdeServer, char *Topic ) ;
      ~ThreadCount ( ) ;

      int Measure ( HPS hPS, RECTL &Rectangle ) ;
      ULONG NewValue ( void ) ;
      void FormatText ( char *Label, char *Text, ULONG Value ) ;
      void Repaint ( HPS hPS, RECTL &Rectangle, BOOL Mandatory ) ;
} ;

class Battery : public Item {

   private:
      HFILE Handle ;
      ResourceString *Error ;
      ResourceString *Charging ;
      ResourceString *AC ;

   public:
      Battery ( USHORT id, char *pName, char *pCurrentLabel, char *pDefaultLabel,
         Dde_Server *pDdeServer, char *Topic, ResourceString *error, 
         ResourceString *charging, ResourceString *ac ) ;
      ~Battery ( ) ;

      int Measure ( HPS hPS, RECTL &Rectangle ) ;
      ULONG NewValue ( void ) ;
      void FormatText ( char *Label, char *Text, ULONG Value ) ;
      void Repaint ( HPS hPS, RECTL &Rectangle, BOOL Mandatory ) ;

      int Discharging ( ) ;
} ;

#endif
