#include "less.h"

#if OS2
#define INCL_DOSPROCESS
#include <os2.h>
#include <process.h>
#endif

typedef struct 
{
	unsigned char magic[2];
	char *cmd;
	char *opt;
}  
CompressMethod;

static CompressMethod zTable[] = 
{
  0x1F, 0x9D, "compress", "-dc",	/* compress */
  0x1F, 0x9F, "freeze", "-dc",		/* freeze 2.x */
  0x1F, 0x9E, "gzip", "-dc",		/* freeze 1.x */
  0x1F, 0xA0, "gzip", "-dc",		/* sco compress */
  0x1F, 0x1E, "gzip", "-dc",		/* pack */
  0x1F, 0x8B, "gzip", "-dc",		/* gzip */
};
#define MethodCnt sizeof(zTable)/sizeof(CompressMethod)

int isZfile(name)
char *name;
{
  int method, res, file;
  unsigned char magic[2];

  file = open(name, O_RDONLY | O_BINARY);
  res = read(file, magic, 2);
  close(file);

  if (res != 2)
	return -1;

  for (method=0; method < MethodCnt; method++)
	if (zTable[method].magic[0] == magic[0] &&
	    zTable[method].magic[1] == magic[1])
		return method;

  return -1;
}

static int pid[64];

int Zopen(name, method)
char *name;
int method;
{
  int ph[2], file, old0, old1, old2, p;
  char *cmd, *opt;

  if (method < 0 || method >= MethodCnt)
    return -1;

  cmd = zTable[method].cmd;
  opt = zTable[method].opt;

#if OS2
  if ((file = open(name, O_RDONLY|O_BINARY)) == -1)
    return -1;

  old0 = dup(0);
  old1 = dup(1);
  old2 = dup(2);

  fcntl(old0, F_SETFD, FD_CLOEXEC);
  fcntl(old1, F_SETFD, FD_CLOEXEC);
  fcntl(old2, F_SETFD, FD_CLOEXEC);

  if (pipe(ph))
    return -1;

  setmode(ph[0], O_BINARY);
  setmode(ph[1], O_BINARY);

  fcntl(ph[0], F_SETFD, FD_CLOEXEC);

  dup2(file, 0);
  close(file);

  dup2(ph[1], 1);
  dup2(ph[1], 2);
  close(ph[1]);

  p = spawnlp(P_NOWAIT, cmd, cmd, opt, NULL);

  dup2(old0, 0);
  dup2(old1, 1);
  dup2(old2, 2);

  close(old0);
  close(old1);
  close(old2);

  if (p == -1)
    return close(ph[0]), -1;
#else
  if (pipe(ph))
    return -1;
  
  if ((p = fork()) == -1)
    return -1;

  if (p == 0)
  {
    if ((file = open(name, O_RDONLY)) == -1)
      exit(1);

    dup2(file, 0);
    dup2(ph[1], 1);
    dup2(ph[1], 2);
    close(ph[1]);
    close(ph[0]);
    close(file);

    if (execlp(cmd, cmd, opt, NULL) == -1)
      exit(1);
  }
  else
    close(ph[1]);
#endif

  pid[ph[0]] = p;

  return ph[0];
}

void Zclose(int handle)
{
#if OS2
  RESULTCODES rc;
  PID p;
  close(handle);
  DosKillProcess(DKP_PROCESSTREE, pid[handle]);
  DosWaitChild(0, 0, &rc, &p, pid[handle]);
#else
  close(handle);
  kill(pid[handle], SIGPIPE);
  waitpid(pid[handle], NULL, 0);
#endif
}
