#	Calculate when Easter will occur in any given year.
#	Copyright (c) 1991 by Hamilton Laboratories.  All rights reserved.

proc easter (year)
	local a, b, c, d, e, f, g, h, i, k, l, m, n, month, day
	set month = January February March April May June ^
		July August September October November December
	if (year == "") @ year = `date`:3
	if (year >= 1583) then
		# Gregorian calendar
		@ a = year % 19;  @ b = year // 100;  @ c = year % 100
		@ d = b // 4;  @ e = b % 4;  @ f = (b + 8) // 25
		@ g = (b - f + 1) // 3
		@ h = (19 * a + b - d - g + 15) % 30
		@ i = c // 4;  @ k = c % 4
		@ l = (32 + 2 * e + 2 * i - h - k) % 7
		@ m = (a + 11 * h + 22 * l) // 451
		@ n = h + l - 7 * m + 114
		@ month = month[n // 31 - 1]
		@ day = n % 31 + 1
	else
		# Julian calendar
		@ a = year % 4;  @ b = year % 7;  @ c = year % 19;  
		@ d = (19 * c + 15) % 30
		@ e = (2 * a + 4 * b - d + 34) % 7
		@ f = d + e + 114
		@ month = month[f // 31 - 1]
		@ day = f % 31 + 1
	end
	return "$month $day $year"
end

easter $argv
