#	Calculate the calendar date (month, day, year) corresponding to
#	a Julian day number.  (Negative years are B.C.)
#	Based on algorithms published in Computer Language magazine,
#	December, 1990.  Used with permission.

proc caldate(jdate)
	local a, b, c, d, e, z, alpha, month, day, year
	set month = January February March April May June ^
		July August September October November December
	@ z = jdate + 1
	# Cope with the Gregorian calendar reform.
	if (z < 2299161) then
		@ a = z
		# Intercept years B.C.
		if (z < 1721423) @ a -= 366
	else
		@ alpha = (z - 1867216.25)//36524.25
		@ a = z + 1 + alpha - alpha//4
	end
	@ b = a + 1524
	@ c = (b - 122.1)//365.25
	@ d = floor(365.25 * c)
	@ e = (b - d)//30.6001
	@ day = b - d - floor(30.6001 * e)
	@ e -= e < 14 ? 2 : 14
	@ month = month[e]
	if ((year = e > 1 ? c - 4716 : c - 4715) == 0) @ year--
	return "$month $day $year"
end

caldate $argv
