#	First-pass fixup of expressions.

#		1. Convert test statements:

#				test					-->		@ status = 1
#				test x				-->      @ status = [ x ] == ""
#				test ...				-->		@ status = [ ... ] != 0
#				... test				-->		1
#				... test a			-->		... [ a != "" ]
#				... test ...		-->		... [ ... ]

#		2. Fixup expression operators and syntax:

#				string				-->		"string"
#				-n foo				-->		foo != ""
#				-z foo				-->		foo == ""
#				a = b					-->		a == b
#				a -eq b				-->		a == b
#				a -gt b				-->		a > b
#				a -ge b				-->		a >= b
#				a -lt b				-->		a < b
#				a -le b				-->		a <= b
#				a -ne b				-->		a != b
#				a -o b				-->		a || b
#				a -a b				-->		a && b

#				[ ... ]				-->		( ... )

#		3.	Do `expr ...` evaluation in the C shell:

#				i=`expr ${i} + 1`	-->		@ i=i + 1

#		4. PATH=a:b:c				-->		PATH="a;b;c"

#		5. Assignments become set statements.


/^[ 	]*test/{
	s/^\([ 	]*\)test[ 	]*$/\1@ status = 1/
	s/^\([ 	]*\)test[ 	][ 	]*\([^ 	][^ 	]*\)$/\1@ status = [ \2 ] == ""/
	s/^\([ 	]*\)test[ 	][ 	]*\([^ 	].*\)$/\1@ status = [ \2 ] != 0/
	}

/^[^#]*[ 	]test/{
	s/\([ 	]\)test[ 	]*$/\11/
	s/\([ 	]\)test[ 	][ 	]*\([^ 	][^ 	]*\)$/\1[ \2 != "" ]/
	s/\([ 	]\)test[ 	][ 	]*\([^ 	].*\)$/\1[ \2 ]/
	}

/^[^#]* \[[^[].*\]/{
	s/\(\[.*[ 	]\)\([a-zA-Z_][a-zA-Z_0-9]*\)/\1"\2"/g
	s/-n[ 	]*\([^ ].*\) \]/\1 != "" ]/g
	s/-z[ 	]*\([^ ].*\) \]/\1 == "" ]/g
	s/[ 	]*=[ 	]*/ == /g
	s/[ 	]*-eq[ 	]*/ == /g
	s/[ 	]*-gt[ 	]*/ > /g
	s/[ 	]*-ge[ 	]*/ >= /g
	s/[ 	]*-lt[ 	]*/ < /g
	s/[ 	]*-le[ 	]*/ <= /g
	s/[ 	]*-ne[ 	]*/ != /g
	s/[ 	]*-o[ 	]*/ || /g
	s/[ 	]*-a[ 	]*/ \&\& /g
	s/\[/(/
	s/]/)/
	}

/^[^#]*=`expr.*`/{
	s/`//g
	s/expr //
	/: "\.\*"/s/\([^ 	=][^ 	]*\)[ 	]*: "\.\*"/strlen(\1)/
	/^[ 	]*[a-zA-Z][a-zA-Z0-9_]*[ 	]*=/s/[a-zA-Z]/@ &/
	}

/^[ 	]*PATH=[^"]/{
	s/:/;/g
	s/=\(.*\)/="\1"/
	}
/^[ 	]*[a-zA-Z][a-zA-Z0-9_]*[ 	]*=/s/[a-zA-Z]/set &/
