/*
 * show a directory including .SUBJECT EAs
 * SDIR /? for help.
 */

'@echo off'
parse arg mask recurse
mask = strip(mask)
if mask = '/?' then
do
  say 'SDIR is a DIR-like command that shows .SUBJECT EAs in its display.'
  say ''
  say 'Usage: SDIR mask /s'
  say ''
  say ' Both mask and /s are optional.  mask filters the files/directories shown'
  say ' and may contain wildcard characters ? and *.  /s is a switch meaning to'
  say ' recurse into subdirectories, and cannot be used if mask contains spaces'
  say ' (in which case mask should be surrounded with quotes).  If you use /s,'
  say ' you must also give mask.  Order of parameters is enforced.'
  say ''
  say 'Examples:  SDIR *.exe'
  say '           SDIR d:\*.zip /s'
  say '           SDIR 'd2c(34)'long filename number *'d2c(34)
  exit
end
if left(mask,1) = d2c(34) then
do
  recurse = ''
  parse arg mask
  mask = substr(mask,2)
  if right(mask,1) = d2c(34) then
    mask = left(mask,length(mask) - 1)
end
if mask = '' then
  mask = '*'
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
recurse = translate(recurse)
if recurse = '/S' then
  rc = SysFileTree(mask,filename,'S')
else
do
  recurse = ''
  rc = SysFileTree(mask,filename)
end
if rc = 0 then
do
  do i=1 to filename.0
    parse var filename.i fdate ftime fsize fattr fname
    filename.i = left(filename.i,length(filename.i) - length(fname))
    fname = strip(fname)
    if recurse = '' then
    do
      lpos = lastpos('\',fname)
      if lpos \= 0 then
        rname = substr(fname,lpos + 1)
      else
        rname = fname
    end
    else
      rname = fname
    say filename.i'  'rname
    if SysGetEA(fname,'.SUBJECT','text') = 0 then
    do
      text = substr(text,5)
      text = strip(text)
      if text \= '' then
        say '  +'text
    end
  end
end
else
  say 'Out of memory.'
exit
