/*
	commandline configuration editor.
	Released into Public domain 12/10/96 by Eddy Kim.

	If you make this nicer, please send a copy to moi.
	ehkim@ibm.net
*/

#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>
#include <list.h>   // stl list header
#include <string.h> // c-style string processing
#include <string.hpp>  // watcom string class
#include <assert.h>
typedef String string;  // makes Watcom strings look more standard

const db=0;
#define DB(X) if (db) cout<<#X<<"("<<X<<")"<<endl
typedef list<string> stringlist;

char* COMMAND[]= { "add", "del", "get", 0 };
char* TYPES[]= { "path", "libpath", "dpath", "var", "device", "run", 0 };
enum eTYPE { PATH, LIBPATH, DPATH, VAR, DEVICE, RUN };
const MAXBUF=2048;
string filename,command,type,args;
stringlist sl;

int loadfile();
int writefile();
int add(char* szType,int typeindex);
int del(char* szType,int typeindex);
int get(char* szType,int typeindex);
main(int argc, char* argv[])
{
    if (argc<=4)
    {
       cerr<<"Usage: "<<argv[0]<<" filename command args"<<endl;
       cerr<<"Where command is [add del get]"<<endl;
       cerr<<"args= path libpath dpath var device run"<<endl;
       cerr<<"ex:  coned config.tmp add path h:\\usr\\bin"<<endl;
       cerr<<"     coned config.tmp add libpath h:\\usr\\dll"<<endl;
       cerr<<"     coned config.tmp add dpath h:\\usr\\som\\msg"<<endl;
       cerr<<"     coned config.tmp add var tmp=h:\\tmp"<<endl;
       cerr<<"     coned config.tmp add run h:\\usr\\bin\\telnetd.exe"<<endl;
       return 1;
    }
    filename=argv[1];
    command=argv[2];
    type=argv[3];
    args=argv[4];
DB(command);
DB(type);
DB(args);
    for (int argi=5; argi<argc; argi++)
    {
       args+=string(" ")+argv[argi];
    }
    loadfile();
    // parse command
    int rv=0;
    int good=0,i=0;
    for (char** cp=COMMAND; *cp!=0; cp++,i++)
    {
         if (stricmp(*cp,command)==0)
         {
             good=1;
             break;
         }
    }
    if (!good) { cerr<<"ERROR: unknown command "<<command<<endl; return 1;}
    int cmdindex=i;
    good=0;
    for (cp=TYPES, i=0; *cp!=0; cp++,i++)
    {
         if (stricmp(*cp,type)==0)
         {
             good=1;
             break;
         }
    }
    if (!good) { cerr<<"ERROR: unknown type "<<type<<endl; return 1;}
    int typeindex=i;
    switch (cmdindex)
    {
       case 0:
         rv=add(argv[3],typeindex);
         break;
       case 1:
         rv=del(argv[3],typeindex);
         break;
       case 2:
         rv=get(argv[3],typeindex);
         break;
    }
    if (rv!=0) return rv;
    writefile();
    return rv;
}
stringlist::iterator findvar(const char* var)
{
  // a variable in this context means that the token to search for is
  // either the first or second token on the line. case insensitive.
  // ignores rem'ed out lines
  char tmpbuf[MAXBUF],*cp;
  for (stringlist::iterator a=sl.begin(); a!=sl.end(); a++)
  {
    string tmp = (*a);
    if (tmp.length()==0) continue;
    strcpy(tmpbuf,tmp);
    cp=strtok(tmpbuf," \t=");
    if (stricmp(cp,"set")==0)
    {
      cp=strtok(NULL," \t=");
    } else if (stricmp(cp,"rem")==0) {
      continue;
    }
    if ((stricmp(cp,var)==0) && (strlen(cp) == strlen(var)))
    {
      // found it
      return a;
    }
  }
  return sl.end();
}
int add(char* szType,int typeindex)
{
  DB("add");
  DB(typeindex);
  char buf[MAXBUF],*cp=0;
  int found=0;
  string var;
  stringlist::iterator sli=findvar(szType);
  switch (typeindex)
  {
  case DPATH:  // these two variables a preceded by a "set" and are handled
  case PATH:   // component by component
  {
    if (sli == sl.end())
    {
      cerr<<"Error: can't find variable "<< szType <<endl;
      return 1;
    }
    // see if the variable exists already, if so nop , else append
    strcpy(buf,(*sli));
    cp=strtok(buf," =\t;");
    assert(stricmp(cp,"set")==0);
    var+=cp+ string(" ");
    cp=strtok(NULL," =\t;");
    assert(stricmp(cp,szType)==0);
    var+=cp+ string("=");
    while ((cp=strtok(NULL,";"))!=0)
    {
      if (stricmp(cp,args)==0)
      { // prexisting path component
        // do nothing in this case
        found = 1;
      }
      var+=cp + string(";");
    }
    if (!found)
    {
      var += args + string(";");
    }
    // overwrite the line with new line
    (*sli)=var;
    break;
  }
  case LIBPATH: // similar to path and dpath, but not preceded by a set
  {
    if (sli == sl.end())
    {
      cerr<<"Error: can't find variable "<< szType <<endl;
      return 1;
    }
    // see if the variable exists already, if so nop , else append
    strcpy(buf,(*sli));
    cp=strtok(buf," =\t;");
    assert(stricmp(cp,szType)==0);
    var+=cp+ string("=");
    while ((cp=strtok(NULL,";"))!=0)
    {
      if (stricmp(cp,args)==0)
      { // prexisting path component
        // do nothing in this case
        found = 1;
      }
      var+=cp + string(";");
    }
    if (!found)
    {
      var += args + string(";");
    }
    // overwrite the line with new line
    (*sli)=var;
    break;
  }
  case DEVICE:
  case RUN:
  {
    var=type+"=";
    var+=args;
    stringlist::iterator sli2=sl.end();
    for (sli=sl.begin(); sli != sl.end() ; sli++)
    {
      if (stricmp(var,(*sli))==0)
      {
        sli2=sli;
      }
    }
    if (sli2 == sl.end())
    {
      sl.push_back(var);
    } else {
      (*sli2)=var;
    }
    break;
  }
  case VAR:
  {
    strcpy(buf,args);
    cp=strtok(buf,"=");
    if (cp==NULL)
    {
      DB("error tokenize variable"<<type<<" "<<args);
      return 1;
    }
    sli=findvar(cp);
    strcpy(buf,(*sli));
    cp=strtok(buf," \t=");
    if (stricmp(cp,"set")==0)
    {
        var="SET ";
    } else {
        var="";
    }
    var+=args;
    if (sli == sl.end())
    {
      sl.push_back(var);
      break;
    } else {
      (*sli) = var;
    }
    break;
  } // case
  } // switch
  return 0;
}
int del(char* szType,int typeindex)
{
  DB("del");
  DB(typeindex);
  char buf[MAXBUF],*cp=0;
  int found=0;
  string var;
  stringlist::iterator sli=findvar(szType);
  switch (typeindex)
  {
  case DPATH:  // these two variables a preceded by a "set" and are handled
  case PATH:   // component by component
  {
    if (sli == sl.end())
    {
      cerr<<"Error: can't find variable "<< szType <<endl;
      return 1;
    }
    // see if the variable exists already, if so nop , else append
    strcpy(buf,(*sli));
    cp=strtok(buf," =\t;");
    assert(stricmp(cp,"set")==0);
    var+=cp+ string(" ");
    cp=strtok(NULL," =\t;");
    assert(stricmp(cp,szType)==0);
    var+=cp+ string("=");
    while ((cp=strtok(NULL,";"))!=0)
    {
      if (stricmp(cp,args)==0)
      { // found it, 
        found = 1;
      } else {
        var+=cp + string(";");
      }
    }
    // overwrite the line with new line
    (*sli)=var;
    break;
  }
  case LIBPATH: // similar to path and dpath, but not preceded by a set
  {
    if (sli == sl.end())
    {
      cerr<<"Error: can't find variable "<< szType <<endl;
      return 1;
    }
    // see if the variable exists already, if so nop , else append
    strcpy(buf,(*sli));
    cp=strtok(buf," =\t;");
    assert(stricmp(cp,szType)==0);
    var+=cp+ string("=");
    while ((cp=strtok(NULL,";"))!=0)
    {
      if (stricmp(cp,args)==0)
      {
      } else {
        var+=cp + string(";");
      }
    }
    // overwrite the line with new line
    (*sli)=var;
    break;
  }
  case DEVICE:
  case RUN:
  {
    var=type+"=";
    var+=args;
    stringlist::iterator sli2=sl.end();
    for (sli=sl.begin(); sli != sl.end() ; sli++)
    {
      if (stricmp(var,(*sli))==0)
      {
        sli2=sli;
      }
    }
    if (sli2 != sl.end())
    {
      (*sli2)="";
    }
    break;
  }
  case VAR:
  {
    strcpy(buf,args);
    cp=strtok(buf,"=");
    if (cp==NULL)
    {
      DB("error tokenize variable"<<type<<" "<<args);
      return 1;
    }
    sli=findvar(cp);
    if (sli == sl.end())
    {
      break;
    } else {
      (*sli) = "";
    }
    break;
  } // case
  } // switch
  return 0;
}
int get(char* szType,int typeindex)
{
  DB("get");
  DB(typeindex);
  char buf[MAXBUF],*cp=0;
  int found=0;
  string var;
  stringlist::iterator sli=findvar(szType);
  switch (typeindex)
  {
  case DPATH:  // these two variables a preceded by a "set" and are handled
  case PATH:   // component by component
  {
    if (sli == sl.end())
    {
      cerr<<"Error: can't find variable "<< szType <<endl;
      return 1;
    }
    // see if the variable exists already, if so nop , else append
    strcpy(buf,(*sli));
    cp=strtok(buf," =\t;");
    assert(stricmp(cp,"set")==0);
    var+=cp+ string(" ");
    cp=strtok(NULL," =\t;");
    assert(stricmp(cp,szType)==0);
    var+=cp+ string("=");
    while ((cp=strtok(NULL,";"))!=0)
    {
      if (stricmp(cp,args)==0)
      { // prexisting path component
        // do nothing in this case
        cout<<cp<<endl;
        found=1;
      }
    }
    if (!found)
    {
      cout<<"not found"<<endl;
    }
    break;
  }
  case LIBPATH: // similar to path and dpath, but not preceded by a set
  {
    if (sli == sl.end())
    {
      cerr<<"Error: can't find variable "<< szType <<endl;
      return 1;
    }
    // see if the variable exists already, if so nop , else append
    strcpy(buf,(*sli));
    cp=strtok(buf," =\t;");
    assert(stricmp(cp,szType)==0);
    var+=cp+ string("=");
    while ((cp=strtok(NULL,";"))!=0)
    {
      if (stricmp(cp,args)==0)
      {
        cout<<cp<<endl;
        found=1;
      }
    }
    if (!found)
    {
      cout<<"not found"<<endl;
    }
    break;
  }
  case DEVICE:
  case RUN:
  {
    var=type+"=";
    var+=args;
    stringlist::iterator sli2=sl.end();
    for (sli=sl.begin(); sli != sl.end() ; sli++)
    {
      if (stricmp(var,(*sli))==0)
      {
        sli2=sli;
      }
    }
    if (sli2 == sl.end())
    {
      cout<<"not found"<<endl;
    } else {
      cout<<(*sli2)<<endl;
    }
    break;
  }
  case VAR:
  {
    strcpy(buf,args);
    cp=strtok(buf,"=");
    if (cp==NULL)
    {
      DB("error tokenize variable"<<type<<" "<<args);
      return 1;
    }
    sli=findvar(cp);
    if (sli == sl.end())
    {
      cout<<"not found"<endl;
      break;
    } else {
      cout<< (*sli)<<endl;
    }
    break;
  } // case
  } // switch
  return 0;
}
loadfile()
{
  // load file into mem.
  ifstream file(filename);
  if (!file)
  {
    cerr<<"Error opening file "<<filename<<" for reading"<<endl;
    exit(1);
  }
  while (file)
  {
    char buffer[MAXBUF];
    file.getline(buffer,MAXBUF);
    if (!file) break;
    sl.push_back(buffer);
  }
  return 0;
}
writefile()
{
  ofstream file(filename);
  if (!file)
  {
    cerr<<"Error opening file "<<filename<<" for writing"<<endl;
    exit(1);
  }
  for (stringlist::iterator a=sl.begin(); a!=sl.end(); a++)
  {
     file<< (*a) << endl;
  }
  return 0;
}
