/**************************************************/
/*                                                */
/* ENCRYPT.H - Public interface to ENCRYPT.DLL    */
/*                                                */
/* Author: Matthew Spencer (msspenc@ibm.net)      */
/*                                                */
/* Version: 1.61                                  */
/*                                                */
/* Date:    22nd July, 1997                       */
/*                                                */
/**************************************************/
#ifndef ENCRYPT_H
#define ENCRYPT_H

/*
** Prototypes.  There are 2 sets of functions.  Use the ones which
** your compiler supports.  IBM C-Set and VisualAge C++ use _Optlink
** as the default linkage, while Borland C++ only supports _System.
*/
void _Optlink SetVersion  (long version);          /* use version = 161, for compatibility */
void _Optlink Initialise  (unsigned char * key,    short length);          /* length <= 56 */
void _Optlink EncryptBlock(unsigned char * buffer, unsigned long length);  /* length >= 8  */
void _Optlink DecryptBlock(unsigned char * buffer, unsigned long length);  /* length >= 8  */

void _System BfSetVersion  (long version);          /* use version = 161, for compatibility */
void _System BfInitialise  (unsigned char * key,    short length);          /* length <= 56 */
void _System BfEncryptBlock(unsigned char * buffer, unsigned long length);  /* length >= 8  */
void _System BfDecryptBlock(unsigned char * buffer, unsigned long length);  /* length >= 8  */

/*
** Possible return codes
*/
#ifndef NO_ERROR
  #define NO_ERROR                                   0
#endif
#define BYTE_COUNT_DIFFERS_FROM_EXPECTED_LENGTH      1
#define ERROR_DELETING_SOURCE_FILE                   3
#define ERROR_OPENING_SOURCE_FILE                    7
#define ERROR_OPENING_TARGET_FILE                    8
#define ERROR_READING_SOURCE_FILE                    9
#define INCORRECT_KEY                               11
#define INCORRECT_SIGNATURE_IN_SOURCE_FILE          12
#define OPERATION_ABORTED                           13
#define INSUFFICIENT_SPACE_ON_TARGET_DRIVE          16
#define KEY_HAS_ZERO_LENGTH                         18
#define NO_FILES_MATCH_FILESPEC                     19
#define FILE_HAS_ZERO_LENGTH                        20
#define SINGLE_TARGET_MULTI_SOURCE                  21
#define FILENAME_PROCESSING_ERROR                   22
#define ERROR_DURING_TEMPORARY_FILE_RENAME          23
#define TARGET_NAME_MATCHES_PREVIOUS_TARGET         24
#define KEYS_DO_NOT_MATCH                           25
#define SKIPPED_ALREADY_ENCRYPTED                   26
#define SKIPPED_ALREADY_DECRYPTED                   27
#define WILDCARDS_NOT_ALLOWED_IN_TARGET             28

#define SYNTAX_ERROR                                98
#define UNKNOWN_ERROR                               99

#endif
