//
// bedisext.h - Interface needed by implementors of BE disassemblers
//
// bedis_init will be called before any other function.
// If initialisation fails, FALSE is returned and err says why.
//
// bedis_term is called after all the other functions.
// bedis_term can be omitted, if there is no module termination.
//
// bedis_disassemble is fed an address, and generates a text version.
// How many bytes were needed is returned also.
// It uses read (set up earlier) to fetch data.
// It uses symbolic (set up earlier) to get symbolic addresses.
// If couldn't fetch data for disassembly, returns FALSE.
// BE displays addresses of instructions, and opcodes, but bedis_dissasemble
// displays addresses in operands.
//
// bedis_code returns TRUE if the instruction at a given address contains
// a branch, branch and link, jump, call etc. to an address, and returns
// that address, if it is known.
// If it is a computed branch (eg: via a register), then FALSE is returned.
// BE can bring up a disassembly listing for numbers annotated 'code', and
// values returned from this function.
// A simple disassembler not supporting this feature could omit this function.
//
// bedis_data returns TRUE if instruction references a data item.
// The '*' keypress can be used to jump to data.
// A simple disassembler not supporting this feature could omit this function.
//
// bedis_options is a way to request disassembly to be done in a given way,
// based on a user typed option string.
// This function is optional.
//

#ifndef BEDISEXT_H
#define	BEDISEXT_H

#ifndef Boolean_DEFINED
#define	Boolean_DEFINED
typedef int Boolean;
#define	TRUE  1
#define FALSE 0
#endif

#if   defined(OS2)
#define	BEDISEXPORT
#define	BEDISENTRY _System
#elif defined(WIN32)
#define	BEDISEXPORT __declspec(dllexport)
#define	BEDISENTRY __stdcall
#else
#define	BEDISEXPORT
#define	BEDISENTRY
#endif

#ifdef AIX
typedef void (*BEDIS_EP)(void);
typedef struct { BEDIS_EP ep; const char *name; } BEDIS_EXPORT;
#endif

extern "C" {

BEDISEXPORT Boolean BEDISENTRY bedis_init(
	Boolean (*read)(unsigned addr, unsigned char & b),
	Boolean (*symbolic)(unsigned addr, char *id, unsigned & offset),
	const char *(&err)
	);

BEDISEXPORT void BEDISENTRY bedis_term(void);

BEDISEXPORT Boolean BEDISENTRY bedis_disassemble(
	unsigned addr,
	unsigned & bytes,
	char *display
	);

BEDISEXPORT Boolean BEDISENTRY bedis_ref_code(
	unsigned addr,
	unsigned & ref_addr
	);

BEDISEXPORT Boolean BEDISENTRY bedis_ref_data(
	unsigned addr,
	unsigned & ref_addr
	);

BEDISEXPORT Boolean BEDISENTRY bedis_options(
	const char *options,
	const char *(&err)
	);

}

#endif
