VERSION 2.00
Begin Form frmFinger 
   BackColor       =   &H00C0C0C0&
   Caption         =   "Finger"
   ClientHeight    =   4080
   ClientLeft      =   1200
   ClientTop       =   1500
   ClientWidth     =   5760
   Height          =   4485
   Icon            =   FINGER.FRX:0000
   Left            =   1140
   LinkTopic       =   "Form1"
   ScaleHeight     =   4080
   ScaleWidth      =   5760
   Top             =   1155
   Width           =   5880
   Begin CommandButton cmdFinger 
      Caption         =   "&Finger"
      Default         =   -1  'True
      Height          =   375
      Left            =   4440
      TabIndex        =   5
      Top             =   240
      Width           =   1215
   End
   Begin TextBox tResponse 
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "Terminal"
      FontSize        =   9
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   3135
      Left            =   120
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   3
      Top             =   840
      Width           =   5535
   End
   Begin TextBox tHostAddress 
      Height          =   285
      Left            =   1440
      TabIndex        =   2
      Top             =   480
      Width           =   2895
   End
   Begin TextBox tHostName 
      Height          =   285
      Left            =   1440
      TabIndex        =   1
      Top             =   120
      Width           =   2895
   End
   Begin IPPORT IPPort1 
      EOL             =   ""
      InBufferSize    =   2048
      Left            =   480
      Linger          =   -1  'True
      LocalPort       =   0
      OutBufferSize   =   2048
      Port            =   0
      Top             =   0
   End
   Begin Label Label1 
      BackStyle       =   0  'Transparent
      Caption         =   "Host Address:"
      Height          =   255
      Index           =   1
      Left            =   120
      TabIndex        =   4
      Top             =   480
      Width           =   2175
   End
   Begin Label Label1 
      BackStyle       =   0  'Transparent
      Caption         =   "Host Name:"
      Height          =   255
      Index           =   0
      Left            =   120
      TabIndex        =   0
      Top             =   150
      Width           =   1815
   End
End

'Finger Demo -
'Improvements courtesy of Kenn Nesbitt
'(kenn@nesbitt.demon.co.uk)

Option Explicit

Const DEFAULT = 0
Const HOURGLASS = 11

Sub cmdFinger_Click ()
    Dim HostName As String, UserID As String

    On Error GoTo cmdFingerClickErr:

    ' Set the End-of-Line character
    IPPort1.EOL = Chr$(10)

    ' Display "wait" cursor
    Me.MousePointer = HOURGLASS

    'Close old connection - if any
    IPPort1.Connected = False

    If tHostName.Text <> "" Then
        If InStr(tHostName, "@") = 0 Then
            HostName = tHostName.Text
            UserID = ""
        Else
            HostName = Mid$(tHostName.Text, InStr(tHostName, "@") + 1)
            UserID = Left$(tHostName.Text, InStr(tHostName, "@") - 1)
        End If

        tResponse.Text = HostName
        IPPort1.HostName = HostName
        tHostAddress.Text = IPPort1.HostAddress

    ElseIf tHostAddress.Text <> "" Then
        tResponse.Text = "Resolving " & tHostAddress.Text & "..."
        IPPort1.HostAddress = tHostAddress.Text
        HostName = IPPort1.HostName
        UserID = ""
        tHostName.Text = HostName
    Else
        MsgBox "Please specify a host."
        Exit Sub
    End If

    ' By convention, finger is on port 79
    IPPort1.Port = 79

    ' Ask for connection
    IPPort1.Connected = True

    ' Wait until connection is achieved
    tResponse.Text = "Connecting to " & HostName & "..."
    Do Until IPPort1.Connected: DoEvents: Loop

    ' Send the ID we wish to finger
    IPPort1.DataToSend = UserID & Chr$(10)
    
cmdFingerClickExit:
    On Error GoTo 0
    Exit Sub

cmdFingerClickErr:
    Me.MousePointer = DEFAULT
    MsgBox "Error " & Err & ": " & Error
    IPPort1.Connected = False
    GoTo cmdFingerClickExit

End Sub

Sub Form_Resize ()
    Dim Margin As Integer

    Margin = tResponse.Left
    
    tResponse.Height = ScaleHeight - tResponse.Top - Margin
    tResponse.Width = ScaleWidth - 2 * Margin
    
    cmdFinger.Left = ScaleWidth - cmdFinger.Width - Margin
    
    tHostName.Width = ScaleWidth - tHostName.Left - cmdFinger.Width - 2 * Margin
    tHostAddress.Width = ScaleWidth - tHostAddress.Left - cmdFinger.Width - 2 * Margin

End Sub

Sub IPPort1_Connected (StatusCode As Integer, Description As String)

tResponse = ""

If Description <> "OK" Then
    MsgBox "Connection error: " & Description
    Me.MousePointer = 0
End If

End Sub

Sub IPPort1_DataIn (Text As String, EOL As Integer)

    If EOL Then Text = Text & Chr$(13) & Chr$(10)
    
    tResponse.SelStart = Len(tResponse.Text)
    tResponse.SelText = Text

End Sub

Sub IPPort1_Disconnected (StatusCode As Integer, Description As String)

Me.MousePointer = 0

If Description <> "OK" Then
    MsgBox "Connection broken: " & Description
End If

tResponse.SelStart = Len(tResponse.Text)
tResponse.SelText = Chr$(13) & Chr$(10) & " *** Doubleclick on a login ID for more info.***" & Chr$(13) & Chr$(10)

End Sub

Sub tResponse_DblClick ()

    tHostName.Text = tResponse.SelText & "@" & IPPort1.HostName

End Sub

