unit Graph;


!!!! I wanted you to see this. put a bracket at the beginning of this line
     to compile!

this demo program is starting to get real messy - there's too many
features to show in one program. But I'm too lazy to do better.
While you're looking at this, checkout the event method on the add button:
there several variants for the kind of data to add}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Spin, StdCtrls, XyGraph, xyData, ExtCtrls, Buttons, statform,
  Xyhist;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    Button1: TButton;
    Button2: TButton;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    exmin: TEdit;
    exmax: TEdit;
    eymin: TEdit;
    eymax: TEdit;
    CheckBox3: TCheckBox;
    ComboBox1: TComboBox;
    Label1: TLabel;
    Button3: TButton;
    SpinEdit1: TSpinEdit;
    Label6: TLabel;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    ComboBox2: TComboBox;
    Label7: TLabel;
    Label8: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Panel3: TPanel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Button4: TButton;
    sd: TSaveDialog;
    Button5: TButton;
    CheckBox7: TCheckBox;
    Edit9: TEdit;
    Label15: TLabel;
    Button7: TButton;
    Button8: TButton;
    CheckBox8: TCheckBox;
    BitBtn1: TBitBtn;
    Panel4: TPanel;
    xygraph1: TxyGraph;
    Histogram1: THistogram;
    Histogram2: THistogram;
    xyGraph2: TxyGraph;
    procedure FormCreate(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
    procedure CheckBox5Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure xygraph1ReScale(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure CheckBox6Click(Sender: TObject);
    procedure exminChange(Sender: TObject);
    procedure exmaxChange(Sender: TObject);
    procedure eyminChange(Sender: TObject);
    procedure eymaxChange(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
    procedure xygraph1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure xygraph1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure xygraph1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure xygraph1PaintEnd(Sender: TObject; Canvas:TCanvas);
    procedure CheckBox7Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure CheckBox8Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
  private
    { Private declarations }
    mousedrag:boolean;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

(* txyGraph demo *)

(* 1.  Adding a data series *)

procedure TForm1.FormCreate(Sender: TObject);
begin
  combobox1.itemindex := 0;
  combobox2.itemindex := 0;
  mousedrag := false;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  xygraph1.AllowDuplicates := checkbox1.checked;
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
  xygraph1.appearance.PlotOffGraph := not Checkbox2.checked;
end;

procedure TForm1.CheckBox4Click(Sender: TObject);
begin
  xygraph1.gridlines := checkbox4.checked;
end;

procedure TForm1.CheckBox5Click(Sender: TObject);
begin
  xygraph1.yaxis.logscale := checkbox5.checked;
end;

function gausrandom:double;
begin
 if random > 0.5 then
   result := exp(random) - 1
 else
   result := 0 - exp(random) + 1;
end;

procedure TForm1.Button1Click(Sender: TObject);
var d1,m,c,t,j:double;
    d2,i:longint;
    c1:Tcolor;
    style:TPenStyle;
begin
 xygraph1.plotting := false; {prevent paints until finished}
 xygraph1[1].clear;   {possible scoping problem if in the with statement and
                      backwards compatibility turned on}
 with xygraph1[1] do
  begin
  AutoZero := false;
  WhichYAxis := xygraph1.YAxis_second;
  InternalZero := 0;
  DrawPoints := true;
  PointSize := spinedit1.value; {override some of the defaults}
  PointShape := ps_circle;
  PointColor := clblue;
  DrawLine := true;
  LineStyle := psdashdot;
  case combobox1.itemindex of
     0:DrawLine := false;
     1:LineColor := clred;
     2:LineColor := clblue;
     3:LineColor := clgreen;
     4:LineColor := clblack;
  end;
  xygraph1.plotting := true;
  xygraph1[1].holdupdates := true;  {can leave this out to speed things up}
  for i := 1 to 20 {pick a number ...} do
    begin
    t := random;
    j := random;
    { use one of these }
    {add(gausrandom, gausrandom);}
     add(1+i/5, 1 + (i/20 + (0.5-random)*0.8));     
   { xygraph1[1][t] := (t + (0.5-random)*0.2);}
    { add(i,i*4); }
{     add(i,i*i/10 + 2*i + t*50);}
    end;
  xygraph1[1].holdupdates := false;
  RegressionLineColor := clgray;
  RegressionLineStyle := psdot;
  case combobox2.itemindex of
    0:regtype := rg_none;
    1:regtype := rg_linear;
    2:regtype := rg_passingBablok;
    3:begin
      regcontrol2 := 0.9;
      regtype := rg_runningaverage;
      end;
    4:begin
      regcontrol1 := 300;    {calculate at 300 points}
      regtype := rg_spline;
      end;
    5:begin
      regcontrol1 := 200;    {calculate at 200 points}
      regcontrol2 := 0.0005; {smoothing value}
      regtype := rg_DWLS;
      end;
    6:regtype := rg_quadratic;
  end;
  if (combobox2.itemindex = 0) or (combobox2.itemindex > 2) then
  begin
    edit1.text := '';
    edit2.text := '';
  end
  else
  begin
    edit1.text := floattostr(Compstats.RegSlope);
    edit2.text := floattostr(Compstats.regintercept);
  end;
  end;
 histogram1.buckets := 15;
 histogram1.hookdataseries(xygraph1[1],false);
 histogram2.buckets := 15;
 histogram2.hookdataseries(xygraph1[1],true);
 xygraph2[1].DrawLine := false;
 xygraph2[1].PointShape := ps_Circle;
 xygraph2.hookseries(xygraph1[1], ht_plotresiduals, 1, false); 
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
 xygraph1[1].deletepoint(2);
 (* delete any points with x value = 2 from series 1 *)
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
 xygraph1[1].clear;
{ xygraph1.clearall;}
 edit1.text := '';
 edit2.text := '';
end;

procedure TForm1.SpinEdit1Change(Sender: TObject);
begin
 if xygraph1.findseries(1) then (* check that series has been defined *)
  xygraph1[1].PointSize := Spinedit1.value;
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
 if xygraph1.findseries(1) then (* check that series has been defined *)
 begin
  xygraph1[1].DrawLine := true;
  case combobox1.itemindex of
     0:xygraph1[1].DrawLine := false;
     1:xygraph1[1].LineColor := clred;
     2:xygraph1[1].LineColor := clblue;
     3:xygraph1[1].LineColor := clgreen;
     4:xygraph1[1].LineColor := clblack;
  end;
 end;
end;

procedure TForm1.xygraph1ReScale(Sender: TObject);
begin
 with xygraph1 do
  begin
  exmin.text := floattostr(xaxis.min);
  exmax.text := floattostr(xaxis.max);
  eymin.text := floattostr(yaxis.min);
  eymax.text := floattostr(yaxis.max);
  checkbox3.checked := xaxis.autosizing;
  checkbox6.checked := yaxis.autosizing;
  end
end;

procedure TForm1.CheckBox3Click(Sender: TObject);
begin
  xygraph1.xaxis.autosizing := checkbox3.checked;
end;

procedure TForm1.CheckBox6Click(Sender: TObject);
begin
  xygraph1.yaxis.autosizing := checkbox6.checked;
end;

procedure TForm1.exminChange(Sender: TObject);
begin
  if not xygraph1.xaxis.autosizing then (* have to check this or loops to override *)
  xygraph1.xaxis.min := strtofloat(exmin.text);
end;

procedure TForm1.exmaxChange(Sender: TObject);
begin
  if not xygraph1.xaxis.autosizing then (* have to check this or loops to override *)
  xygraph1.xaxis.max := strtofloat(exmax.text);
end;

procedure TForm1.eyminChange(Sender: TObject);
begin
  if not xygraph1.yaxis.autosizing then (* have to check this or loops to override *)
  xygraph1.yaxis.min := strtofloat(eymin.text);
end;

procedure TForm1.eymaxChange(Sender: TObject);
begin
  if not xygraph1.yaxis.autosizing then (* have to check this or loops to override *)
  xygraph1.yaxis.max := strtofloat(eymax.text);
end;

procedure TForm1.ComboBox2Change(Sender: TObject);
begin
 if xygraph1.findseries(1) then (* check that series has been defined *)
 begin
  with xygraph1[1] do
  begin
  RegressionLineColor := clgray;
  RegressionLineStyle := psdot;
  case combobox2.itemindex of
    0:regtype := rg_none;
    1:regtype := rg_linear;
    2:regtype := rg_passingBablok;
    3:begin
      regcontrol2 := 0.9;
      regtype := rg_runningaverage;
      end;
    4:begin
      regcontrol1 := 400;    {calculate at 400 points}
      regtype := rg_spline;
      end;
    5:begin
      regcontrol1 := 400;    {calculate at 400 points}
      regcontrol2 := 0.0005; {smoothing value}
      regtype := rg_DWLS;
      end;
    6:regtype := rg_quadratic;
  end;
   if (combobox2.itemindex = 0) or ((combobox2.itemindex > 2)
     and (combobox2.itemindex <> 6)) then
   begin
     edit1.text := '';
     edit2.text := '';
   end
   else
   begin
    edit1.text := floattostr(Compstats.RegSlope);
    edit2.text := floattostr(Compstats.regintercept);
    {FRegSlope2 is also available when quadratic fitting}
   end;
  end;
 end;
end;

(* mouse procedures *)
{ Use mouse to display the nearest point and other information at the bottom
 of the screen. shift left will cause dragging }
procedure TForm1.xygraph1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var xs,ys,xp,yp:double;
    t:integer;
    r:boolean;
begin
 mousedrag := true;
 r := xygraph1.getmousexy(1,x,y,t,xs,ys,xp,yp);
   {get (xs,ys) the values where the mouse is.
    get (xp,yp) the nearest point, where t is the index of the point.
    r is whether a point was found, which is the same thing as whether
      the mouse is inside the plotting area}
 label10.caption := (floattostrF(xs,ffgeneral,2,2) + ',' +floattostrF(ys,ffgeneral,2,2));
 if r then
 begin
   label12.caption := (floattostrF(xp,ffgeneral,2,2) + ',' +floattostrF(yp,ffgeneral,2,2));
   label14.caption := (inttostr(t));
 end
 else
 begin
   label12.caption := 'Outside';
   label14.caption := 'none';
 end;
 panel3.visible := true;
end;

procedure TForm1.xygraph1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var xs,ys,xp,yp:double;
    t:integer;
    r:boolean;
begin
 if mousedrag then
   begin
     r := xygraph1.getmousexy(1,x,y,t,xs,ys,xp,yp);
     label10.caption := (floattostrF(xs,ffgeneral,2,2) + ','
           +floattostrF(ys,ffgeneral,2,2));
     if r then
     begin
       label12.caption := (floattostrF(xp,ffgeneral,2,2) + ',' +floattostrF(yp,ffgeneral,2,2));
       label14.caption := (inttostr(t));
     end
     else
     begin
       label12.caption := 'Outside';
       label14.caption := 'none';
     end;
   end;
end;

procedure TForm1.xygraph1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var x1,x2,y1,y2:double;
begin
 if mousedrag then
 begin
   panel3.visible := false;
   mousedrag := false;
 end;
end;


procedure TForm1.Button4Click(Sender: TObject);
begin
 if sd.execute then
    xygraph1.debug(1,sd.filename);
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  xygraph1.addmark(1, 1.5,1.5, 1.8,1.8, clred,'Test',mtLine,drawafter);
end;

function test(x: Double; var p): Double; far;
var
  pm: double absolute p;
begin
  Result := x * x * pm;
end;

procedure TForm1.xygraph1PaintEnd(Sender: TObject; Canvas:TCanvas);
var j:double;
begin
 if not checkbox7.checked then exit;
 j := 1.2;
 xygraph1.drawfunction(test,j,0,0,clBlack,psDot,0);
end;

procedure TForm1.CheckBox7Click(Sender: TObject);
begin
 xygraph1.invalidate;
end;

procedure TForm1.Button7Click(Sender: TObject);
var result:et_interceptresult;
    i,count:word;
    p,intercepts:pspoint;
begin
 xygraph1.clearmarks;
 xygraph1[1].Getintercepts(strtofloat(edit9.text), result, count, intercepts);
 if result <> ir_found then showmessage('No Valid intercepts available')
 else
   begin
   xygraph1.plotting := false;
   p := intercepts;
   for i := 1 to count do
    begin
     xygraph1.addmark(i, p^.x, 0,0,0, clgray, floattostr(p^.x), mtXMark, drawafter);
     p := p^.next;
    end;
   end;
 xygraph1.plotting := true;
 xygraph1[1].disposeintercepts(intercepts);
end;

procedure TForm1.Button8Click(Sender: TObject);
begin
 xygraph1.clearmarks;
end;

procedure TForm1.CheckBox8Click(Sender: TObject);
var s:string;
begin
  xygraph1.xaxis.showastime := checkbox8.checked;
  DateTimeToString(s, 'hh:mm:ss, dd/mm/yy',
    xygraph1.xaxis.Min);
  exmin.text := s;
  DateTimeToString(s, 'hh:mm:ss, dd/mm/yy',
    xygraph1.xaxis.Max);
  exmax.text := s;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
var st1:TDataStats;
    st2: TCompStats;
    ts:tstringlist;
begin
 st1 := xygraph1[1].Ystats;
 with statsform.yMemo.lines do
   begin
   clear;
   add('Y Data Analysis for series 1');
   add('----------------------------');
   if not st1.error then
     begin
     add('');
     add('There is ' + inttostr(st1.count) + ' points in the series');
     add('  mean:    ' + floattostrF(st1.mean,ffgeneral,4,2));
     add('  mode:    ' + floattostrF(st1.mode,ffgeneral,4,2));
     add('  Total:   ' + floattostrF(st1.Total,ffgeneral,4,2));
     add('  SD:      ' + floattostrF(st1.SD,ffgeneral,4,2));
     add('  Skew:    ' + floattostrF(st1.skew,ffgeneral,4,2));
     add('  Kurtosis: ' + floattostrF(st1.kurtosis,ffgeneral,4,2));
     add('  lowquintile:  ' + floattostrF(st1.lowquintile,ffgeneral,4,2));
     add('  lowquartile:  ' + floattostrF(st1.lowquartile,ffgeneral,4,2));
     add('  median:       ' + floattostrF(st1.median,ffgeneral,4,2));
     add('  highquartile: ' + floattostrF(st1.highquartile,ffgeneral,4,2));
     add('  highquintile: ' + floattostrF(st1.highquintile,ffgeneral,4,2));
     end;
   if st1.comment <> '' then
     begin
     add('');
     add(st1.comment);
     end;
   end;
 st1 := xygraph1[1].Xstats;
 with statsform.XMemo.lines do
   begin
   clear;
   add('X Data Analysis for series 1');
   add('----------------------------');
   if not st1.error then
     begin
     add('');
     add('There is ' + inttostr(st1.count) + ' points in the series');
     add('  mean:    ' + floattostrF(st1.mean,ffgeneral,4,2));
     add('  mode:    ' + floattostrF(st1.mode,ffgeneral,4,2));
     add('  Total:   ' + floattostrF(st1.Total,ffgeneral,4,2));
     add('  SD:      ' + floattostrF(st1.SD,ffgeneral,4,2));
     add('  Skew:    ' + floattostrF(st1.skew,ffgeneral,4,2));
     add('  Kurtosis: ' + floattostrF(st1.kurtosis,ffgeneral,4,2));
     add('  lowquintile:  ' + floattostrF(st1.lowquintile,ffgeneral,4,2));
     add('  lowquartile:  ' + floattostrF(st1.lowquartile,ffgeneral,4,2));
     add('  median:       ' + floattostrF(st1.median,ffgeneral,4,2));
     add('  highquartile: ' + floattostrF(st1.highquartile,ffgeneral,4,2));
     add('  highquintile: ' + floattostrF(st1.highquintile,ffgeneral,4,2));
     end;
   if st1.comment <> '' then
     begin
     add('');
     add(st1.comment);
     end;
   end;
 st2 := xygraph1[1].CompStats;
 with statsform.CMemo.Lines do
   begin
   clear;
   add('Correlation between X and Y for Series 1');
   add('----------------------------------------');
   if not st2.error then
     begin
     add('');
     add('  Pearson Correlation: ' + floattostrF(st2.PearsonR,ffgeneral,4,2)
      + '  (' + floattostrF(st2.PRMin,ffgeneral,4,2) + ' to '
      + floattostrF(st2.PRMax,ffgeneral,4,2) + ')');
     add('  R Squared: ' + floattostrF(st2.RSquared,ffgeneral,4,2)
      + '  (' + floattostrF(st2.RSqMin,ffgeneral,4,2) + ' to '
      + floattostrF(st2.RSqMax,ffgeneral,4,2) + ')');
     add('  p value: ' + floattostrF(st2.PValue,ffFixed,2,3));
     add('');
     add('Regression results for Series 1');
     add('-------------------------------');
     case xygraph1[1].Regtype of
      rg_None,rg_Spline, rg_dwls, rg_RunningAverage: add('no regression data available');
      rg_Linear:add('  y = ' + floattostrF(st2.RegSlope,ffgeneral,4,2) +
                     ' * x + ' + floattostrF(st2.RegIntercept,ffgeneral,4,2));
      rg_passingBablok:
          add('  y = ' + floattostrF(st2.RegSlope,ffgeneral,4,2) + '[' 
                    + floattostrF(st2.SlopeSD,ffgeneral,4,2) + '] * x + '
                    + floattostrF(st2.RegIntercept,ffgeneral,4,2) + '['
                    + floattostrF(st2.IntSD,ffgeneral,4,2)
                    + ']  (values in [] are SD''s)');
      rg_quadratic:add('  y = ' + floattostrF(st2.RegSlope2,ffgeneral,4,2)
                    + ' * x^2 + ' + floattostrF(st2.RegSlope,ffgeneral,4,2)
                    + ' * x + ' + floattostrF(st2.RegIntercept,ffgeneral,4,2));
      end;
     end;
   if st2.comment <> '' then
     begin
     add('');
     add(st2.comment);
     end;
   end;
  statsform.showmodal;
end;

procedure TForm1.Button6Click(Sender: TObject);
begin
  xygraph1.xaxis.Reversed := not xygraph1.xaxis.Reversed;
end;

end.
