unit NoStatic;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  WinGImag;


const
   NumSysColors = 19;
   rgbBlack = 0;
   rgbWhite = $00FFFFFF;

   //*** These are the GetSysColor display element identifiers
   SysPalIndex: array [0..NumSysColors-1] of Integer = (
      COLOR_ACTIVEBORDER,
      COLOR_ACTIVECAPTION,
      COLOR_APPWORKSPACE,
      COLOR_BACKGROUND,
      COLOR_BTNFACE,
      COLOR_BTNSHADOW,
      COLOR_BTNTEXT,
      COLOR_CAPTIONTEXT,
      COLOR_GRAYTEXT,
      COLOR_HIGHLIGHT,
      COLOR_HIGHLIGHTTEXT,
      COLOR_INACTIVEBORDER,
      COLOR_INACTIVECAPTION,
      COLOR_MENU,
      COLOR_MENUTEXT,
      COLOR_SCROLLBAR,
      COLOR_WINDOW,
      COLOR_WINDOWFRAME,
      COLOR_WINDOWTEXT
   );

//*** This array translates the display elements to black and white
   MonoColors: array [0..NumSysColors-1] of TCOLORREF = (
      rgbBlack,
      rgbWhite,
      rgbWhite,
      rgbWhite,
      rgbWhite,
      rgbBlack,
      rgbBlack,
      rgbBlack,
      rgbBlack,
      rgbBlack,
      rgbWhite,
      rgbWhite,
      rgbWhite,
      rgbWhite,
      rgbBlack,
      rgbWhite,
      rgbWhite,
      rgbBlack,
      rgbBlack
  );


type
  TfNoStatic = class(TForm)
    WI: TWinGImage;
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
      FActiveApp, FActiveForm, FHadFocus: Boolean;

      procedure ActivateApplication( Sender: TObject );
      procedure DeactivateApplication( Sender: TObject );
      procedure ActiveApp;
  public
    { Public declarations }
      OldColors: array [0..NumSysColors-1] of COLORREF;
  end;

var
  fNoStatic: TfNoStatic;

implementation

{$R *.DFM}

procedure TfNoStatic.FormCreate(Sender: TObject);
var
   Cnt, X, Y, LnAdd: Integer;
   pt: PChar;
begin
   Application.OnActivate := ActivateApplication;
   Application.OnDeactivate := DeactivateApplication;
   FActiveApp := True;
   FActiveForm := False;
   FHadFocus := False;

   WI.WinG.Height := WI.Height;
   WI.WinG.Width := WI.Width;

   // init palette
   // black ...
   WI.Palette.Entries[0].peRed := 0;
   WI.Palette.Entries[0].peGreen := 0;
   WI.Palette.Entries[0].peBlue := 0;
   WI.Palette.Entries[0].peFlags := 0;
   // ... and white
   WI.Palette.Entries[255].peRed := 255;
   WI.Palette.Entries[255].peGreen := 255;
   WI.Palette.Entries[255].peBlue := 255;
   WI.Palette.Entries[255].peFlags := 0;
   // gray scale
   for Cnt := 1 to 254 do
   begin
      WI.Palette.Entries[Cnt].peRed := Cnt;
      WI.Palette.Entries[Cnt].peGreen := Cnt;
      WI.Palette.Entries[Cnt].peBlue := Cnt;
      WI.Palette.Entries[Cnt].peFlags := 1;
   end;
   WI.Palette.CreateHandle;

   // draw image
   LnAdd := WI.WinG.WidthBytes;
   for X := 1 to 254 do
   begin
      pt := WI.WinG.Pixels + X - 1;
      for Y := 0 to 199 do
      begin
         pt^ := Chr(X);
         Inc( pt, LnAdd );
      end;
   end;
end;


procedure TfNoStatic.FormDestroy(Sender: TObject);
begin
   Application.OnActivate := nil;
   Application.OnDeactivate := nil;
end;


procedure TfNoStatic.ActivateApplication( Sender: TObject );
begin
   FActiveApp := True;
   ActiveApp;
end;

procedure TfNoStatic.DeactivateApplication( Sender: TObject );
begin
   FActiveApp := False;
   ActiveApp;
end;

procedure TfNoStatic.FormActivate(Sender: TObject);
begin
   FActiveForm := True;
   ActiveApp;
end;

procedure TfNoStatic.FormDeactivate(Sender: TObject);
begin
   FActiveForm := False;
   ActiveApp;
end;



procedure TfNoStatic.ActiveApp;
var
   hdc: HDC;
   Cnt: Integer;
begin
   //*** Just use the screen DC
   hdc := GetDC(0);

   //*** If the app is activating, save the current color mapping
   //*** and switch to SYSPAL_NOSTATIC
   if ((FActiveForm = True) and (FActiveApp = True)) then
   begin
      if ((GetSystemPaletteUse(hdc) = SYSPAL_STATIC)
      and (FHadFocus = False)) then
      begin
         FHadFocus := True;

         //*** Store the current mapping
         for Cnt := 0 to NumSysColors-1 do
            OldColors[Cnt] := GetSysColor( SysPalIndex[Cnt] );

         //*** Switch to SYSPAL_NOSTATIC and remap the colors
         SetSystemPaletteUse(hdc, SYSPAL_NOSTATIC);

         SetSysColors( NumSysColors, SysPalIndex, MonoColors );

         // set system palette
         UnrealizeObject( WI.Palette.Handle );
         SelectPalette( WI.Canvas.Handle, WI.Palette.Handle, FALSE);
         RealizePalette( WI.Canvas.Handle );
      end;
   end
   else
   if (FHadFocus = True) then
   begin
      FHadFocus := False;

      //*** Always switch back to SYSPAL_STATIC and the old mapping
      SetSystemPaletteUse( hdc, SYSPAL_STATIC );

      SetSysColors( NumSysColors, SysPalIndex, OldColors );
   end;

  //*** Be sure to release the DC!
  ReleaseDC( 0, hdc );
end;

end.
