unit BlitTime;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  WinGImag, StdCtrls, WinG;

type
  TfBlitTiming = class(TForm)
    bRepaint: TButton;
    bUserBlit: TButton;
    cbIdentity: TCheckBox;
    WI: TWinGImage;
    Label1: TLabel;
    Label2: TLabel;
    procedure cbIdentityClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure bRepaintClick(Sender: TObject);
    procedure bUserBlitClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  fBlitTiming: TfBlitTiming;

implementation

{$R *.DFM}


procedure TfBlitTiming.cbIdentityClick(Sender: TObject);
begin
   WI.Palette.Identity := not(WI.Palette.Identity);
end;

procedure TfBlitTiming.FormCreate(Sender: TObject);
begin
   WI.Filename := 'Frog.bmp';
end;

procedure TfBlitTiming.bRepaintClick(Sender: TObject);
var
   ts, tf: Longint;
   Cnt: Integer;
begin
   ts := GetTickCount;
   for Cnt := 0 to 1000 do
      WI.Repaint;
   tf := GetTickCount;

   Application.MessageBox( Pointer(IntToStr((1000*1000) div (tf-ts))
      + ' blits/sec.'), 'Result', MB_OK );
end;

procedure TfBlitTiming.bUserBlitClick(Sender: TObject);
var
   ts, tf: Longint;
   Cnt: Integer;
   oldhPal: HPALETTE;
begin
   with WI do
   begin
      oldhPal := SelectPalette( Canvas.Handle, Palette.Handle, false );
      RealizePalette( Canvas.Handle );

      ts := GetTickCount;
      for Cnt := 0 to 1000 do
         WinGStretchBlt( Canvas.Handle, 0, 0, Width, Height, WinG.Handle,
          0, 0, WinG.Width, WinG.Height );
      tf := GetTickCount;

      SelectPalette( Canvas.Handle, oldhPal, false );
   end;

   Application.MessageBox( Pointer(IntToStr((1000*1000) div (tf-ts))
      + ' blits/sec.'), 'Result', MB_OK );
end;

end.
