{***********************************************************}
{                                                           }
{         TURLLabel component                               }
{                                                           }
{         Copyright (C) 1997, by Jan Goyvaerts              }
{         All rights reserved                               }
{                                                           }
{***********************************************************}

{***************************************************************}
{                                                               }
{    TURLLabel is a component that will fire up the URL         }
{    set in the URL property when it is clicked on.             }
{                                                               }
{    Note that in order for the component to work properly,     }
{    the URL file types (see View|Options in Windows Explorer)  }
{    have to be associated with your web browser.               }
{    If this is not the case, nothing will happen when the      }
{    URLLabel is clicked on.                                    }
{                                                               }
{    This component is freeware, which means that you can use   }
{    in your applications free of charge.                       }
{    You can freely make copies of the TURLLabel component,     }
{    on the strict condition that all files are included and    }
{    remain unmodified and that no files have been added to     }
{    the package.                                               }
{    This means that if you enhance the TURLLabel component,    }
{    you are absolutely NOT allowed to distribute it.           }
{    You may also NOT use this source code to build your own    }
{    URL label component.                                       }
{                                                               }
{    For comments, questions and suggestions, contact the       }
{    author at johnfg@tornado.be                                }
{                                                               }
{***************************************************************}

unit URLLabel;

interface

{$IFNDEF WIN32}
  Sorry, but this component runs only under a 32-bit windows version
{$ENDIF}

uses
  Windows, ShellAPI, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, StdCtrls;

type
  TURLLabel = class(TLabel)
  private
    FColorNormal, FColorMoveOver, FColorClick: TColor;
    Down: Boolean;
    FURL: string;
  protected
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
    procedure CMMouseEnter(var Msg: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var Msg: TMessage); message CM_MOUSELEAVE;
  public
    constructor Create(AOwner: TComponent); override;
  published
    property ColorNormal: TColor read FColorNormal write FColorNormal default clBlue;
    property ColorMoveOver: TColor read FColorMoveOver write FColorMoveOver default clBlue;
    property ColorClick: TColor read FColorClick write FColorClick default clRed;
    property URL: string read FURL write FURL;
  end;

procedure Register;

implementation

         { ********* Unit support routines ********* }

procedure Register;
begin
  RegisterComponents('JG', [TURLLabel]);
end;

         { ********* TURLLabel component ********* }

      { ****** TURLLabel protected methods ****** }

procedure TURLLabel.MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  Down := True; Font.Color := ColorClick;
end;

procedure TURLLabel.MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if (X >= 0) and (Y >= 0) and (Y <= Height) and (X <= Width) then begin
    if Down then
      if URL <> '' then ShellExecute(ValidParentForm(Self).Handle, 'open', PChar(FURL), nil, nil, SW_SHOW)
        else ShellExecute(ValidParentForm(Self).Handle, 'open', PChar(Caption), nil, nil, SW_SHOW);
    Font.Color := ColorMoveOver
  end
  else Font.Color := ColorNormal;
  Down := False
end;

procedure TURLLabel.CMMouseEnter(var Msg: TMessage);
begin
  if Down then Font.Color := ColorClick else Font.Color := ColorMoveOver;
end;

procedure TURLLabel.CMMouseLeave(var Msg: TMessage);
begin
  Font.Color := ColorNormal
end;

      { ****** TURLLabel public methods ****** }

constructor TURLLabel.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Font.Color := clBlue; Font.Style := [fsUnderline];
  FColorNormal := clBlue; FColorMoveOver := clBlue; FColorClick := clRed;
  Caption := 'Click me!';
  URL := 'http://www.tornado.be/~johnfg/';
end;

end.
